/*
 * Decompiled with CFR 0.152.
 */
package com.github.nanoflakes;

import com.github.nanoflakes.CompatJvmKt;
import com.github.nanoflakes.Nanoflake;
import com.github.nanoflakes.NanoflakeGenerator;
import java.time.OffsetDateTime;
import java.util.Arrays;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/nanoflakes/NanoflakeLocalGenerator;", "Lcom/github/nanoflakes/NanoflakeGenerator;", "epoch", "", "generatorId", "(JJ)V", "lastTimestamp", "sequence", "epochMillis", "equals", "", "other", "", "hashCode", "", "next", "Lcom/github/nanoflakes/Nanoflake;", "tilNextMillis", "toString", "", "nanoflakes-kotlin"})
public final class NanoflakeLocalGenerator
implements NanoflakeGenerator {
    private final long epoch;
    private final long generatorId;
    private long lastTimestamp;
    private long sequence;

    public NanoflakeLocalGenerator(long epoch, long generatorId) {
        this.epoch = epoch;
        this.generatorId = generatorId;
        this.lastTimestamp = -1L;
        boolean bl = this.epoch <= CompatJvmKt.currentTimeMillis();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Specified epoch is on the future.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long l = this.generatorId;
        boolean bl5 = 0L <= l ? l <= 1023L : false;
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "Invalid generator id, outside of [0, 1023] range";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Nanoflake next() {
        long timestamp = 0L;
        timestamp = CompatJvmKt.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate for " + (this.lastTimestamp - timestamp) + "milliseconds.");
        }
        boolean $i$f$maybeSynchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            if (this.lastTimestamp != timestamp) {
                this.sequence = 0L;
            } else {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            }
            this.lastTimestamp = timestamp;
            long value = timestamp - this.epoch << 24 | this.generatorId << 12 | this.sequence;
            Nanoflake nanoflake = new Nanoflake(this.epoch, value);
            return nanoflake;
        }
    }

    @Override
    public long epochMillis() {
        return this.epoch;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof NanoflakeLocalGenerator)) {
            return false;
        }
        return this.epoch == ((NanoflakeLocalGenerator)other).epoch && this.generatorId == ((NanoflakeLocalGenerator)other).generatorId;
    }

    public int hashCode() {
        Object[] objectArray = new Long[]{this.epoch, this.generatorId};
        boolean bl = false;
        return Arrays.hashCode(objectArray);
    }

    @NotNull
    public String toString() {
        return "NanoflakeLocalGenerator{epoch=" + this.epoch + ", generatorId=" + this.generatorId + ", lastTimestamp=" + this.lastTimestamp + ", sequence=" + this.sequence + '}';
    }

    private final long tilNextMillis(long lastTimestamp) {
        long timestamp = CompatJvmKt.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = CompatJvmKt.currentTimeMillis();
        }
        return timestamp;
    }

    @Override
    @NotNull
    public OffsetDateTime epoch(@NotNull NanoflakeGenerator $this$epoch) {
        return NanoflakeGenerator.DefaultImpls.epoch(this, $this$epoch);
    }
}

