/*
 * Decompiled with CFR 0.152.
 */
package com.github.nanoflakes;

import com.github.nanoflakes.CompatJvmKt;
import com.github.nanoflakes.Nanoflakes;
import java.time.OffsetDateTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0006J\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u0006\u0010\u0010\u001a\u00020\u0003J\n\u0010\u0002\u001a\u00060\u000ej\u0002`\u000fJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/nanoflakes/Nanoflake;", "", "epoch", "", "value", "(JJ)V", "", "(JLjava/lang/String;)V", "radix", "", "(JLjava/lang/String;I)V", "asLong", "asString", "creationTime", "Ljava/time/OffsetDateTime;", "Lcom/github/nanoflakes/DateTime;", "creationTimeMillis", "epochMillis", "equals", "", "other", "hashCode", "toString", "withRadix", "nanoflakes-kotlin"})
public final class Nanoflake {
    private final long epoch;
    private final long value;

    public Nanoflake(long epoch, long value) {
        this.epoch = epoch;
        this.value = value;
    }

    public Nanoflake(long epoch, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.epoch = epoch;
        String string = value;
        boolean bl = false;
        this.value = Long.parseLong(string);
    }

    public Nanoflake(long epoch, @NotNull String value, int radix) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.epoch = epoch;
        String string = value;
        boolean bl = false;
        this.value = Long.parseLong(string, CharsKt.checkRadix((int)radix));
    }

    public final long asLong() {
        return this.value;
    }

    @NotNull
    public final String asString() {
        return String.valueOf(this.value);
    }

    @NotNull
    public final String withRadix(int radix) {
        long l = this.value;
        boolean bl = false;
        String string = Long.toString(l, CharsKt.checkRadix((int)radix));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        return string;
    }

    @NotNull
    public final OffsetDateTime creationTime() {
        return CompatJvmKt.toDateTime(this.creationTimeMillis());
    }

    public final long creationTimeMillis() {
        return this.epoch + Nanoflakes.INSTANCE.timestampValue(this.value);
    }

    public final long epochMillis() {
        return this.epoch;
    }

    @NotNull
    public final OffsetDateTime epoch() {
        return CompatJvmKt.toDateTime(this.epochMillis());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof Nanoflake)) {
            return false;
        }
        return this.epoch == ((Nanoflake)other).epoch && this.value == ((Nanoflake)other).value;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.epoch, this.value};
        boolean bl = false;
        return Arrays.hashCode(objectArray);
    }

    @NotNull
    public String toString() {
        return "Nanoflake{epoch=" + this.epoch + ", value=" + this.value + '}';
    }
}

