(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'nanoflakes-kotlin-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'nanoflakes-kotlin-js-legacy'.");
    }root['nanoflakes-kotlin-js-legacy'] = factory(typeof this['nanoflakes-kotlin-js-legacy'] === 'undefined' ? {} : this['nanoflakes-kotlin-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var toString = Kotlin.kotlin.text.toString_if0zpk$;
  var equals = Kotlin.equals;
  var contentHashCode = Kotlin.arrayHashCode;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var toLong_0 = Kotlin.kotlin.text.toLong_6ic1pp$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var toString_0 = Kotlin.toString;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var L0 = Kotlin.Long.ZERO;
  var L_1 = Kotlin.Long.NEG_ONE;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var L1023 = Kotlin.Long.fromInt(1023);
  var L4095 = Kotlin.Long.fromInt(4095);
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  function Nanoflake() {
    this.epoch_0 = null;
    this.value_0 = null;
  }
  Nanoflake.prototype.asLong = function () {
    return this.value_0;
  };
  Nanoflake.prototype.asString = function () {
    return this.value_0.toString();
  };
  Nanoflake.prototype.withRadix_za3lpa$ = function (radix) {
    return toString(this.value_0, radix);
  };
  Nanoflake.prototype.creationTime = function () {
    return toDateTime(this.creationTimeMillis());
  };
  Nanoflake.prototype.creationTimeMillis = function () {
    return this.epoch_0.add(Nanoflakes_getInstance().timestampValue_s8cxhz$(this.value_0));
  };
  Nanoflake.prototype.epochMillis = function () {
    return this.epoch_0;
  };
  Nanoflake.prototype.epoch = function () {
    return toDateTime(this.epochMillis());
  };
  Nanoflake.prototype.equals = function (other) {
    if (this === other)
      return true;
    if (other == null || !Kotlin.isType(other, Nanoflake))
      return false;
    return equals(this.epoch_0, other.epoch_0) && equals(this.value_0, other.value_0);
  };
  Nanoflake.prototype.hashCode = function () {
    return contentHashCode([this.epoch_0, this.value_0]);
  };
  Nanoflake.prototype.toString = function () {
    return 'Nanoflake{epoch=' + this.epoch_0.toString() + ', value=' + this.value_0.toString() + '}';
  };
  Nanoflake.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Nanoflake',
    interfaces: []
  };
  function Nanoflake_init(epoch, value, $this) {
    $this = $this || Object.create(Nanoflake.prototype);
    Nanoflake.call($this);
    $this.epoch_0 = epoch;
    $this.value_0 = value;
    return $this;
  }
  function Nanoflake_init_0(epoch, value, $this) {
    $this = $this || Object.create(Nanoflake.prototype);
    Nanoflake.call($this);
    $this.epoch_0 = epoch;
    $this.value_0 = toLong(value);
    return $this;
  }
  function Nanoflake_init_1(epoch, value, radix, $this) {
    $this = $this || Object.create(Nanoflake.prototype);
    Nanoflake.call($this);
    $this.epoch_0 = epoch;
    $this.value_0 = toLong_0(value, radix);
    return $this;
  }
  function NanoflakeGenerator() {
  }
  NanoflakeGenerator.prototype.epoch_aoj9r5$ = function ($receiver) {
    return toDateTime($receiver.epochMillis());
  };
  NanoflakeGenerator.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'NanoflakeGenerator',
    interfaces: []
  };
  function NanoflakeLocalGenerator(epoch, generatorId) {
    this.epoch_0 = epoch;
    this.generatorId_0 = generatorId;
    this.lastTimestamp_0 = L_1;
    this.sequence_0 = L0;
    if (!(this.epoch_0.compareTo_11rb$(currentTimeMillis()) <= 0)) {
      var message = 'Specified epoch is on the future.';
      throw IllegalArgumentException_init(message.toString());
    }if (!Kotlin.Long.fromInt(0).rangeTo(Nanoflakes_getInstance().MAX_GENERATOR_ID).contains_mef7kx$(this.generatorId_0)) {
      var message_0 = 'Invalid generator id, outside of [0, 1023] range';
      throw IllegalArgumentException_init(message_0.toString());
    }}
  NanoflakeLocalGenerator.prototype.next = function () {
    var timestamp = {v: currentTimeMillis()};
    if (timestamp.v.compareTo_11rb$(this.lastTimestamp_0) < 0) {
      throw RuntimeException_init('Clock moved backwards. Refusing to generate for ' + toString_0(this.lastTimestamp_0.subtract(timestamp.v)) + 'milliseconds.');
    }if (!equals(this.lastTimestamp_0, timestamp.v)) {
      this.sequence_0 = L0;
    } else {
      this.sequence_0 = this.sequence_0.add(Kotlin.Long.fromInt(1)).and(Nanoflakes_getInstance().MAX_SEQUENCE);
      if (equals(this.sequence_0, L0))
        timestamp.v = this.tilNextMillis_0(this.lastTimestamp_0);
    }
    this.lastTimestamp_0 = timestamp.v;
    var value = timestamp.v.subtract(this.epoch_0).shiftLeft(24).or(this.generatorId_0.shiftLeft(12)).or(this.sequence_0);
    return Nanoflake_init(this.epoch_0, value);
  };
  NanoflakeLocalGenerator.prototype.epochMillis = function () {
    return this.epoch_0;
  };
  NanoflakeLocalGenerator.prototype.equals = function (other) {
    if (this === other)
      return true;
    if (other == null || !Kotlin.isType(other, NanoflakeLocalGenerator))
      return false;
    return equals(this.epoch_0, other.epoch_0) && equals(this.generatorId_0, other.generatorId_0);
  };
  NanoflakeLocalGenerator.prototype.hashCode = function () {
    return contentHashCode([this.epoch_0, this.generatorId_0]);
  };
  NanoflakeLocalGenerator.prototype.toString = function () {
    return 'NanoflakeLocalGenerator{epoch=' + this.epoch_0.toString() + ', generatorId=' + this.generatorId_0.toString() + ', lastTimestamp=' + this.lastTimestamp_0.toString() + ', sequence=' + this.sequence_0.toString() + '}';
  };
  NanoflakeLocalGenerator.prototype.tilNextMillis_0 = function (lastTimestamp) {
    var timestamp = currentTimeMillis();
    while (timestamp.compareTo_11rb$(lastTimestamp) <= 0)
      timestamp = currentTimeMillis();
    return timestamp;
  };
  NanoflakeLocalGenerator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NanoflakeLocalGenerator',
    interfaces: [NanoflakeGenerator]
  };
  function Nanoflakes() {
    Nanoflakes_instance = this;
    this.TIMESTAMP_BITS = 14;
    this.GENERATOR_ID_BITS = 10;
    this.SEQUENCE_BITS = 12;
    this.MAX_GENERATOR_ID = L1023;
    this.MAX_SEQUENCE = L4095;
    this.GENERATOR_ID_SHIFT = 12;
    this.TIMESTAMP_SHIFT = 24;
  }
  Nanoflakes.prototype.localGenerator_3pjtqy$ = function (epoch, generatorId) {
    return new NanoflakeLocalGenerator(epoch, generatorId);
  };
  Nanoflakes.prototype.timestampValue_s8cxhz$ = function (id) {
    return id.shiftRight(24);
  };
  Nanoflakes.prototype.generatorValue_s8cxhz$ = function (id) {
    return id.shiftRight(12).and(this.MAX_GENERATOR_ID);
  };
  Nanoflakes.prototype.sequenceValue_s8cxhz$ = function (id) {
    return id.and(this.MAX_SEQUENCE);
  };
  Nanoflakes.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Nanoflakes',
    interfaces: []
  };
  var Nanoflakes_instance = null;
  function Nanoflakes_getInstance() {
    if (Nanoflakes_instance === null) {
      new Nanoflakes();
    }return Nanoflakes_instance;
  }
  function currentTimeMillis() {
    return Kotlin.Long.fromNumber((new Date()).getTime());
  }
  var maybeSynchronized = defineInlineFunction('nanoflakes-kotlin-js-legacy.com.github.nanoflakes.maybeSynchronized_eocq09$', function (lock, block) {
    return block();
  });
  function toDateTime($receiver) {
    return new Date($receiver);
  }
  var package$com = _.com || (_.com = {});
  var package$github = package$com.github || (package$com.github = {});
  var package$nanoflakes = package$github.nanoflakes || (package$github.nanoflakes = {});
  package$nanoflakes.Nanoflake_init_3pjtqy$ = Nanoflake_init;
  package$nanoflakes.Nanoflake_init_a4hdmt$ = Nanoflake_init_0;
  package$nanoflakes.Nanoflake_init_9b8t8t$ = Nanoflake_init_1;
  package$nanoflakes.Nanoflake = Nanoflake;
  package$nanoflakes.NanoflakeGenerator = NanoflakeGenerator;
  $$importsForInline$$['nanoflakes-kotlin-js-legacy'] = _;
  package$nanoflakes.NanoflakeLocalGenerator = NanoflakeLocalGenerator;
  Object.defineProperty(package$nanoflakes, 'Nanoflakes', {
    get: Nanoflakes_getInstance
  });
  package$nanoflakes.currentTimeMillis = currentTimeMillis;
  package$nanoflakes.maybeSynchronized_eocq09$ = maybeSynchronized;
  package$nanoflakes.toDateTime_mts6qi$ = toDateTime;
  NanoflakeLocalGenerator.prototype.epoch_aoj9r5$ = NanoflakeGenerator.prototype.epoch_aoj9r5$;
  Kotlin.defineModule('nanoflakes-kotlin-js-legacy', _);
  return _;
}));

//# sourceMappingURL=nanoflakes-kotlin-js-legacy.js.map
