/*
 * Decompiled with CFR 0.152.
 */
package com.github.nanoflakes;

import com.github.nanoflakes.NanoflakeGenerator;
import com.github.nanoflakes.NanoflakeLocalGenerator;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.TimeZone;

public class Nanoflakes {
    public static final long TIMESTAMP_BITS = 14L;
    public static final long GENERATOR_ID_BITS = 10L;
    public static final long SEQUENCE_BITS = 12L;
    public static final long MAX_GENERATOR_ID = 1023L;
    public static final long MAX_SEQUENCE = 4095L;
    public static final long GENERATOR_ID_SHIFT = 12L;
    public static final long TIMESTAMP_SHIFT = 24L;

    public static NanoflakeGenerator localGenerator(long epoch, long generatorId) {
        return new NanoflakeLocalGenerator(epoch, generatorId);
    }

    public static long timestampValue(long id) {
        return id >> 24;
    }

    public static long generatorValue(long id) {
        return id >> 12 & 0x3FFL;
    }

    public static long sequenceValue(long id) {
        return id & 0xFFFL;
    }

    public static OffsetDateTime toDateTime(long millis) {
        Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmt.setTimeInMillis(millis);
        return OffsetDateTime.ofInstant(gmt.toInstant(), gmt.getTimeZone().toZoneId());
    }
}

