/*
 * Decompiled with CFR 0.152.
 */
package com.github.nanoflakes;

import com.github.nanoflakes.Nanoflake;
import com.github.nanoflakes.NanoflakeGenerator;
import java.util.Objects;

public class NanoflakeLocalGenerator
implements NanoflakeGenerator {
    private final long epoch;
    private final long generatorId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    public NanoflakeLocalGenerator(long epoch, long generatorId) {
        if (epoch > System.currentTimeMillis()) {
            throw new IllegalArgumentException("Specified epoch is on the future.");
        }
        if (generatorId < 0L || generatorId > 1023L) {
            throw new IllegalArgumentException("Invalid generator id.");
        }
        this.epoch = epoch;
        this.generatorId = generatorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Nanoflake next() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate for " + (this.lastTimestamp - timestamp) + "milliseconds.");
        }
        NanoflakeLocalGenerator nanoflakeLocalGenerator = this;
        synchronized (nanoflakeLocalGenerator) {
            if (this.lastTimestamp != timestamp) {
                this.sequence = 0L;
            } else {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            }
            this.lastTimestamp = timestamp;
            long value = timestamp - this.epoch << 24 | this.generatorId << 12 | this.sequence;
            return new Nanoflake(this.epoch, value);
        }
    }

    @Override
    public long epochMillis() {
        return this.epoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NanoflakeLocalGenerator that = (NanoflakeLocalGenerator)o;
        return this.epoch == that.epoch && this.generatorId == that.generatorId;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.generatorId);
    }

    public String toString() {
        return "NanoflakeLocalGenerator{epoch=" + this.epoch + ", generatorId=" + this.generatorId + ", lastTimestamp=" + this.lastTimestamp + ", sequence=" + this.sequence + '}';
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

