/*
 * Decompiled with CFR 0.152.
 */
package com.github.nanoflakes;

import com.github.nanoflakes.Nanoflakes;
import java.time.OffsetDateTime;
import java.util.Objects;

public class Nanoflake {
    private final long epoch;
    private final long value;

    public Nanoflake(long epoch, long value) {
        this.epoch = epoch;
        this.value = value;
    }

    public Nanoflake(long epoch, String value) {
        this.epoch = epoch;
        this.value = Long.decode(value);
    }

    public Nanoflake(long epoch, String value, int radix) {
        this.epoch = epoch;
        this.value = Long.parseLong(value, radix);
    }

    public long asLong() {
        return this.value;
    }

    public String asString() {
        return Long.toString(this.value);
    }

    public String withRadix(int radix) {
        return Long.toString(this.value, radix);
    }

    public OffsetDateTime creationTime() {
        return Nanoflakes.toDateTime(this.creationTimeMillis());
    }

    public long creationTimeMillis() {
        return this.epoch + Nanoflakes.timestampValue(this.value);
    }

    public long epochMillis() {
        return this.epoch;
    }

    public OffsetDateTime epoch() {
        return Nanoflakes.toDateTime(this.epochMillis());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Nanoflake nanoflake = (Nanoflake)o;
        return this.epoch == nanoflake.epoch && this.value == nanoflake.value;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.value);
    }

    public String toString() {
        return "Nanoflake{epoch=" + this.epoch + ", value=" + this.value + '}';
    }
}

