/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.extensions.lexer;

import com.github.adriantodt.tartar.api.lexer.LexerContext;
import com.github.adriantodt.tartar.extensions.lexer.LexicalNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001f\u0010\b\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00022\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\r\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u000b\u001a\u0016\u0010\u0010\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0011\u001a\u00020\u000b\u00a8\u0006\u0012"}, d2={"fillBufferNumbers", "", "Lcom/github/adriantodt/tartar/api/lexer/LexerContext;", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "allowHex", "", "readIdentifier", "", "firstChar", "", "(Lcom/github/adriantodt/tartar/api/lexer/LexerContext;Ljava/lang/Character;)Ljava/lang/String;", "readNumber", "Lcom/github/adriantodt/tartar/extensions/lexer/LexicalNumber;", "c", "readString", "delimiter", "tartar"})
public final class LexerContextKt {
    @NotNull
    public static final String readIdentifier(@NotNull LexerContext<?> $this$readIdentifier, @Nullable Character firstChar) {
        char cc;
        Intrinsics.checkNotNullParameter($this$readIdentifier, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        Character c = firstChar;
        if (c != null) {
            char p0 = c.charValue();
            boolean bl = false;
            buf.append(p0);
        }
        while ($this$readIdentifier.hasNext() && (Character.isLetterOrDigit(cc = $this$readIdentifier.peek()) || cc == '_')) {
            buf.append(cc);
            $this$readIdentifier.next();
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    public static /* synthetic */ String readIdentifier$default(LexerContext lexerContext, Character c, int n, Object object) {
        if ((n & 1) != 0) {
            c = null;
        }
        return LexerContextKt.readIdentifier(lexerContext, c);
    }

    @NotNull
    public static final String readString(@NotNull LexerContext<?> $this$readString, char delimiter) {
        Intrinsics.checkNotNullParameter($this$readString, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        boolean eol = false;
        while ($this$readString.hasNext()) {
            char c = $this$readString.peek();
            if (c == delimiter) {
                $this$readString.next();
                eol = true;
                break;
            }
            $this$readString.next();
            buf.append(c);
        }
        if (!eol) {
            throw new IllegalStateException("Unterminated string");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    @NotNull
    public static final LexicalNumber readNumber(@NotNull LexerContext<?> $this$readNumber, char c) {
        LexicalNumber lexicalNumber;
        Intrinsics.checkNotNullParameter($this$readNumber, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        if (c == '0') {
            if ($this$readNumber.match('x')) {
                LexerContextKt.fillBufferNumbers($this$readNumber, buf, true);
                boolean isLong = $this$readNumber.match('l') || $this$readNumber.match('L');
                String string = buf.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                String s = string;
                Long l = StringsKt.toLongOrNull((String)s, (int)16);
                if (l == null) {
                    String string2 = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buf.toString()");
                    return new LexicalNumber.Invalid(string2);
                }
                long number = l;
                return new LexicalNumber.Integer(s, number, 16, isLong);
            }
            if ($this$readNumber.match('b')) {
                LexerContextKt.fillBufferNumbers($this$readNumber, buf, false);
                boolean isLong = $this$readNumber.match('l') || $this$readNumber.match('L');
                String number = buf.toString();
                Intrinsics.checkNotNullExpressionValue((Object)number, (String)"buf.toString()");
                String s = number;
                Long l = StringsKt.toLongOrNull((String)s, (int)2);
                if (l == null) {
                    String string = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                    return new LexicalNumber.Invalid(string);
                }
                long number2 = l;
                return new LexicalNumber.Integer(s, number2, 2, isLong);
            }
            buf.append('0');
        } else {
            buf.append(c);
        }
        LexerContextKt.fillBufferNumbers($this$readNumber, buf, false);
        if ($this$readNumber.peek() == '.' && Character.isDigit($this$readNumber.peek(1))) {
            $this$readNumber.next();
            buf.append('.');
            LexerContextKt.fillBufferNumbers($this$readNumber, buf, false);
            boolean isFloat = $this$readNumber.match('f') || $this$readNumber.match('F');
            String number2 = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)number2, (String)"buf.toString()");
            String s = number2;
            lexicalNumber = new LexicalNumber.Decimal(s, Double.parseDouble(s), isFloat);
        } else {
            String s = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)s, (String)"buf.toString()");
            String s2 = s;
            Long l = StringsKt.toLongOrNull((String)s2);
            if ($this$readNumber.match('f') || $this$readNumber.match('F')) {
                lexicalNumber = new LexicalNumber.Decimal(s2, Double.parseDouble(s2), true);
            } else if (l != null) {
                boolean isLong = $this$readNumber.match('l') || $this$readNumber.match('L');
                lexicalNumber = new LexicalNumber.Integer(s2, l, 10, isLong);
            } else {
                String string = buf.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                lexicalNumber = new LexicalNumber.Invalid(string);
            }
        }
        return lexicalNumber;
    }

    private static final void fillBufferNumbers(LexerContext<?> $this$fillBufferNumbers, StringBuilder buf, boolean allowHex) {
        while ($this$fillBufferNumbers.hasNext()) {
            char c = $this$fillBufferNumbers.peek();
            if (!Character.isDigit(c)) {
                if (!allowHex) break;
                if (!('A' <= c ? c < 'G' : false)) {
                    boolean bl = 'a' <= c ? c < 'g' : false;
                    if (!bl) break;
                }
            }
            buf.append($this$fillBufferNumbers.next());
        }
    }
}

