/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.api.lexer;

import com.github.adriantodt.tartar.impl.InternalExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006 "}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Source;", "", "content", "", "name", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "bounds", "Lkotlin/ranges/IntRange;", "getBounds", "()Lkotlin/ranges/IntRange;", "getContent", "()Ljava/lang/String;", "lines", "", "Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "getLines", "()Ljava/util/List;", "getName", "getPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Line", "tartar"})
public final class Source {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @NotNull
    private final String name;
    @NotNull
    private final String path;
    @NotNull
    private final List<Line> lines;

    /*
     * WARNING - void declaration
     */
    public Source(@NotNull String content, @NotNull String name, @NotNull String path) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.content = content;
        this.name = name;
        this.path = path;
        Iterable iterable = InternalExtensionsKt.calculateLineRanges(this.content);
        Source source = this;
        boolean $i$f$mapIndexed = false;
        void var6_7 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void range;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IntRange intRange = (IntRange)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Line((int)(index + true), StringsKt.substring((String)this.getContent(), (IntRange)range), (IntRange)range));
        }
        source.lines = (List)destination$iv$iv;
    }

    public /* synthetic */ Source(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "?";
        }
        if ((n & 4) != 0) {
            string3 = "!!no path!!";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final List<Line> getLines() {
        return this.lines;
    }

    @NotNull
    public final IntRange getBounds() {
        return new IntRange(0, this.content.length());
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.path;
    }

    @NotNull
    public final Source copy(@NotNull String content, @NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Source(content, name, path);
    }

    public static /* synthetic */ Source copy$default(Source source, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = source.content;
        }
        if ((n & 2) != 0) {
            string2 = source.name;
        }
        if ((n & 4) != 0) {
            string3 = source.path;
        }
        return source.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "Source(content=" + this.content + ", name=" + this.name + ", path=" + this.path + ")";
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.path.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Source)) {
            return false;
        }
        Source source = (Source)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)source.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)source.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)source.path);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "", "lineNumber", "", "content", "", "range", "Lkotlin/ranges/IntRange;", "(ILjava/lang/String;Lkotlin/ranges/IntRange;)V", "getContent", "()Ljava/lang/String;", "getLineNumber", "()I", "getRange", "()Lkotlin/ranges/IntRange;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "tartar"})
    public static final class Line {
        private final int lineNumber;
        @NotNull
        private final String content;
        @NotNull
        private final IntRange range;

        public Line(int lineNumber, @NotNull String content, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.lineNumber = lineNumber;
            this.content = content;
            this.range = range;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        public final int component1() {
            return this.lineNumber;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final IntRange component3() {
            return this.range;
        }

        @NotNull
        public final Line copy(int lineNumber, @NotNull String content, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new Line(lineNumber, content, range);
        }

        public static /* synthetic */ Line copy$default(Line line, int n, String string, IntRange intRange, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = line.lineNumber;
            }
            if ((n2 & 2) != 0) {
                string = line.content;
            }
            if ((n2 & 4) != 0) {
                intRange = line.range;
            }
            return line.copy(n, string, intRange);
        }

        @NotNull
        public String toString() {
            return "Line(lineNumber=" + this.lineNumber + ", content=" + this.content + ", range=" + this.range + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.lineNumber);
            result = result * 31 + this.content.hashCode();
            result = result * 31 + this.range.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            Line line = (Line)other;
            if (this.lineNumber != line.lineNumber) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)line.content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)line.range);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Source$Companion;", "", "()V", "tartar"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

