/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.api.lexer;

import com.github.adriantodt.tartar.api.lexer.Source;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J'\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\b\u0010(\u001a\u00020\u001cH\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Section;", "", "source", "Lcom/github/adriantodt/tartar/api/lexer/Source;", "index", "", "length", "(Lcom/github/adriantodt/tartar/api/lexer/Source;II)V", "firstLine", "Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "getFirstLine", "()Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "getIndex", "()I", "lastLine", "getLastLine", "getLength", "lines", "", "getLines", "()Ljava/util/List;", "range", "Lkotlin/ranges/IntRange;", "getRange", "()Lkotlin/ranges/IntRange;", "getSource", "()Lcom/github/adriantodt/tartar/api/lexer/Source;", "substring", "", "getSubstring", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "span", "toString", "tartar"})
public final class Section {
    @NotNull
    private final Source source;
    private final int index;
    private final int length;
    @NotNull
    private final List<Source.Line> lines;

    /*
     * WARNING - void declaration
     */
    public Section(@NotNull Source source, int index, int length) {
        void $this$takeWhile$iv;
        Iterable $this$dropWhile$iv;
        int $i$a$-require-Section$32;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.index = index;
        this.length = length;
        Object sourceBounds = this.source.getBounds();
        int n = sourceBounds.getFirst();
        int n2 = sourceBounds.getLast();
        int n3 = this.index;
        if (!(n <= n3 ? n3 <= n2 : false)) {
            $i$a$-require-Section$32 = 0;
            String $i$a$-require-Section$32 = "Section index (" + this.getIndex() + ") must be within content's bounds (0.." + this.getSource().getContent().length() + ")";
            throw new IllegalArgumentException($i$a$-require-Section$32.toString());
        }
        int end = this.index + this.length;
        $i$a$-require-Section$32 = sourceBounds.getFirst();
        if (!(end <= sourceBounds.getLast() ? $i$a$-require-Section$32 <= end : false)) {
            boolean $i$a$-require-Section$42 = false;
            String $i$a$-require-Section$42 = "Section end (" + end + ") must be within content's bounds (0.." + this.getSource().getContent().length() + ")";
            throw new IllegalArgumentException($i$a$-require-Section$42.toString());
        }
        sourceBounds = this.source.getLines();
        Section section = this;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            Source.Line it = (Source.Line)item$iv;
            boolean bl = false;
            if (this.getIndex() > it.getRange().getLast()) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $this$dropWhile$iv = list$iv;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv2 = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Source.Line it = (Source.Line)item$iv;
            boolean bl = false;
            if (!(this.getIndex() + this.getLength() > it.getRange().getFirst())) break;
            list$iv2.add(item$iv);
        }
        section.lines = list$iv2;
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final IntRange getRange() {
        return new IntRange(this.index, this.index + this.length);
    }

    @NotNull
    public final String getSubstring() {
        String string = this.source.getContent().substring(this.index, this.index + this.length);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @NotNull
    public final List<Source.Line> getLines() {
        return this.lines;
    }

    @NotNull
    public final Source.Line getFirstLine() {
        return (Source.Line)CollectionsKt.first(this.lines);
    }

    @NotNull
    public final Source.Line getLastLine() {
        return (Source.Line)CollectionsKt.last(this.lines);
    }

    @NotNull
    public final Section span(@NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.source, (Object)other.source)) {
            boolean $i$a$-require-Section$span$22 = false;
            String $i$a$-require-Section$span$22 = "Sections " + this + " and " + other + " have different sources and thus can't be spanned.";
            throw new IllegalArgumentException($i$a$-require-Section$span$22.toString());
        }
        int start = Math.min(this.getRange().getFirst(), other.getRange().getFirst());
        int end = Math.max(this.getRange().getLast(), other.getRange().getLast());
        return new Section(this.source, start, end - start);
    }

    @NotNull
    public String toString() {
        return "(" + this.source.getName() + ":" + this.getFirstLine().getLineNumber() + ":" + (this.index - this.getFirstLine().getRange().getFirst()) + ")";
    }

    @NotNull
    public final Source component1() {
        return this.source;
    }

    public final int component2() {
        return this.index;
    }

    public final int component3() {
        return this.length;
    }

    @NotNull
    public final Section copy(@NotNull Source source, int index, int length) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new Section(source, index, length);
    }

    public static /* synthetic */ Section copy$default(Section section, Source source, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            source = section.source;
        }
        if ((n3 & 2) != 0) {
            n = section.index;
        }
        if ((n3 & 4) != 0) {
            n2 = section.length;
        }
        return section.copy(source, n, n2);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + Integer.hashCode(this.index);
        result = result * 31 + Integer.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Section)) {
            return false;
        }
        Section section = (Section)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)section.source)) {
            return false;
        }
        if (this.index != section.index) {
            return false;
        }
        return this.length == section.length;
    }
}

