/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.api.lexer;

import com.github.adriantodt.tartar.impl.InternalExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Source;", "", "content", "", "name", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "lines", "", "Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "getLines", "()Ljava/util/List;", "lines$delegate", "Lkotlin/Lazy;", "getName", "getPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Line", "tartar"})
public final class Source {
    @NotNull
    private final String content;
    @NotNull
    private final String name;
    @NotNull
    private final String path;
    @NotNull
    private final Lazy lines$delegate;

    public Source(@NotNull String content, @NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.content = content;
        this.name = name;
        this.path = path;
        this.lines$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Line>>(this){
            final /* synthetic */ Source this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Line> invoke() {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Iterable iterable = InternalExtensionsKt.calculateLineRanges(this.this$0.getContent());
                Source source = this.this$0;
                boolean $i$f$mapIndexed = false;
                void var4_4 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void range2;
                    void index;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IntRange intRange = (IntRange)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Line line = new Line((int)(index + true), StringsKt.substring((String)source.getContent(), (IntRange)range2), (IntRange)range2);
                    collection.add(line);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    public /* synthetic */ Source(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "?";
        }
        if ((n & 4) != 0) {
            string3 = "!!no path!!";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final List<Line> getLines() {
        Lazy lazy = this.lines$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.path;
    }

    @NotNull
    public final Source copy(@NotNull String content, @NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Source(content, name, path);
    }

    public static /* synthetic */ Source copy$default(Source source, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = source.content;
        }
        if ((n & 2) != 0) {
            string2 = source.name;
        }
        if ((n & 4) != 0) {
            string3 = source.path;
        }
        return source.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "Source(content=" + this.content + ", name=" + this.name + ", path=" + this.path + ")";
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.path.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Source)) {
            return false;
        }
        Source source = (Source)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)source.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)source.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)source.path);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "", "lineNumber", "", "content", "", "range", "Lkotlin/ranges/IntRange;", "(ILjava/lang/String;Lkotlin/ranges/IntRange;)V", "getContent", "()Ljava/lang/String;", "getLineNumber", "()I", "getRange", "()Lkotlin/ranges/IntRange;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "tartar"})
    public static final class Line {
        private final int lineNumber;
        @NotNull
        private final String content;
        @NotNull
        private final IntRange range;

        public Line(int lineNumber, @NotNull String content, @NotNull IntRange range2) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            this.lineNumber = lineNumber;
            this.content = content;
            this.range = range2;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        public final int component1() {
            return this.lineNumber;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final IntRange component3() {
            return this.range;
        }

        @NotNull
        public final Line copy(int lineNumber, @NotNull String content, @NotNull IntRange range2) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            return new Line(lineNumber, content, range2);
        }

        public static /* synthetic */ Line copy$default(Line line, int n, String string, IntRange intRange, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = line.lineNumber;
            }
            if ((n2 & 2) != 0) {
                string = line.content;
            }
            if ((n2 & 4) != 0) {
                intRange = line.range;
            }
            return line.copy(n, string, intRange);
        }

        @NotNull
        public String toString() {
            return "Line(lineNumber=" + this.lineNumber + ", content=" + this.content + ", range=" + this.range + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.lineNumber);
            result = result * 31 + this.content.hashCode();
            result = result * 31 + this.range.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            Line line = (Line)other;
            if (this.lineNumber != line.lineNumber) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)line.content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)line.range);
        }
    }
}

