/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.api.lexer;

import com.github.adriantodt.tartar.api.lexer.Source;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J'\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0005H\u00d6\u0001J\u000e\u00102\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000J\b\u00103\u001a\u00020&H\u0016R\u001b\u0010\b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\f\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\f\u001a\u0004\b \u0010\nR\u001b\u0010\"\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\f\u001a\u0004\b#\u0010\nR\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\f\u001a\u0004\b'\u0010(\u00a8\u00064"}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Section;", "", "source", "Lcom/github/adriantodt/tartar/api/lexer/Source;", "index", "", "length", "(Lcom/github/adriantodt/tartar/api/lexer/Source;II)V", "endLineIndex", "getEndLineIndex", "()I", "endLineIndex$delegate", "Lkotlin/Lazy;", "endLineNumber", "getEndLineNumber", "endLineNumber$delegate", "getIndex", "getLength", "lines", "", "Lcom/github/adriantodt/tartar/api/lexer/Source$Line;", "getLines", "()Ljava/util/List;", "lines$delegate", "range", "Lkotlin/ranges/IntRange;", "getRange", "()Lkotlin/ranges/IntRange;", "range$delegate", "getSource", "()Lcom/github/adriantodt/tartar/api/lexer/Source;", "startLineIndex", "getStartLineIndex", "startLineIndex$delegate", "startLineNumber", "getStartLineNumber", "startLineNumber$delegate", "substring", "", "getSubstring", "()Ljava/lang/String;", "substring$delegate", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "span", "toString", "tartar"})
public final class Section {
    @NotNull
    private final Source source;
    private final int index;
    private final int length;
    @NotNull
    private final Lazy range$delegate;
    @NotNull
    private final Lazy substring$delegate;
    @NotNull
    private final Lazy lines$delegate;
    @NotNull
    private final Lazy startLineNumber$delegate;
    @NotNull
    private final Lazy startLineIndex$delegate;
    @NotNull
    private final Lazy endLineNumber$delegate;
    @NotNull
    private final Lazy endLineIndex$delegate;

    public Section(@NotNull Source source, int index, int length) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.index = index;
        this.length = length;
        IntRange bounds = new IntRange(0, this.source.getContent().length());
        int n = bounds.getFirst();
        int n2 = bounds.getLast();
        int n3 = this.index;
        n = n <= n3 ? (n3 <= n2 ? 1 : 0) : 0;
        n2 = 0;
        n3 = 0;
        if (n == 0) {
            boolean bl = false;
            String string = "Section index (" + this.getIndex() + ") must be within content's bounds (0.." + this.getSource().getContent().length() + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int end = this.index + this.length;
        n2 = bounds.getFirst();
        n2 = end <= bounds.getLast() ? (n2 <= end ? 1 : 0) : 0;
        n3 = 0;
        boolean bl = false;
        if (n2 == 0) {
            boolean bl2 = false;
            String string = "Section end (" + end + ") must be within content's bounds (0.." + this.getSource().getContent().length() + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.range$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntRange>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IntRange invoke() {
                return new IntRange(this.this$0.getIndex(), this.this$0.getIndex() + this.this$0.getLength());
            }
        }));
        this.substring$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return StringsKt.substring((String)this.this$0.getSource().getContent(), (IntRange)this.this$0.getRange());
            }
        }));
        this.lines$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Source.Line>>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Source.Line> invoke() {
                void $this$takeWhile$iv;
                Iterable $this$dropWhile$iv;
                Iterable iterable = this.this$0.getSource().getLines();
                Section section = this.this$0;
                boolean $i$f$dropWhile = false;
                boolean yielding$iv = false;
                ArrayList<T> list$iv = new ArrayList<T>();
                for (T item$iv : $this$dropWhile$iv) {
                    if (yielding$iv) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    Source.Line it = (Source.Line)item$iv;
                    boolean bl = false;
                    if (section.getRange().getFirst() > it.getRange().getLast()) continue;
                    list$iv.add(item$iv);
                    yielding$iv = true;
                }
                $this$dropWhile$iv = list$iv;
                section = this.this$0;
                boolean $i$f$takeWhile = false;
                ArrayList<T> list$iv2 = new ArrayList<T>();
                for (T item$iv : $this$takeWhile$iv) {
                    Source.Line it = (Source.Line)item$iv;
                    boolean bl = false;
                    if (!(section.getRange().getLast() > it.getRange().getFirst())) break;
                    list$iv2.add(item$iv);
                }
                return list$iv2;
            }
        }));
        this.startLineNumber$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return ((Source.Line)CollectionsKt.first(this.this$0.getLines())).getLineNumber();
            }
        }));
        this.startLineIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getRange().getFirst() - ((Source.Line)CollectionsKt.first(this.this$0.getLines())).getRange().getFirst();
            }
        }));
        this.endLineNumber$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return ((Source.Line)CollectionsKt.last(this.this$0.getLines())).getLineNumber();
            }
        }));
        this.endLineIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Section this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getRange().getLast() - ((Source.Line)CollectionsKt.last(this.this$0.getLines())).getRange().getLast();
            }
        }));
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final IntRange getRange() {
        Lazy lazy = this.range$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (IntRange)lazy.getValue();
    }

    @NotNull
    public final String getSubstring() {
        Lazy lazy = this.substring$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final List<Source.Line> getLines() {
        Lazy lazy = this.lines$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final int getStartLineNumber() {
        Lazy lazy = this.startLineNumber$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getStartLineIndex() {
        Lazy lazy = this.startLineIndex$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getEndLineNumber() {
        Lazy lazy = this.endLineNumber$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getEndLineIndex() {
        Lazy lazy = this.endLineIndex$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final Section span(@NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean bl = Intrinsics.areEqual((Object)this.source, (Object)other.source);
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "Sections " + this + " and " + other + " have different sources and thus can't be spanned.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.getRange().getFirst();
        n2 = other.getRange().getFirst();
        int n3 = 0;
        int start = Math.min(n, n2);
        n2 = this.getRange().getLast();
        n3 = other.getRange().getLast();
        boolean bl3 = false;
        int end = Math.max(n2, n3);
        return new Section(this.source, start, end - start);
    }

    @NotNull
    public String toString() {
        return "(" + this.source.getName() + ":" + this.getStartLineNumber() + ":" + this.getStartLineIndex() + ")";
    }

    @NotNull
    public final Source component1() {
        return this.source;
    }

    public final int component2() {
        return this.index;
    }

    public final int component3() {
        return this.length;
    }

    @NotNull
    public final Section copy(@NotNull Source source, int index, int length) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new Section(source, index, length);
    }

    public static /* synthetic */ Section copy$default(Section section, Source source, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            source = section.source;
        }
        if ((n3 & 2) != 0) {
            n = section.index;
        }
        if ((n3 & 4) != 0) {
            n2 = section.length;
        }
        return section.copy(source, n, n2);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + Integer.hashCode(this.index);
        result = result * 31 + Integer.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Section)) {
            return false;
        }
        Section section = (Section)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)section.source)) {
            return false;
        }
        if (this.index != section.index) {
            return false;
        }
        return this.length == section.length;
    }
}

