/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.extensions;

import com.github.adriantodt.tartar.api.lexer.LexerContext;
import com.github.adriantodt.tartar.api.lexer.Section;
import com.github.adriantodt.tartar.api.parser.Token;
import com.github.adriantodt.tartar.extensions.ExtensionsKt;
import com.github.adriantodt.tartar.extensions.LexicalNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a9\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u00022\u0006\u0010\u000b\u001a\u0002H\n2\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u001aA\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u00022\u0006\u0010\u000b\u001a\u0002H\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011\u001a\u001f\u0010\u0012\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00022\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0018\u001a\u00020\u0014\u001a\u0016\u0010\u0019\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001a\u001a\u00020\u0014\u001a \u0010\u001b\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\r\u00a8\u0006\u001e"}, d2={"fillBufferNumbers", "", "Lcom/github/adriantodt/tartar/api/lexer/LexerContext;", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "allowHex", "", "makeToken", "Lcom/github/adriantodt/tartar/api/parser/Token;", "T", "tokenType", "offset", "", "(Lcom/github/adriantodt/tartar/api/lexer/LexerContext;Ljava/lang/Object;I)Lcom/github/adriantodt/tartar/api/parser/Token;", "string", "", "(Lcom/github/adriantodt/tartar/api/lexer/LexerContext;Ljava/lang/Object;Ljava/lang/String;I)Lcom/github/adriantodt/tartar/api/parser/Token;", "readIdentifier", "firstChar", "", "(Lcom/github/adriantodt/tartar/api/lexer/LexerContext;Ljava/lang/Character;)Ljava/lang/String;", "readNumber", "Lcom/github/adriantodt/tartar/extensions/LexicalNumber;", "c", "readString", "delimiter", "section", "Lcom/github/adriantodt/tartar/api/lexer/Section;", "length", "tartar"})
public final class LexerContextKt {
    @NotNull
    public static final Section section(@NotNull LexerContext<?> $this$section, int offset, int length) {
        Intrinsics.checkNotNullParameter($this$section, (String)"<this>");
        return new Section($this$section.getSource(), $this$section.getLineNumber(), $this$section.getLineIndex() - length - offset, length + offset);
    }

    public static /* synthetic */ Section section$default(LexerContext lexerContext, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return LexerContextKt.section(lexerContext, n, n2);
    }

    @NotNull
    public static final <T> Token<T> makeToken(@NotNull LexerContext<Token<T>> $this$makeToken, T tokenType, int offset) {
        Intrinsics.checkNotNullParameter($this$makeToken, (String)"<this>");
        return LexerContextKt.makeToken($this$makeToken, tokenType, "", offset);
    }

    public static /* synthetic */ Token makeToken$default(LexerContext lexerContext, Object object, int n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return LexerContextKt.makeToken(lexerContext, object, n);
    }

    @NotNull
    public static final <T> Token<T> makeToken(@NotNull LexerContext<Token<T>> $this$makeToken, T tokenType, @NotNull String string, int offset) {
        Intrinsics.checkNotNullParameter($this$makeToken, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new Token<T>(tokenType, string, new Section($this$makeToken.getSource(), $this$makeToken.getLineNumber(), $this$makeToken.getLineIndex() - string.length() - offset, string.length() + offset));
    }

    public static /* synthetic */ Token makeToken$default(LexerContext lexerContext, Object object, String string, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return LexerContextKt.makeToken(lexerContext, object, string, n);
    }

    @NotNull
    public static final String readIdentifier(@NotNull LexerContext<?> $this$readIdentifier, @Nullable Character firstChar) {
        char cc;
        Intrinsics.checkNotNullParameter($this$readIdentifier, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        Object object = firstChar;
        if (object != null) {
            Character c = object;
            boolean bl = false;
            boolean bl2 = false;
            char p0 = c.charValue();
            boolean bl3 = false;
            buf.append(p0);
        }
        while ($this$readIdentifier.hasNext() && (ExtensionsKt.isLetterOrDigit(cc = $this$readIdentifier.peek()) || cc == '_')) {
            buf.append(cc);
            $this$readIdentifier.next();
        }
        object = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buf.toString()");
        return object;
    }

    public static /* synthetic */ String readIdentifier$default(LexerContext lexerContext, Character c, int n, Object object) {
        if ((n & 1) != 0) {
            c = null;
        }
        return LexerContextKt.readIdentifier(lexerContext, c);
    }

    @NotNull
    public static final String readString(@NotNull LexerContext<?> $this$readString, char delimiter) {
        Intrinsics.checkNotNullParameter($this$readString, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        boolean eol = false;
        while ($this$readString.hasNext()) {
            char c = $this$readString.peek();
            if (c == delimiter) {
                $this$readString.next();
                eol = true;
                break;
            }
            $this$readString.next();
            buf.append(c);
        }
        if (!eol) {
            throw new IllegalStateException("Unterminated string");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    @NotNull
    public static final LexicalNumber readNumber(@NotNull LexerContext<?> $this$readNumber, char c) {
        LexicalNumber lexicalNumber;
        Intrinsics.checkNotNullParameter($this$readNumber, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        if (c == '0') {
            if ($this$readNumber.match('x')) {
                LexerContextKt.fillBufferNumbers($this$readNumber, buf, true);
                boolean isLong = $this$readNumber.match('l') || $this$readNumber.match('L');
                String string = buf.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                String s = string;
                Integer n = StringsKt.toIntOrNull((String)s, (int)16);
                if (n == null) {
                    String string2 = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buf.toString()");
                    return new LexicalNumber.Invalid(string2);
                }
                int number = n;
                return new LexicalNumber.Integer(s, number, 16, isLong);
            }
            if ($this$readNumber.match('b')) {
                LexerContextKt.fillBufferNumbers($this$readNumber, buf, false);
                boolean isLong = $this$readNumber.match('l') || $this$readNumber.match('L');
                String number = buf.toString();
                Intrinsics.checkNotNullExpressionValue((Object)number, (String)"buf.toString()");
                String s = number;
                Integer n = StringsKt.toIntOrNull((String)s, (int)2);
                if (n == null) {
                    String string = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                    return new LexicalNumber.Invalid(string);
                }
                int number2 = n;
                return new LexicalNumber.Integer(s, number2, 2, isLong);
            }
            buf.append('0');
        } else {
            buf.append(c);
        }
        LexerContextKt.fillBufferNumbers($this$readNumber, buf, false);
        if ($this$readNumber.peek() == '.' && ExtensionsKt.isDigit($this$readNumber.peek(1))) {
            String s;
            $this$readNumber.next();
            buf.append('.');
            LexerContextKt.fillBufferNumbers($this$readNumber, buf, false);
            boolean isFloat = $this$readNumber.match('f') || $this$readNumber.match('F');
            String number2 = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)number2, (String)"buf.toString()");
            number2 = s = number2;
            boolean bl = false;
            lexicalNumber = new LexicalNumber.Decimal(s, Double.parseDouble(number2), isFloat);
        } else {
            String s = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)s, (String)"buf.toString()");
            String s2 = s;
            Integer n = StringsKt.toIntOrNull((String)s2);
            if (n != null) {
                boolean isLong = $this$readNumber.match('l') || $this$readNumber.match('L');
                String string = s2;
                boolean bl = false;
                lexicalNumber = new LexicalNumber.Integer(s2, Integer.parseInt(string), 10, isLong);
            } else {
                String string = buf.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                lexicalNumber = new LexicalNumber.Invalid(string);
            }
        }
        return lexicalNumber;
    }

    private static final void fillBufferNumbers(LexerContext<?> $this$fillBufferNumbers, StringBuilder buf, boolean allowHex) {
        while ($this$fillBufferNumbers.hasNext()) {
            block4: {
                char c;
                block5: {
                    c = $this$fillBufferNumbers.peek();
                    if (ExtensionsKt.isDigit(c)) break block4;
                    if (!allowHex) break block5;
                    if ('A' <= c ? c <= 'F' : false) break block4;
                }
                boolean bl = 'a' <= c ? c <= 'f' : false;
                if (!bl) break;
            }
            buf.append($this$fillBufferNumbers.next());
        }
    }
}

