/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.tartar.api.lexer;

import com.github.adriantodt.tartar.api.lexer.Source;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001f\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/github/adriantodt/tartar/api/lexer/Section;", "", "source", "Lcom/github/adriantodt/tartar/api/lexer/Source;", "lineNumber", "", "lineIndex", "length", "(Lcom/github/adriantodt/tartar/api/lexer/Source;III)V", "getLength", "()I", "line", "", "getLine", "()Ljava/lang/String;", "getLineIndex", "getLineNumber", "getSource", "()Lcom/github/adriantodt/tartar/api/lexer/Source;", "substring", "getSubstring", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "span", "toString", "tartar"})
public final class Section {
    @NotNull
    private final Source source;
    private final int lineNumber;
    private final int lineIndex;
    private final int length;

    public Section(@NotNull Source source, int lineNumber, int lineIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.lineNumber = lineNumber;
        this.lineIndex = lineIndex;
        this.length = length;
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getLineIndex() {
        return this.lineIndex;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final String getLine() {
        return this.source.getLines().get(this.lineNumber - 1);
    }

    @NotNull
    public final String getSubstring() {
        String string = this.source.getLines().get(this.lineNumber - 1);
        int n = this.lineIndex;
        int n2 = this.lineIndex + this.length;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final Section span(@NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this.source, (Object)other.source) && this.lineNumber == other.lineNumber) {
            int n = this.lineIndex;
            int n2 = other.lineIndex;
            int n3 = 0;
            int min = Math.min(n, n2);
            n2 = this.lineIndex + this.length;
            n3 = other.lineIndex + other.length;
            boolean bl = false;
            int max = Math.max(n2, n3);
            return new Section(this.source, this.lineNumber, min, max - min);
        }
        throw new IllegalStateException("section sources");
    }

    @NotNull
    public String toString() {
        return "(" + this.source.getName() + ":" + this.lineNumber + ":" + this.lineIndex + ")";
    }

    @NotNull
    public final Source component1() {
        return this.source;
    }

    public final int component2() {
        return this.lineNumber;
    }

    public final int component3() {
        return this.lineIndex;
    }

    public final int component4() {
        return this.length;
    }

    @NotNull
    public final Section copy(@NotNull Source source, int lineNumber, int lineIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new Section(source, lineNumber, lineIndex, length);
    }

    public static /* synthetic */ Section copy$default(Section section, Source source, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            source = section.source;
        }
        if ((n4 & 2) != 0) {
            n = section.lineNumber;
        }
        if ((n4 & 4) != 0) {
            n2 = section.lineIndex;
        }
        if ((n4 & 8) != 0) {
            n3 = section.length;
        }
        return section.copy(source, n, n2, n3);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + Integer.hashCode(this.lineNumber);
        result = result * 31 + Integer.hashCode(this.lineIndex);
        result = result * 31 + Integer.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Section)) {
            return false;
        }
        Section section = (Section)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)section.source)) {
            return false;
        }
        if (this.lineNumber != section.lineNumber) {
            return false;
        }
        if (this.lineIndex != section.lineIndex) {
            return false;
        }
        return this.length == section.length;
    }
}

