(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'tartar-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'tartar-js-legacy'.");
    }root['tartar-js-legacy'] = factory(typeof this['tartar-js-legacy'] === 'undefined' ? {} : this['tartar-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var unboxChar = Kotlin.unboxChar;
  var isLetter = Kotlin.kotlin.text.isLetter_myv2d0$;
  var getCallableRef = Kotlin.getCallableRef;
  var isDigit = Kotlin.kotlin.text.isDigit_myv2d0$;
  var isLetterOrDigit = Kotlin.kotlin.text.isLetterOrDigit_myv2d0$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Unit = Kotlin.kotlin.Unit;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var substring = Kotlin.kotlin.text.substring_fc3b62$;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var JsMath = Math;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var RuntimeException = Kotlin.kotlin.RuntimeException;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var toLongOrNull = Kotlin.kotlin.text.toLongOrNull_6ic1pp$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var toLongOrNull_0 = Kotlin.kotlin.text.toLongOrNull_pdl1vz$;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var toMap = Kotlin.kotlin.collections.toMap_abgq59$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var Map = Kotlin.kotlin.collections.Map;
  var throwCCE = Kotlin.throwCCE;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var findAnyOf = Kotlin.kotlin.text.findAnyOf_7utkvz$;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var get_lastIndex = Kotlin.kotlin.text.get_lastIndex_gw00vp$;
  var toChar = Kotlin.toChar;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var StringBuilder_init_0 = Kotlin.kotlin.text.StringBuilder_init_za3lpa$;
  var first_0 = Kotlin.kotlin.text.first_gw00vp$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var equals = Kotlin.equals;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var L0 = Kotlin.Long.ZERO;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  SyntaxException.prototype = Object.create(RuntimeException.prototype);
  SyntaxException.prototype.constructor = SyntaxException;
  LexicalNumber$Invalid.prototype = Object.create(LexicalNumber.prototype);
  LexicalNumber$Invalid.prototype.constructor = LexicalNumber$Invalid;
  LexicalNumber$Decimal.prototype = Object.create(LexicalNumber.prototype);
  LexicalNumber$Decimal.prototype.constructor = LexicalNumber$Decimal;
  LexicalNumber$Integer.prototype = Object.create(LexicalNumber.prototype);
  LexicalNumber$Integer.prototype.constructor = LexicalNumber$Integer;
  function CharPredicate(f) {
    CharPredicate$Companion_getInstance();
    this.function$ = f;
  }
  function CharPredicate$Companion() {
    CharPredicate$Companion_instance = this;
    this.isLetter = new CharPredicate(getCallableRef('isLetter', function ($receiver) {
      return isLetter(unboxChar($receiver));
    }));
    this.isDigit = new CharPredicate(getCallableRef('isDigit', function ($receiver) {
      return isDigit(unboxChar($receiver));
    }));
    this.isLetterOrDigit = new CharPredicate(getCallableRef('isLetterOrDigit', function ($receiver) {
      return isLetterOrDigit(unboxChar($receiver));
    }));
  }
  CharPredicate$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CharPredicate$Companion_instance = null;
  function CharPredicate$Companion_getInstance() {
    if (CharPredicate$Companion_instance === null) {
      new CharPredicate$Companion();
    }return CharPredicate$Companion_instance;
  }
  CharPredicate.prototype.test_s8itvh$ = function (value) {
    return this.function$(toBoxedChar(value));
  };
  CharPredicate.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CharPredicate',
    interfaces: []
  };
  function GrammarDSL() {
  }
  GrammarDSL.prototype.import_6g5tfb$ = function (override, grammars, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(override, grammars) : this.import_6g5tfb$$default(override, grammars);
  };
  GrammarDSL.prototype.prefix_uhlc8g$ = function (type, parselet, override, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, parselet, override) : this.prefix_uhlc8g$$default(type, parselet, override);
  };
  GrammarDSL.prototype.prefix_ggj8ix$ = function (type, override, block, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, override, block) : this.prefix_ggj8ix$$default(type, override, block);
  };
  GrammarDSL.prototype.infix_lx5ia$ = function (type, parselet, override, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, parselet, override) : this.infix_lx5ia$$default(type, parselet, override);
  };
  GrammarDSL.prototype.infix_lfjh7$ = function (type, precedence, override, block, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, precedence, override, block) : this.infix_lfjh7$$default(type, precedence, override, block);
  };
  GrammarDSL.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GrammarDSL',
    interfaces: []
  };
  function LexerDSL() {
  }
  LexerDSL.prototype.invoke_sdqmiu$$default = function ($receiver, block) {
    this.matching_s8itvh$($receiver).configure_t5ujie$(block);
  };
  function LexerDSL$invoke$lambda($receiver, it) {
    return Unit;
  }
  LexerDSL.prototype.invoke_sdqmiu$ = function ($receiver, block, callback$default) {
    if (block === void 0)
      block = LexerDSL$invoke$lambda;
    callback$default ? callback$default($receiver, block) : this.invoke_sdqmiu$$default($receiver, block);
  };
  LexerDSL.prototype.invoke_vp8vqt$$default = function ($receiver, block) {
    this.matching_61zpoe$($receiver).configure_t5ujie$(block);
  };
  function LexerDSL$invoke$lambda_0($receiver, it) {
    return Unit;
  }
  LexerDSL.prototype.invoke_vp8vqt$ = function ($receiver, block, callback$default) {
    if (block === void 0)
      block = LexerDSL$invoke$lambda_0;
    callback$default ? callback$default($receiver, block) : this.invoke_vp8vqt$$default($receiver, block);
  };
  LexerDSL.prototype.matching_xibcvw$ = function (string, block) {
    block(this.matching_61zpoe$(string));
  };
  LexerDSL.prototype.matching_eerp9d$ = function (char, block) {
    block(this.matching_s8itvh$(char));
  };
  LexerDSL.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LexerDSL',
    interfaces: []
  };
  function Grammar(prefix, infix) {
    Grammar$Companion_getInstance();
    this.prefix = prefix;
    this.infix = infix;
  }
  function Grammar$Companion() {
    Grammar$Companion_instance = this;
  }
  Grammar$Companion.prototype.create_c9my70$ = function (block) {
    var $receiver = new GrammarBuilder();
    block($receiver);
    return $receiver.build_8be2vx$();
  };
  Grammar$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Grammar$Companion_instance = null;
  function Grammar$Companion_getInstance() {
    if (Grammar$Companion_instance === null) {
      new Grammar$Companion();
    }return Grammar$Companion_instance;
  }
  Grammar.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Grammar',
    interfaces: []
  };
  Grammar.prototype.component1 = function () {
    return this.prefix;
  };
  Grammar.prototype.component2 = function () {
    return this.infix;
  };
  Grammar.prototype.copy_46tf04$ = function (prefix, infix) {
    return new Grammar(prefix === void 0 ? this.prefix : prefix, infix === void 0 ? this.infix : infix);
  };
  Grammar.prototype.toString = function () {
    return 'Grammar(prefix=' + Kotlin.toString(this.prefix) + (', infix=' + Kotlin.toString(this.infix)) + ')';
  };
  Grammar.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.prefix) | 0;
    result = result * 31 + Kotlin.hashCode(this.infix) | 0;
    return result;
  };
  Grammar.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.prefix, other.prefix) && Kotlin.equals(this.infix, other.infix)))));
  };
  function InfixParselet() {
  }
  InfixParselet.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InfixParselet',
    interfaces: []
  };
  function PrefixParselet() {
  }
  PrefixParselet.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PrefixParselet',
    interfaces: []
  };
  function Lexer() {
    Lexer$Companion_getInstance();
  }
  function Lexer$parseTo$lambda(closure$collection) {
    return function (it) {
      closure$collection.add_11rb$(it);
      return Unit;
    };
  }
  Lexer.prototype.parseTo_32dq1j$ = function (source, collection) {
    this.parse_mi27kl$(source, Lexer$parseTo$lambda(collection));
    return collection;
  };
  Lexer.prototype.parseToList_llobtt$ = function (source) {
    return this.parseTo_32dq1j$(source, ArrayList_init());
  };
  function Lexer$Companion() {
    Lexer$Companion_instance = this;
  }
  Lexer$Companion.prototype.create_g2f273$ = function (block) {
    var $receiver = new MatcherImpl();
    block($receiver);
    return new LexerImpl($receiver);
  };
  Lexer$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Lexer$Companion_instance = null;
  function Lexer$Companion_getInstance() {
    if (Lexer$Companion_instance === null) {
      new Lexer$Companion();
    }return Lexer$Companion_instance;
  }
  Lexer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Lexer',
    interfaces: []
  };
  function LexerContext() {
  }
  LexerContext.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LexerContext',
    interfaces: []
  };
  function Section(source, index, length) {
    this.source = source;
    this.index = index;
    this.length = length;
    if (!this.source.bounds.contains_mef7kx$(this.index)) {
      var message = 'Section index (' + this.index + ") must be within content's bounds (0.." + this.source.content.length + ')';
      throw IllegalArgumentException_init(message.toString());
    }var end = this.index + this.length | 0;
    if (!this.source.bounds.contains_mef7kx$(end)) {
      var message_0 = 'Section end (' + end + ") must be within content's bounds (0.." + this.source.content.length + ')';
      throw IllegalArgumentException_init(message_0.toString());
    }this.range = new IntRange(this.index, this.index + this.length | 0);
    this.substring = substring(this.source.content, this.range);
    var $receiver = this.source.lines;
    var tmp$;
    var yielding = false;
    var list = ArrayList_init();
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      if (yielding)
        list.add_11rb$(item);
      else {
        if (!(this.range.first > item.range.last)) {
          list.add_11rb$(item);
          yielding = true;
        }}
    }
    var tmp$_0;
    var list_0 = ArrayList_init();
    tmp$_0 = list.iterator();
    while (tmp$_0.hasNext()) {
      var item_0 = tmp$_0.next();
      if (!(this.range.last > item_0.range.first))
        break;
      list_0.add_11rb$(item_0);
    }
    this.lines = list_0;
    this.startLineNumber = first(this.lines).lineNumber;
    this.startLineIndex = this.range.first - first(this.lines).range.first | 0;
    this.endLineNumber = last(this.lines).lineNumber;
    this.endLineIndex = this.range.last - last(this.lines).range.last | 0;
  }
  function Section$span$lambda(this$Section, closure$other) {
    return function () {
      return 'Sections ' + this$Section + ' and ' + closure$other + " have different sources and thus can't be spanned.";
    };
  }
  Section.prototype.span_pdml0f$ = function (other) {
    var tmp$;
    if (!((tmp$ = this.source) != null ? tmp$.equals(other.source) : null)) {
      var message = Section$span$lambda(this, other)();
      throw IllegalArgumentException_init(message.toString());
    }var a = this.range.first;
    var b = other.range.first;
    var start = JsMath.min(a, b);
    var a_0 = this.range.last;
    var b_0 = other.range.last;
    var end = JsMath.max(a_0, b_0);
    return new Section(this.source, start, end - start | 0);
  };
  Section.prototype.toString = function () {
    return '(' + this.source.name + ':' + this.startLineNumber + ':' + this.startLineIndex + ')';
  };
  Section.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Section',
    interfaces: []
  };
  Section.prototype.component1 = function () {
    return this.source;
  };
  Section.prototype.component2 = function () {
    return this.index;
  };
  Section.prototype.component3 = function () {
    return this.length;
  };
  Section.prototype.copy_j9ce3l$ = function (source, index, length) {
    return new Section(source === void 0 ? this.source : source, index === void 0 ? this.index : index, length === void 0 ? this.length : length);
  };
  Section.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.index) | 0;
    result = result * 31 + Kotlin.hashCode(this.length) | 0;
    return result;
  };
  Section.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.index, other.index) && Kotlin.equals(this.length, other.length)))));
  };
  function Sectional() {
  }
  Sectional.prototype.span_p684zu$ = function (other) {
    return this.section.span_pdml0f$(other.section);
  };
  Sectional.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Sectional',
    interfaces: []
  };
  function Source(content, name, path) {
    Source$Companion_getInstance();
    if (name === void 0)
      name = '?';
    if (path === void 0)
      path = '!!no path!!';
    this.content = content;
    this.name = name;
    this.path = path;
    var $receiver = calculateLineRanges(this.content);
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$, tmp$_0;
    var index = 0;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new Source$Line(checkIndexOverflow((tmp$_0 = index, index = tmp$_0 + 1 | 0, tmp$_0)) + 1 | 0, substring(this.content, item), item));
    }
    this.lines = destination;
    this.bounds = new IntRange(0, this.content.length);
  }
  function Source$Line(lineNumber, content, range) {
    this.lineNumber = lineNumber;
    this.content = content;
    this.range = range;
  }
  Source$Line.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Line',
    interfaces: []
  };
  Source$Line.prototype.component1 = function () {
    return this.lineNumber;
  };
  Source$Line.prototype.component2 = function () {
    return this.content;
  };
  Source$Line.prototype.component3 = function () {
    return this.range;
  };
  Source$Line.prototype.copy_ng1l75$ = function (lineNumber, content, range) {
    return new Source$Line(lineNumber === void 0 ? this.lineNumber : lineNumber, content === void 0 ? this.content : content, range === void 0 ? this.range : range);
  };
  Source$Line.prototype.toString = function () {
    return 'Line(lineNumber=' + Kotlin.toString(this.lineNumber) + (', content=' + Kotlin.toString(this.content)) + (', range=' + Kotlin.toString(this.range)) + ')';
  };
  Source$Line.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lineNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    result = result * 31 + Kotlin.hashCode(this.range) | 0;
    return result;
  };
  Source$Line.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lineNumber, other.lineNumber) && Kotlin.equals(this.content, other.content) && Kotlin.equals(this.range, other.range)))));
  };
  function Source$Companion() {
    Source$Companion_instance = this;
  }
  Source$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Source$Companion_instance = null;
  function Source$Companion_getInstance() {
    if (Source$Companion_instance === null) {
      new Source$Companion();
    }return Source$Companion_instance;
  }
  Source.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Source',
    interfaces: []
  };
  Source.prototype.component1 = function () {
    return this.content;
  };
  Source.prototype.component2 = function () {
    return this.name;
  };
  Source.prototype.component3 = function () {
    return this.path;
  };
  Source.prototype.copy_6hosri$ = function (content, name, path) {
    return new Source(content === void 0 ? this.content : content, name === void 0 ? this.name : name, path === void 0 ? this.path : path);
  };
  Source.prototype.toString = function () {
    return 'Source(content=' + Kotlin.toString(this.content) + (', name=' + Kotlin.toString(this.name)) + (', path=' + Kotlin.toString(this.path)) + ')';
  };
  Source.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.path) | 0;
    return result;
  };
  Source.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.content, other.content) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.path, other.path)))));
  };
  function Parser() {
    Parser$Companion_getInstance();
  }
  Parser.prototype.parse_r7b30y$ = function (source, lexer) {
    return this.parse_qvx10v$(source, lexer.parseToList_llobtt$(source));
  };
  function Parser$Companion() {
    Parser$Companion_instance = this;
  }
  Parser$Companion.prototype.create_ruzcty$ = function (grammar, block) {
    return new ParserImpl(grammar, block);
  };
  Parser$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Parser$Companion_instance = null;
  function Parser$Companion_getInstance() {
    if (Parser$Companion_instance === null) {
      new Parser$Companion();
    }return Parser$Companion_instance;
  }
  Parser.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Parser',
    interfaces: []
  };
  function ParserContext() {
  }
  ParserContext.prototype.parseExpression_za3lpa$ = function (precedence, callback$default) {
    if (precedence === void 0)
      precedence = 0;
    return callback$default ? callback$default(precedence) : this.parseExpression_za3lpa$$default(precedence);
  };
  ParserContext.prototype.parseExpression_6t5y4q$$default = function ($receiver, precedence) {
    return this.withGrammar_ugt3wb$(this.grammar).parseExpression_za3lpa$(precedence);
  };
  ParserContext.prototype.parseExpression_6t5y4q$ = function ($receiver, precedence, callback$default) {
    if (precedence === void 0)
      precedence = 0;
    return callback$default ? callback$default($receiver, precedence) : this.parseExpression_6t5y4q$$default($receiver, precedence);
  };
  ParserContext.prototype.peek_za3lpa$ = function (distance, callback$default) {
    if (distance === void 0)
      distance = 0;
    return callback$default ? callback$default(distance) : this.peek_za3lpa$$default(distance);
  };
  ParserContext.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ParserContext',
    interfaces: []
  };
  function SourceParser(lexer, parser) {
    SourceParser$Companion_getInstance();
    this.lexer = lexer;
    this.parser = parser;
  }
  SourceParser.prototype.parse_llobtt$ = function (source) {
    return this.parser.parse_r7b30y$(source, this.lexer);
  };
  function SourceParser$Companion() {
    SourceParser$Companion_instance = this;
  }
  SourceParser$Companion.prototype.create_o2m480$ = function (lexer, grammar, block) {
    return new SourceParser(lexer, Parser$Companion_getInstance().create_ruzcty$(grammar, block));
  };
  SourceParser$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SourceParser$Companion_instance = null;
  function SourceParser$Companion_getInstance() {
    if (SourceParser$Companion_instance === null) {
      new SourceParser$Companion();
    }return SourceParser$Companion_instance;
  }
  SourceParser.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SourceParser',
    interfaces: []
  };
  SourceParser.prototype.component1 = function () {
    return this.lexer;
  };
  SourceParser.prototype.component2 = function () {
    return this.parser;
  };
  SourceParser.prototype.copy_kslbeh$ = function (lexer, parser) {
    return new SourceParser(lexer === void 0 ? this.lexer : lexer, parser === void 0 ? this.parser : parser);
  };
  SourceParser.prototype.toString = function () {
    return 'SourceParser(lexer=' + Kotlin.toString(this.lexer) + (', parser=' + Kotlin.toString(this.parser)) + ')';
  };
  SourceParser.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lexer) | 0;
    result = result * 31 + Kotlin.hashCode(this.parser) | 0;
    return result;
  };
  SourceParser.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lexer, other.lexer) && Kotlin.equals(this.parser, other.parser)))));
  };
  function SyntaxException(message, position) {
    RuntimeException_init(message + ' at ' + position, this);
    this.position = position;
    this.name = 'SyntaxException';
  }
  SyntaxException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SyntaxException',
    interfaces: [RuntimeException]
  };
  function Token(type, value, section) {
    this.type = type;
    this.value = value;
    this.section_t9z7rp$_0 = section;
  }
  Object.defineProperty(Token.prototype, 'section', {
    get: function () {
      return this.section_t9z7rp$_0;
    }
  });
  Token.prototype.toString = function () {
    return this.type.toString() + '[' + this.value + '] ' + this.section;
  };
  Token.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Token',
    interfaces: [Sectional]
  };
  Token.prototype.component1 = function () {
    return this.type;
  };
  Token.prototype.component2 = function () {
    return this.value;
  };
  Token.prototype.component3 = function () {
    return this.section;
  };
  Token.prototype.copy_e3j0u$ = function (type, value, section) {
    return new Token(type === void 0 ? this.type : type, value === void 0 ? this.value : value, section === void 0 ? this.section : section);
  };
  Token.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.section) | 0;
    return result;
  };
  Token.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.section, other.section)))));
  };
  function section($receiver, offset, length) {
    if (length === void 0)
      length = 0;
    return new Section($receiver.source, $receiver.index - length - offset | 0, length + offset | 0);
  }
  function makeToken($receiver, type, offset) {
    if (offset === void 0)
      offset = 1;
    return makeToken_0($receiver, type, '', offset);
  }
  function makeToken_0($receiver, type, string, offset) {
    if (offset === void 0)
      offset = 0;
    var section = new Section($receiver.source, $receiver.index - string.length - offset | 0, string.length + offset | 0);
    return new Token(type, string, section);
  }
  function readIdentifier($receiver, firstChar) {
    if (firstChar === void 0)
      firstChar = null;
    var buf = StringBuilder_init();
    if (firstChar != null) {
      var $receiver_0 = toBoxedChar(firstChar);
      getCallableRef('append', function ($receiver, p1) {
        return $receiver.append_s8itvh$(unboxChar(p1));
      }.bind(null, buf))($receiver_0);
    }while ($receiver.hasNext()) {
      var cc = unboxChar($receiver.peek());
      if (isLetterOrDigit(cc) || cc === 95) {
        buf.append_s8itvh$(cc);
        unboxChar($receiver.next());
      } else {
        break;
      }
    }
    return buf.toString();
  }
  function readString($receiver, delimiter) {
    var buf = StringBuilder_init();
    var eol = false;
    while ($receiver.hasNext()) {
      var c = unboxChar($receiver.peek());
      if (c === delimiter) {
        $receiver.next();
        eol = true;
        break;
      } else {
        $receiver.next();
        buf.append_s8itvh$(c);
      }
    }
    if (!eol) {
      throw IllegalStateException_init('Unterminated string');
    }return buf.toString();
  }
  function readNumber($receiver, c) {
    var tmp$, tmp$_0, tmp$_1;
    var buf = StringBuilder_init();
    if (c === 48) {
      if ($receiver.match_s8itvh$(120)) {
        fillBufferNumbers($receiver, buf, true);
        var isLong = $receiver.match_s8itvh$(108) || $receiver.match_s8itvh$(76);
        var s = buf.toString();
        tmp$ = toLongOrNull(s, 16);
        if (tmp$ == null) {
          return new LexicalNumber$Invalid(buf.toString());
        }var number = tmp$;
        return new LexicalNumber$Integer(s, number, 16, isLong);
      } else if ($receiver.match_s8itvh$(98)) {
        fillBufferNumbers($receiver, buf, false);
        var isLong_0 = $receiver.match_s8itvh$(108) || $receiver.match_s8itvh$(76);
        var s_0 = buf.toString();
        tmp$_0 = toLongOrNull(s_0, 2);
        if (tmp$_0 == null) {
          return new LexicalNumber$Invalid(buf.toString());
        }var number_0 = tmp$_0;
        return new LexicalNumber$Integer(s_0, number_0, 2, isLong_0);
      } else {
        buf.append_s8itvh$(48);
      }
    } else {
      buf.append_s8itvh$(c);
    }
    fillBufferNumbers($receiver, buf, false);
    if (unboxChar($receiver.peek()) === 46 && isDigit(unboxChar($receiver.peek_za3lpa$(1)))) {
      $receiver.next();
      buf.append_s8itvh$(46);
      fillBufferNumbers($receiver, buf, false);
      var isFloat = $receiver.match_s8itvh$(102) || $receiver.match_s8itvh$(70);
      var s_1 = buf.toString();
      tmp$_1 = new LexicalNumber$Decimal(s_1, toDouble(s_1), isFloat);
    } else {
      var s_2 = buf.toString();
      var int = toLongOrNull_0(s_2);
      if ($receiver.match_s8itvh$(102) || $receiver.match_s8itvh$(70)) {
        tmp$_1 = new LexicalNumber$Decimal(s_2, toDouble(s_2), true);
      } else if (int != null) {
        var isLong_1 = $receiver.match_s8itvh$(108) || $receiver.match_s8itvh$(76);
        tmp$_1 = new LexicalNumber$Integer(s_2, int, 10, isLong_1);
      } else {
        tmp$_1 = new LexicalNumber$Invalid(buf.toString());
      }
    }
    return tmp$_1;
  }
  function LexicalNumber() {
  }
  function LexicalNumber$Invalid(string) {
    LexicalNumber.call(this);
    this.string_fidsft$_0 = string;
  }
  Object.defineProperty(LexicalNumber$Invalid.prototype, 'string', {
    get: function () {
      return this.string_fidsft$_0;
    }
  });
  LexicalNumber$Invalid.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Invalid',
    interfaces: [LexicalNumber]
  };
  LexicalNumber$Invalid.prototype.component1 = function () {
    return this.string;
  };
  LexicalNumber$Invalid.prototype.copy_61zpoe$ = function (string) {
    return new LexicalNumber$Invalid(string === void 0 ? this.string : string);
  };
  LexicalNumber$Invalid.prototype.toString = function () {
    return 'Invalid(string=' + Kotlin.toString(this.string) + ')';
  };
  LexicalNumber$Invalid.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    return result;
  };
  LexicalNumber$Invalid.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.string, other.string))));
  };
  function LexicalNumber$Decimal(string, value, isFloat) {
    if (isFloat === void 0)
      isFloat = false;
    LexicalNumber.call(this);
    this.string_el7cip$_0 = string;
    this.value = value;
    this.isFloat = isFloat;
  }
  Object.defineProperty(LexicalNumber$Decimal.prototype, 'string', {
    get: function () {
      return this.string_el7cip$_0;
    }
  });
  LexicalNumber$Decimal.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Decimal',
    interfaces: [LexicalNumber]
  };
  LexicalNumber$Decimal.prototype.component1 = function () {
    return this.string;
  };
  LexicalNumber$Decimal.prototype.component2 = function () {
    return this.value;
  };
  LexicalNumber$Decimal.prototype.component3 = function () {
    return this.isFloat;
  };
  LexicalNumber$Decimal.prototype.copy_1truf$ = function (string, value, isFloat) {
    return new LexicalNumber$Decimal(string === void 0 ? this.string : string, value === void 0 ? this.value : value, isFloat === void 0 ? this.isFloat : isFloat);
  };
  LexicalNumber$Decimal.prototype.toString = function () {
    return 'Decimal(string=' + Kotlin.toString(this.string) + (', value=' + Kotlin.toString(this.value)) + (', isFloat=' + Kotlin.toString(this.isFloat)) + ')';
  };
  LexicalNumber$Decimal.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.isFloat) | 0;
    return result;
  };
  LexicalNumber$Decimal.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.string, other.string) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.isFloat, other.isFloat)))));
  };
  function LexicalNumber$Integer(string, value, radix, isLong) {
    if (radix === void 0)
      radix = 10;
    if (isLong === void 0)
      isLong = false;
    LexicalNumber.call(this);
    this.string_tykk5q$_0 = string;
    this.value = value;
    this.radix = radix;
    this.isLong = isLong;
  }
  Object.defineProperty(LexicalNumber$Integer.prototype, 'string', {
    get: function () {
      return this.string_tykk5q$_0;
    }
  });
  LexicalNumber$Integer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Integer',
    interfaces: [LexicalNumber]
  };
  LexicalNumber$Integer.prototype.component1 = function () {
    return this.string;
  };
  LexicalNumber$Integer.prototype.component2 = function () {
    return this.value;
  };
  LexicalNumber$Integer.prototype.component3 = function () {
    return this.radix;
  };
  LexicalNumber$Integer.prototype.component4 = function () {
    return this.isLong;
  };
  LexicalNumber$Integer.prototype.copy_dw84ek$ = function (string, value, radix, isLong) {
    return new LexicalNumber$Integer(string === void 0 ? this.string : string, value === void 0 ? this.value : value, radix === void 0 ? this.radix : radix, isLong === void 0 ? this.isLong : isLong);
  };
  LexicalNumber$Integer.prototype.toString = function () {
    return 'Integer(string=' + Kotlin.toString(this.string) + (', value=' + Kotlin.toString(this.value)) + (', radix=' + Kotlin.toString(this.radix)) + (', isLong=' + Kotlin.toString(this.isLong)) + ')';
  };
  LexicalNumber$Integer.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.radix) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLong) | 0;
    return result;
  };
  LexicalNumber$Integer.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.string, other.string) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.radix, other.radix) && Kotlin.equals(this.isLong, other.isLong)))));
  };
  LexicalNumber.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexicalNumber',
    interfaces: []
  };
  function fillBufferNumbers($receiver, buf, allowHex) {
    while ($receiver.hasNext()) {
      var c = unboxChar($receiver.peek());
      if (isDigit(c) || (allowHex && ((new CharRange(65, 70)).contains_mef7kx$(c) || (new CharRange(97, 102)).contains_mef7kx$(c)))) {
        buf.append_s8itvh$(unboxChar($receiver.next()));
      } else {
        break;
      }
    }
  }
  function ensureEOF($receiver, block) {
    var r = block();
    if (!$receiver.eof)
      throw new SyntaxException("Should've reached end of content", $receiver.eat().section);
    return r;
  }
  function eatMulti($receiver, types) {
    var transform = getCallableRef('eat', function ($receiver, p1) {
      return $receiver.eat_11rb$(p1);
    }.bind(null, $receiver));
    var destination = ArrayList_init_0(types.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== types.length; ++tmp$) {
      var item = types[tmp$];
      destination.add_11rb$(transform(item));
    }
    return destination;
  }
  function GrammarBuilder() {
    this.prefix_0 = LinkedHashMap_init();
    this.infix_0 = LinkedHashMap_init();
  }
  GrammarBuilder.prototype.import_6g5tfb$$default = function (override, grammars) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== grammars.length; ++tmp$) {
      var element = grammars[tmp$];
      var tmp$_0;
      tmp$_0 = element.prefix.entries.iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        var k = element_0.key;
        var v = element_0.value;
        this.prefix_uhlc8g$(k, v, override);
      }
      var tmp$_1;
      tmp$_1 = element.infix.entries.iterator();
      while (tmp$_1.hasNext()) {
        var element_1 = tmp$_1.next();
        var k_0 = element_1.key;
        var v_0 = element_1.value;
        this.infix_lx5ia$(k_0, v_0, override);
      }
    }
  };
  GrammarBuilder.prototype.prefix_uhlc8g$$default = function (type, parselet, override) {
    var tmp$ = !override;
    if (tmp$) {
      var $receiver = this.prefix_0;
      var tmp$_0;
      tmp$ = (Kotlin.isType(tmp$_0 = $receiver, Map) ? tmp$_0 : throwCCE()).containsKey_11rb$(type);
    }if (tmp$) {
      throw IllegalArgumentException_init('Prefix parselet associated with ' + type + ' already exists. Did you forget to enable overriding?');
    }this.prefix_0.put_xwzc9p$(type, parselet);
  };
  GrammarBuilder.prototype.prefix_ggj8ix$$default = function (type, override, block) {
    this.prefix_uhlc8g$(type, new PrefixParseletImpl(block));
  };
  GrammarBuilder.prototype.infix_lx5ia$$default = function (type, parselet, override) {
    var tmp$ = !override;
    if (tmp$) {
      var $receiver = this.infix_0;
      var tmp$_0;
      tmp$ = (Kotlin.isType(tmp$_0 = $receiver, Map) ? tmp$_0 : throwCCE()).containsKey_11rb$(type);
    }if (tmp$) {
      throw IllegalArgumentException_init('Infix parselet associated with ' + type + ' already exists. Did you forget to enable overriding?');
    }this.infix_0.put_xwzc9p$(type, parselet);
  };
  GrammarBuilder.prototype.infix_lfjh7$$default = function (type, precedence, override, block) {
    this.infix_lx5ia$(type, new InfixParseletImpl(precedence, block));
  };
  GrammarBuilder.prototype.build_8be2vx$ = function () {
    return new Grammar(toMap(this.prefix_0), toMap(this.infix_0));
  };
  GrammarBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrammarBuilder',
    interfaces: [GrammarDSL]
  };
  function InfixParseletImpl(precedence, block) {
    this.precedence_zbffus$_0 = precedence;
    this.block_0 = block;
  }
  Object.defineProperty(InfixParseletImpl.prototype, 'precedence', {
    get: function () {
      return this.precedence_zbffus$_0;
    }
  });
  InfixParseletImpl.prototype.parse_eufodf$ = function (ctx, left, token) {
    return this.block_0(ctx, left, token);
  };
  InfixParseletImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InfixParseletImpl',
    interfaces: [InfixParselet]
  };
  var lineSeparators;
  function calculateLineRanges($receiver) {
    var tmp$;
    var currentIndex = 0;
    var nextIndex = 0;
    var list = ArrayList_init();
    while (nextIndex < $receiver.length) {
      tmp$ = findAnyOf($receiver, lineSeparators, nextIndex);
      if (tmp$ == null) {
        break;
      }var index = tmp$.component1()
      , s = tmp$.component2();
      var length = s.length;
      var element = until(currentIndex, index + length | 0);
      list.add_11rb$(element);
      currentIndex = index + length | 0;
      nextIndex = currentIndex + (length === 0 ? 1 : 0) | 0;
    }
    var element_0 = new IntRange(currentIndex, get_lastIndex($receiver));
    list.add_11rb$(element_0);
    return list;
  }
  function LexerImpl(root) {
    this.matcher_0 = LexerImpl$LexerImpl$LexerMatcher_init(root);
  }
  LexerImpl.prototype.parse_mi27kl$ = function (source, output) {
    var $this = new LexerImpl$ContextImpl(this, source, output);
    $this.reader;
    while ($this.hasNext())
      this.doParse_0($this);
  };
  LexerImpl.prototype.doParse_0 = function (impl, ctx) {
    if (ctx === void 0)
      ctx = impl;
    if (impl.hasNext()) {
      impl.read = 0;
      var function_0 = this.doMatch_0(this.matcher_0, impl).onMatch;
      if (function_0 != null) {
        function_0(ctx, impl.curr);
      } else {
        this.skipUntilMatch_0(this.matcher_0, impl);
        var section_0 = section(impl, impl.read);
        throw new SyntaxException("No matcher registered for '" + section_0.substring + "'", section_0);
      }
      if (impl.read === 0)
        throw IllegalStateException_init('No further characters consumed.');
    }};
  function LexerImpl$LexerMatcher(trie, predicates, onMatch) {
    this.trie_0 = trie;
    this.predicates_0 = predicates;
    this.onMatch = onMatch;
  }
  LexerImpl$LexerMatcher.prototype.tryMatchChild_s8itvh$ = function (char) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$_0 = this.trie_0.get_11rb$(toBoxedChar(char))) != null)
      tmp$_1 = tmp$_0;
    else {
      var $receiver = this.predicates_0;
      var firstOrNull$result;
      firstOrNull$break: do {
        var tmp$_2;
        tmp$_2 = $receiver.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          if (element.predicate.test_s8itvh$(char)) {
            firstOrNull$result = element;
            break firstOrNull$break;
          }}
        firstOrNull$result = null;
      }
       while (false);
      tmp$_1 = (tmp$ = firstOrNull$result) != null ? tmp$.matcher : null;
    }
    return tmp$_1;
  };
  LexerImpl$LexerMatcher.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexerMatcher',
    interfaces: []
  };
  function LexerImpl$LexerImpl$LexerMatcher_init(m, $this) {
    $this = $this || Object.create(LexerImpl$LexerMatcher.prototype);
    var $receiver = m.trie;
    var destination = LinkedHashMap_init();
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (!element.value.isEmpty()) {
        destination.put_xwzc9p$(element.key, element.value);
      }}
    var destination_0 = LinkedHashMap_init_0(mapCapacity(destination.size));
    var tmp$_0;
    tmp$_0 = destination.entries.iterator();
    while (tmp$_0.hasNext()) {
      var element_0 = tmp$_0.next();
      destination_0.put_xwzc9p$(element_0.key, LexerImpl$LexerImpl$LexerMatcher_init(element_0.value));
    }
    var $receiver_0 = m.predicates;
    var destination_1 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var element_1 = tmp$_1.next();
      if (!element_1.isMatcherEmpty())
        destination_1.add_11rb$(element_1);
    }
    var destination_2 = ArrayList_init_0(collectionSizeOrDefault(destination_1, 10));
    var tmp$_2;
    tmp$_2 = destination_1.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      destination_2.add_11rb$(LexerImpl$LexerImpl$LexerMatcherWithPredicate_init(item));
    }
    LexerImpl$LexerMatcher.call($this, destination_0, destination_2, m.onMatch);
    return $this;
  }
  function LexerImpl$LexerMatcherWithPredicate(predicate, matcher) {
    this.predicate = predicate;
    this.matcher = matcher;
  }
  LexerImpl$LexerMatcherWithPredicate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexerMatcherWithPredicate',
    interfaces: []
  };
  function LexerImpl$LexerImpl$LexerMatcherWithPredicate_init(m, $this) {
    $this = $this || Object.create(LexerImpl$LexerMatcherWithPredicate.prototype);
    LexerImpl$LexerMatcherWithPredicate.call($this, m.predicate, LexerImpl$LexerImpl$LexerMatcher_init(m.matcher));
    return $this;
  }
  LexerImpl.prototype.skipUntilMatch_0 = function ($receiver, ctx) {
    if (!ctx.hasNext())
      return;
    var char = unboxChar(ctx.peek());
    if ($receiver.tryMatchChild_s8itvh$(char) != null || char === 10)
      return;
    ctx.next();
    this.skipUntilMatch_0($receiver, ctx);
  };
  LexerImpl.prototype.doMatch_0 = function ($receiver, ctx, eat) {
    if (eat === void 0)
      eat = false;
    var tmp$;
    if (eat)
      ctx.next();
    tmp$ = $receiver.tryMatchChild_s8itvh$(unboxChar(ctx.peek()));
    if (tmp$ == null) {
      return $receiver;
    }return this.doMatch_0(tmp$, ctx, true);
  };
  function LexerImpl$ContextImpl($outer, source, output) {
    this.$outer = $outer;
    this.source_29hdz4$_0 = source;
    this.output_0 = output;
    this.reader_lzko14$_0 = new StringReader(this.source.content);
    this.read = 0;
    this.index_9ewum1$_0 = 0;
    this.curr = toBoxedChar(toChar(-1));
  }
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'source', {
    get: function () {
      return this.source_29hdz4$_0;
    }
  });
  function LexerImpl$ContextImpl$CollectingContext($outer, collection) {
    this.$outer = $outer;
    this.collection_0 = collection;
    this.$delegate_3p7y2g$_0 = this.$outer;
  }
  LexerImpl$ContextImpl$CollectingContext.prototype.process_11rb$ = function (token) {
    this.collection_0.add_11rb$(token);
  };
  Object.defineProperty(LexerImpl$ContextImpl$CollectingContext.prototype, 'index', {
    configurable: true,
    get: function () {
      return this.$delegate_3p7y2g$_0.index;
    }
  });
  Object.defineProperty(LexerImpl$ContextImpl$CollectingContext.prototype, 'reader', {
    configurable: true,
    get: function () {
      return this.$delegate_3p7y2g$_0.reader;
    }
  });
  Object.defineProperty(LexerImpl$ContextImpl$CollectingContext.prototype, 'source', {
    configurable: true,
    get: function () {
      return this.$delegate_3p7y2g$_0.source;
    }
  });
  LexerImpl$ContextImpl$CollectingContext.prototype.hasNext = function () {
    return this.$delegate_3p7y2g$_0.hasNext();
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.match_s8itvh$ = function (expect) {
    return this.$delegate_3p7y2g$_0.match_s8itvh$(expect);
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.next = function () {
    return this.$delegate_3p7y2g$_0.next();
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.nextString_za3lpa$ = function (length) {
    return this.$delegate_3p7y2g$_0.nextString_za3lpa$(length);
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.parseOnce = function () {
    return this.$delegate_3p7y2g$_0.parseOnce();
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.peek = function () {
    return this.$delegate_3p7y2g$_0.peek();
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.peek_za3lpa$ = function (distance) {
    return this.$delegate_3p7y2g$_0.peek_za3lpa$(distance);
  };
  LexerImpl$ContextImpl$CollectingContext.prototype.peekString_za3lpa$ = function (length) {
    return this.$delegate_3p7y2g$_0.peekString_za3lpa$(length);
  };
  LexerImpl$ContextImpl$CollectingContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CollectingContext',
    interfaces: [LexerContext]
  };
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'reader', {
    configurable: true,
    get: function () {
      return this.reader_lzko14$_0;
    }
  });
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'index', {
    configurable: true,
    get: function () {
      return this.index_9ewum1$_0;
    },
    set: function (index) {
      this.index_9ewum1$_0 = index;
    }
  });
  LexerImpl$ContextImpl.prototype.peek = function () {
    this.reader.mark_za3lpa$(1);
    var c = toChar(this.reader.read());
    this.reader.reset();
    return toBoxedChar(c);
  };
  LexerImpl$ContextImpl.prototype.peek_za3lpa$ = function (distance) {
    this.reader.mark_za3lpa$(distance + 1 | 0);
    var value = -1;
    for (var i = 0; i < distance; i++) {
      var next = this.reader.read();
      if (next === -1) {
        value = -1;
        break;
      } else if (i !== (distance - 1 | 0)) {
        continue;
      }value = next;
    }
    this.reader.reset();
    return toBoxedChar(toChar(value));
  };
  LexerImpl$ContextImpl.prototype.peekString_za3lpa$ = function (length) {
    this.reader.mark_za3lpa$(length);
    var $receiver = StringBuilder_init_0(length);
    for (var i = 0; i < length; i++) {
      var next = this.reader.read();
      if (next === -1)
        break;
      $receiver.append_s8itvh$(toChar(next));
    }
    var value = $receiver.toString();
    this.reader.reset();
    return value;
  };
  LexerImpl$ContextImpl.prototype.match_s8itvh$ = function (expect) {
    var matched = unboxChar(this.peek()) === expect;
    if (matched)
      this.next();
    return matched;
  };
  LexerImpl$ContextImpl.prototype.hasNext = function () {
    this.reader.mark_za3lpa$(1);
    var i = this.reader.read();
    this.reader.reset();
    return i > 0;
  };
  LexerImpl$ContextImpl.prototype.next = function () {
    var c = toChar(this.reader.read());
    this.read = this.read + 1 | 0;
    this.index = this.index + 1 | 0;
    this.curr = toBoxedChar(c);
    return toBoxedChar(c);
  };
  LexerImpl$ContextImpl.prototype.nextString_za3lpa$ = function (length) {
    var $receiver = StringBuilder_init_0(length);
    var tmp$;
    var i = 0;
    while (this.hasNext() && (tmp$ = i, i = tmp$ + 1 | 0, tmp$) < length)
      $receiver.append_s8itvh$(unboxChar(this.next()));
    return $receiver.toString();
  };
  LexerImpl$ContextImpl.prototype.process_11rb$ = function (token) {
    this.output_0(token);
  };
  LexerImpl$ContextImpl.prototype.parseOnce = function () {
    var $receiver = ArrayList_init();
    this.$outer;
    this.$outer.doParse_0(this, new LexerImpl$ContextImpl$CollectingContext(this, $receiver));
    return $receiver;
  };
  LexerImpl$ContextImpl.prototype.use_27hm72$ = function (block) {
    this.reader;
    return block(this);
  };
  LexerImpl$ContextImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ContextImpl',
    interfaces: [LexerContext]
  };
  LexerImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexerImpl',
    interfaces: [Lexer]
  };
  function MatcherImpl() {
    this.trie = LinkedHashMap_init();
    this.predicates = ArrayList_init();
    this.onMatch = null;
  }
  function MatcherImpl$MatcherWithPredicate(predicate, matcher) {
    this.predicate = predicate;
    this.matcher = matcher;
  }
  MatcherImpl$MatcherWithPredicate.prototype.isMatcherEmpty = function () {
    return this.matcher.isEmpty();
  };
  MatcherImpl$MatcherWithPredicate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MatcherWithPredicate',
    interfaces: []
  };
  MatcherImpl.prototype.isEmpty = function () {
    return this.trie.isEmpty() && this.predicates.isEmpty() && this.onMatch == null;
  };
  MatcherImpl.prototype.matching_61zpoe$ = function (string) {
    var tmp$;
    switch (string.length) {
      case 0:
        tmp$ = this;
        break;
      case 1:
        tmp$ = this.matching_s8itvh$(first_0(string));
        break;
      default:var tmp$_0;
        var accumulator = this;
        tmp$_0 = iterator(string);
        while (tmp$_0.hasNext()) {
          var element = unboxChar(tmp$_0.next());
          accumulator = accumulator.matching_s8itvh$(unboxChar(toBoxedChar(element)));
        }

        tmp$ = accumulator;
        break;
    }
    return tmp$;
  };
  MatcherImpl.prototype.matching_s8itvh$ = function (char) {
    var $receiver = this.trie;
    var key = toBoxedChar(char);
    var tmp$;
    var value = $receiver.get_11rb$(key);
    if (value == null) {
      var answer = new MatcherImpl();
      $receiver.put_xwzc9p$(key, answer);
      tmp$ = answer;
    } else {
      tmp$ = value;
    }
    return tmp$;
  };
  MatcherImpl.prototype.matching_uw7fcc$ = function (block) {
    var matcher = new MatcherImpl();
    var $receiver = this.predicates;
    var element = new MatcherImpl$MatcherWithPredicate(block, matcher);
    $receiver.add_11rb$(element);
    return matcher;
  };
  MatcherImpl.prototype.configure_t5ujie$ = function (block) {
    this.onMatch = block;
  };
  MatcherImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MatcherImpl',
    interfaces: [LexerDSL]
  };
  function ParserImpl(grammar, block) {
    this.grammar_oashss$_0 = grammar;
    this.block_0 = block;
  }
  Object.defineProperty(ParserImpl.prototype, 'grammar', {
    get: function () {
      return this.grammar_oashss$_0;
    }
  });
  ParserImpl.prototype.parse_qvx10v$ = function (source, tokens) {
    return this.block_0(new ParserImpl$ContextImpl(this, source, tokens, this.grammar));
  };
  function ParserImpl$ContextImpl($outer, source, tokens, grammar) {
    this.$outer = $outer;
    this.source_a7refj$_0 = source;
    this.grammar_5atiqr$_0 = grammar;
    this.tokens_0 = toMutableList(tokens);
    this.index_dle8x4$_0 = 0;
  }
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'source', {
    get: function () {
      return this.source_a7refj$_0;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'grammar', {
    get: function () {
      return this.grammar_5atiqr$_0;
    }
  });
  function ParserImpl$ContextImpl$ChildContextImpl($outer, grammar) {
    this.$outer = $outer;
    this.grammar_mwoigy$_0 = grammar;
    this.$delegate_uplf99$_0 = this.$outer;
  }
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'grammar', {
    get: function () {
      return this.grammar_mwoigy$_0;
    }
  });
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_za3lpa$$default = function (precedence) {
    return this.$outer.parseExpr_0(this.grammar, precedence);
  };
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'eof', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.eof;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'index', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.index;
    },
    set: function (tmp$) {
      this.$delegate_uplf99$_0.index = tmp$;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'last', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.last;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'source', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.source;
    }
  });
  ParserImpl$ContextImpl$ChildContextImpl.prototype.back = function () {
    return this.$delegate_uplf99$_0.back();
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.eat = function () {
    return this.$delegate_uplf99$_0.eat();
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.eat_11rb$ = function (type) {
    return this.$delegate_uplf99$_0.eat_11rb$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.match_11rb$ = function (type) {
    return this.$delegate_uplf99$_0.match_11rb$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.matchAny_7l2mas$ = function (type) {
    return this.$delegate_uplf99$_0.matchAny_7l2mas$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.nextIs_11rb$ = function (type) {
    return this.$delegate_uplf99$_0.nextIs_11rb$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.nextIsAny_7l2mas$ = function (types) {
    return this.$delegate_uplf99$_0.nextIsAny_7l2mas$(types);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.peek_za3lpa$$default = function (distance) {
    return this.$delegate_uplf99$_0.peek_za3lpa$$default(distance);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.peekAheadUntil_7l2mas$ = function (type) {
    return this.$delegate_uplf99$_0.peekAheadUntil_7l2mas$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.skipUntil_7l2mas$ = function (type) {
    return this.$delegate_uplf99$_0.skipUntil_7l2mas$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.withGrammar_ugt3wb$ = function (grammar) {
    return this.$delegate_uplf99$_0.withGrammar_ugt3wb$(grammar);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_6t5y4q$$default = function ($receiver, precedence) {
    return this.$delegate_uplf99$_0.parseExpression_6t5y4q$$default($receiver, precedence);
  };
  ParserImpl$ContextImpl$ChildContextImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChildContextImpl',
    interfaces: [ParserContext]
  };
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'index', {
    configurable: true,
    get: function () {
      return this.index_dle8x4$_0;
    },
    set: function (index) {
      this.index_dle8x4$_0 = index;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'eof', {
    configurable: true,
    get: function () {
      return this.index === this.tokens_0.size;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'last', {
    configurable: true,
    get: function () {
      return this.tokens_0.get_za3lpa$(this.index - 1 | 0);
    }
  });
  ParserImpl$ContextImpl.prototype.withGrammar_ugt3wb$ = function (grammar) {
    return new ParserImpl$ContextImpl$ChildContextImpl(this, grammar);
  };
  ParserImpl$ContextImpl.prototype.parseExpression_za3lpa$$default = function (precedence) {
    return this.parseExpr_0(this.grammar, precedence);
  };
  ParserImpl$ContextImpl.prototype.eat = function () {
    var tmp$;
    if (this.eof)
      throw new SyntaxException('Expected token but reached end of file', this.last.section);
    return this.tokens_0.get_za3lpa$((tmp$ = this.index, this.index = tmp$ + 1 | 0, tmp$));
  };
  ParserImpl$ContextImpl.prototype.eat_11rb$ = function (type) {
    if (this.eof)
      throw new SyntaxException('Expected ' + type + ' but reached end of file', this.last.section);
    var token = this.peek_za3lpa$();
    if (!equals(token.type, type)) {
      throw new SyntaxException("Expected '" + type + "' but found '" + token.type + "'.", token.section);
    }return this.eat();
  };
  ParserImpl$ContextImpl.prototype.match_11rb$ = function (type) {
    var shouldEat = this.nextIs_11rb$(type);
    if (shouldEat)
      this.eat();
    return shouldEat;
  };
  ParserImpl$ContextImpl.prototype.matchAny_7l2mas$ = function (type) {
    var shouldEat = this.nextIsAny_7l2mas$(type.slice());
    if (shouldEat)
      this.eat();
    return shouldEat;
  };
  ParserImpl$ContextImpl.prototype.back = function () {
    return this.tokens_0.get_za3lpa$((this.index = this.index - 1 | 0, this.index));
  };
  ParserImpl$ContextImpl.prototype.peek_za3lpa$$default = function (distance) {
    return this.tokens_0.get_za3lpa$(this.index + distance | 0);
  };
  ParserImpl$ContextImpl.prototype.nextIs_11rb$ = function (type) {
    return !this.eof && equals(this.peek_za3lpa$().type, type);
  };
  ParserImpl$ContextImpl.prototype.nextIsAny_7l2mas$ = function (types) {
    var tmp$ = !this.eof;
    if (tmp$) {
      var any$result;
      any$break: do {
        var tmp$_0;
        for (tmp$_0 = 0; tmp$_0 !== types.length; ++tmp$_0) {
          var element = types[tmp$_0];
          if (this.nextIs_11rb$(element)) {
            any$result = true;
            break any$break;
          }}
        any$result = false;
      }
       while (false);
      tmp$ = any$result;
    }return tmp$;
  };
  ParserImpl$ContextImpl.prototype.peekAheadUntil_7l2mas$ = function (type) {
    if (this.eof)
      return emptyList();
    var list = ArrayList_init();
    var lastIndex = this.index;
    while (!this.eof && !this.nextIsAny_7l2mas$(type.slice())) {
      var element = this.eat();
      list.add_11rb$(element);
    }
    this.index = lastIndex;
    return list;
  };
  ParserImpl$ContextImpl.prototype.skipUntil_7l2mas$ = function (type) {
    while (!this.eof && !this.nextIsAny_7l2mas$(type.slice()))
      this.eat();
  };
  ParserImpl$ContextImpl.prototype.parseExpr_0 = function (grammar, precedence) {
    var tmp$, tmp$_0;
    var it = this.eat();
    var tmp$_1, tmp$_2;
    tmp$_2 = (tmp$_1 = grammar.prefix.get_11rb$(it.type)) != null ? tmp$_1.parse_6srjs1$(this, it) : null;
    if (tmp$_2 == null) {
      throw new SyntaxException('Unexpected ' + it, it.section);
    }var left = {v: tmp$_2};
    while (!this.eof && precedence < ((tmp$_0 = (tmp$ = this.grammar.infix.get_11rb$(this.peek_za3lpa$(0).type)) != null ? tmp$.precedence : null) != null ? tmp$_0 : 0)) {
      var it_0 = this.eat();
      var tmp$_3, tmp$_4;
      tmp$_4 = (tmp$_3 = grammar.infix.get_11rb$(it_0.type)) != null ? tmp$_3.parse_eufodf$(this, left.v, it_0) : null;
      if (tmp$_4 == null) {
        throw new SyntaxException('Unexpected ' + it_0, it_0.section);
      }left.v = tmp$_4;
    }
    return left.v;
  };
  ParserImpl$ContextImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ContextImpl',
    interfaces: [ParserContext]
  };
  ParserImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParserImpl',
    interfaces: [Parser]
  };
  function PrefixParseletImpl(block) {
    this.block_0 = block;
  }
  PrefixParseletImpl.prototype.parse_6srjs1$ = function (ctx, token) {
    return this.block_0(ctx, token);
  };
  PrefixParseletImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PrefixParseletImpl',
    interfaces: [PrefixParselet]
  };
  function StringReader(s) {
    this.str_0 = s;
    this.length_0 = s.length;
    this.next_0 = 0;
    this.mark_0 = 0;
  }
  StringReader.prototype.read = function () {
    var tmp$, tmp$_0;
    if (this.next_0 >= this.length_0)
      tmp$_0 = -1;
    else {
      tmp$_0 = this.str_0.charCodeAt((tmp$ = this.next_0, this.next_0 = tmp$ + 1 | 0, tmp$)) | 0;
    }
    return tmp$_0;
  };
  StringReader.prototype.skip_s8cxhz$ = function (ns) {
    if (this.next_0 >= this.length_0)
      return L0;
    var a = Kotlin.Long.fromInt(this.length_0).subtract(Kotlin.Long.fromInt(this.next_0));
    var n = a.compareTo_11rb$(ns) <= 0 ? a : ns;
    var a_0 = Kotlin.Long.fromInt(this.next_0).unaryMinus();
    var b = n;
    n = a_0.compareTo_11rb$(b) >= 0 ? a_0 : b;
    this.next_0 = this.next_0 + n.toInt() | 0;
    return n;
  };
  StringReader.prototype.mark_za3lpa$ = function (readAheadLimit) {
    if (!(readAheadLimit >= 0)) {
      var message = 'Read-ahead limit < 0';
      throw IllegalArgumentException_init(message.toString());
    }this.mark_0 = this.next_0;
  };
  StringReader.prototype.reset = function () {
    this.next_0 = this.mark_0;
  };
  StringReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StringReader',
    interfaces: []
  };
  var using = defineInlineFunction('tartar-js-legacy.com.github.adriantodt.tartar.impl.using_jh6u7y$', function ($receiver, block) {
    return block($receiver);
  });
  Object.defineProperty(CharPredicate, 'Companion', {
    get: CharPredicate$Companion_getInstance
  });
  var package$com = _.com || (_.com = {});
  var package$github = package$com.github || (package$com.github = {});
  var package$adriantodt = package$github.adriantodt || (package$github.adriantodt = {});
  var package$tartar = package$adriantodt.tartar || (package$adriantodt.tartar = {});
  var package$api = package$tartar.api || (package$tartar.api = {});
  var package$dsl = package$api.dsl || (package$api.dsl = {});
  package$dsl.CharPredicate = CharPredicate;
  package$dsl.GrammarDSL = GrammarDSL;
  package$dsl.LexerDSL = LexerDSL;
  Object.defineProperty(Grammar, 'Companion', {
    get: Grammar$Companion_getInstance
  });
  var package$grammar = package$api.grammar || (package$api.grammar = {});
  package$grammar.Grammar = Grammar;
  package$grammar.InfixParselet = InfixParselet;
  package$grammar.PrefixParselet = PrefixParselet;
  Object.defineProperty(Lexer, 'Companion', {
    get: Lexer$Companion_getInstance
  });
  var package$lexer = package$api.lexer || (package$api.lexer = {});
  package$lexer.Lexer = Lexer;
  package$lexer.LexerContext = LexerContext;
  package$lexer.Section = Section;
  package$lexer.Sectional = Sectional;
  Source.Line = Source$Line;
  Object.defineProperty(Source, 'Companion', {
    get: Source$Companion_getInstance
  });
  package$lexer.Source = Source;
  Object.defineProperty(Parser, 'Companion', {
    get: Parser$Companion_getInstance
  });
  var package$parser = package$api.parser || (package$api.parser = {});
  package$parser.Parser = Parser;
  package$parser.ParserContext = ParserContext;
  Object.defineProperty(SourceParser, 'Companion', {
    get: SourceParser$Companion_getInstance
  });
  package$parser.SourceParser = SourceParser;
  package$parser.SyntaxException = SyntaxException;
  package$parser.Token = Token;
  var package$extensions = package$tartar.extensions || (package$tartar.extensions = {});
  package$extensions.section_crcbr0$ = section;
  package$extensions.makeToken_vz4fks$ = makeToken;
  package$extensions.makeToken_o70ryi$ = makeToken_0;
  package$extensions.readIdentifier_t5y1tw$ = readIdentifier;
  package$extensions.readString_ct20bp$ = readString;
  package$extensions.readNumber_ct20bp$ = readNumber;
  LexicalNumber.Invalid = LexicalNumber$Invalid;
  LexicalNumber.Decimal = LexicalNumber$Decimal;
  LexicalNumber.Integer = LexicalNumber$Integer;
  package$extensions.LexicalNumber = LexicalNumber;
  package$extensions.ensureEOF_p3mmbm$ = ensureEOF;
  package$extensions.eatMulti_fzf39z$ = eatMulti;
  var package$impl = package$tartar.impl || (package$tartar.impl = {});
  package$impl.GrammarBuilder = GrammarBuilder;
  package$impl.InfixParseletImpl = InfixParseletImpl;
  package$impl.calculateLineRanges_hoxr6g$ = calculateLineRanges;
  $$importsForInline$$['tartar-js-legacy'] = _;
  package$impl.LexerImpl = LexerImpl;
  MatcherImpl.MatcherWithPredicate = MatcherImpl$MatcherWithPredicate;
  package$impl.MatcherImpl = MatcherImpl;
  package$impl.ParserImpl = ParserImpl;
  package$impl.PrefixParseletImpl = PrefixParseletImpl;
  package$lexer.StringReader = StringReader;
  package$impl.using_jh6u7y$ = using;
  Token.prototype.span_p684zu$ = Sectional.prototype.span_p684zu$;
  GrammarBuilder.prototype.import_6g5tfb$ = GrammarDSL.prototype.import_6g5tfb$;
  GrammarBuilder.prototype.prefix_uhlc8g$ = GrammarDSL.prototype.prefix_uhlc8g$;
  GrammarBuilder.prototype.prefix_ggj8ix$ = GrammarDSL.prototype.prefix_ggj8ix$;
  GrammarBuilder.prototype.infix_lx5ia$ = GrammarDSL.prototype.infix_lx5ia$;
  GrammarBuilder.prototype.infix_lfjh7$ = GrammarDSL.prototype.infix_lfjh7$;
  LexerImpl.prototype.parseTo_32dq1j$ = Lexer.prototype.parseTo_32dq1j$;
  LexerImpl.prototype.parseToList_llobtt$ = Lexer.prototype.parseToList_llobtt$;
  MatcherImpl.prototype.matching_xibcvw$ = LexerDSL.prototype.matching_xibcvw$;
  MatcherImpl.prototype.matching_eerp9d$ = LexerDSL.prototype.matching_eerp9d$;
  MatcherImpl.prototype.invoke_sdqmiu$$default = LexerDSL.prototype.invoke_sdqmiu$$default;
  MatcherImpl.prototype.invoke_vp8vqt$$default = LexerDSL.prototype.invoke_vp8vqt$$default;
  MatcherImpl.prototype.invoke_sdqmiu$ = LexerDSL.prototype.invoke_sdqmiu$;
  MatcherImpl.prototype.invoke_vp8vqt$ = LexerDSL.prototype.invoke_vp8vqt$;
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_za3lpa$ = ParserContext.prototype.parseExpression_za3lpa$;
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_6t5y4q$ = ParserContext.prototype.parseExpression_6t5y4q$;
  ParserImpl$ContextImpl$ChildContextImpl.prototype.peek_za3lpa$ = ParserContext.prototype.peek_za3lpa$;
  ParserImpl$ContextImpl.prototype.parseExpression_6t5y4q$$default = ParserContext.prototype.parseExpression_6t5y4q$$default;
  ParserImpl$ContextImpl.prototype.parseExpression_za3lpa$ = ParserContext.prototype.parseExpression_za3lpa$;
  ParserImpl$ContextImpl.prototype.parseExpression_6t5y4q$ = ParserContext.prototype.parseExpression_6t5y4q$;
  ParserImpl$ContextImpl.prototype.peek_za3lpa$ = ParserContext.prototype.peek_za3lpa$;
  ParserImpl.prototype.parse_r7b30y$ = Parser.prototype.parse_r7b30y$;
  lineSeparators = listOf(['\r\n', '\n', '\r']);
  Kotlin.defineModule('tartar-js-legacy', _);
  return _;
}));

//# sourceMappingURL=tartar-js-legacy.js.map
