(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'tartar-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'tartar-js-legacy'.");
    }root['tartar-js-legacy'] = factory(typeof this['tartar-js-legacy'] === 'undefined' ? {} : this['tartar-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Unit = Kotlin.kotlin.Unit;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var JsMath = Math;
  var lines = Kotlin.kotlin.text.lines_gw00vp$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var RuntimeException = Kotlin.kotlin.RuntimeException;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var unboxChar = Kotlin.unboxChar;
  var getCallableRef = Kotlin.getCallableRef;
  var toBoxedChar = Kotlin.toBoxedChar;
  var toIntOrNull = Kotlin.kotlin.text.toIntOrNull_6ic1pp$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var toIntOrNull_0 = Kotlin.kotlin.text.toIntOrNull_pdl1vz$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var toMap = Kotlin.kotlin.collections.toMap_abgq59$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var Map = Kotlin.kotlin.collections.Map;
  var throwCCE = Kotlin.throwCCE;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var toChar = Kotlin.toChar;
  var generateSequence = Kotlin.kotlin.sequences.generateSequence_9ce4rd$;
  var take = Kotlin.kotlin.sequences.take_wuwhe2$;
  var toList = Kotlin.kotlin.sequences.toList_veqyi0$;
  var StringBuilder_init_0 = Kotlin.kotlin.text.StringBuilder_init_za3lpa$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var first = Kotlin.kotlin.text.first_gw00vp$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var equals = Kotlin.equals;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var L0 = Kotlin.Long.ZERO;
  SyntaxException.prototype = Object.create(RuntimeException.prototype);
  SyntaxException.prototype.constructor = SyntaxException;
  LexicalNumber$Invalid.prototype = Object.create(LexicalNumber.prototype);
  LexicalNumber$Invalid.prototype.constructor = LexicalNumber$Invalid;
  LexicalNumber$Decimal.prototype = Object.create(LexicalNumber.prototype);
  LexicalNumber$Decimal.prototype.constructor = LexicalNumber$Decimal;
  LexicalNumber$Integer.prototype = Object.create(LexicalNumber.prototype);
  LexicalNumber$Integer.prototype.constructor = LexicalNumber$Integer;
  function createLexer(block) {
    var $receiver = new MatcherImpl();
    block($receiver);
    return new LexerImpl($receiver);
  }
  function createGrammar(block) {
    var $receiver = new GrammarBuilder();
    block($receiver);
    return $receiver.build();
  }
  function createParser(grammar, block) {
    return new ParserImpl(grammar, block);
  }
  function GrammarDSL() {
  }
  GrammarDSL.prototype.import_ha5jj$ = function (override, grammars, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(override, grammars) : this.import_ha5jj$$default(override, grammars);
  };
  GrammarDSL.prototype.prefix_bb9afj$ = function (type, parselet, override, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, parselet, override) : this.prefix_bb9afj$$default(type, parselet, override);
  };
  GrammarDSL.prototype.prefix_ggj8ix$ = function (type, override, block, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, override, block) : this.prefix_ggj8ix$$default(type, override, block);
  };
  GrammarDSL.prototype.infix_wdcr7z$ = function (type, parselet, override, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, parselet, override) : this.infix_wdcr7z$$default(type, parselet, override);
  };
  GrammarDSL.prototype.infix_lfjh7$ = function (type, precedence, override, block, callback$default) {
    if (override === void 0)
      override = false;
    callback$default ? callback$default(type, precedence, override, block) : this.infix_lfjh7$$default(type, precedence, override, block);
  };
  GrammarDSL.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GrammarDSL',
    interfaces: []
  };
  function LexerDSL() {
  }
  LexerDSL.prototype.invoke_sdqmiu$$default = function ($receiver, block) {
    this.matching_s8itvh$($receiver).configure_t5ujie$(block);
  };
  function LexerDSL$invoke$lambda($receiver, it) {
    return Unit;
  }
  LexerDSL.prototype.invoke_sdqmiu$ = function ($receiver, block, callback$default) {
    if (block === void 0)
      block = LexerDSL$invoke$lambda;
    callback$default ? callback$default($receiver, block) : this.invoke_sdqmiu$$default($receiver, block);
  };
  LexerDSL.prototype.invoke_vp8vqt$$default = function ($receiver, block) {
    this.matching_61zpoe$($receiver).configure_t5ujie$(block);
  };
  function LexerDSL$invoke$lambda_0($receiver, it) {
    return Unit;
  }
  LexerDSL.prototype.invoke_vp8vqt$ = function ($receiver, block, callback$default) {
    if (block === void 0)
      block = LexerDSL$invoke$lambda_0;
    callback$default ? callback$default($receiver, block) : this.invoke_vp8vqt$$default($receiver, block);
  };
  LexerDSL.prototype.matching_6ils5n$ = function (string, block) {
    block(this.matching_61zpoe$(string));
  };
  LexerDSL.prototype.matching_uoi7m8$ = function (char, block) {
    block(this.matching_s8itvh$(char));
  };
  LexerDSL.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LexerDSL',
    interfaces: []
  };
  function Lexer() {
  }
  function Lexer$parseTo$lambda(closure$collection) {
    return function (it) {
      closure$collection.add_11rb$(it);
      return Unit;
    };
  }
  Lexer.prototype.parseTo_32dq1j$ = function (source, collection) {
    this.parse_mi27kl$(source, Lexer$parseTo$lambda(collection));
    return collection;
  };
  Lexer.prototype.parseToList_llobtt$ = function (source) {
    return this.parseTo_32dq1j$(source, ArrayList_init());
  };
  Lexer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Lexer',
    interfaces: []
  };
  function LexerContext() {
  }
  LexerContext.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LexerContext',
    interfaces: []
  };
  function Section(source, lineNumber, lineIndex, length) {
    this.source = source;
    this.lineNumber = lineNumber;
    this.lineIndex = lineIndex;
    this.length = length;
  }
  Object.defineProperty(Section.prototype, 'line', {
    configurable: true,
    get: function () {
      return this.source.lines.get_za3lpa$(this.lineNumber - 1 | 0);
    }
  });
  Object.defineProperty(Section.prototype, 'substring', {
    configurable: true,
    get: function () {
      var $receiver = this.source.lines.get_za3lpa$(this.lineNumber - 1 | 0);
      var startIndex = this.lineIndex;
      var endIndex = this.lineIndex + this.length | 0;
      return $receiver.substring(startIndex, endIndex);
    }
  });
  Section.prototype.span_pdml0f$ = function (other) {
    var tmp$;
    if (((tmp$ = this.source) != null ? tmp$.equals(other.source) : null) && this.lineNumber === other.lineNumber) {
      var a = this.lineIndex;
      var b = other.lineIndex;
      var min = JsMath.min(a, b);
      var a_0 = this.lineIndex + this.length | 0;
      var b_0 = other.lineIndex + other.length | 0;
      var max = JsMath.max(a_0, b_0);
      return new Section(this.source, this.lineNumber, min, max - min | 0);
    }throw IllegalStateException_init('section sources');
  };
  Section.prototype.toString = function () {
    return '(' + this.source.name + ':' + this.lineNumber + ':' + this.lineIndex + ')';
  };
  Section.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Section',
    interfaces: []
  };
  Section.prototype.component1 = function () {
    return this.source;
  };
  Section.prototype.component2 = function () {
    return this.lineNumber;
  };
  Section.prototype.component3 = function () {
    return this.lineIndex;
  };
  Section.prototype.component4 = function () {
    return this.length;
  };
  Section.prototype.copy_ne4z2l$ = function (source, lineNumber, lineIndex, length) {
    return new Section(source === void 0 ? this.source : source, lineNumber === void 0 ? this.lineNumber : lineNumber, lineIndex === void 0 ? this.lineIndex : lineIndex, length === void 0 ? this.length : length);
  };
  Section.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.lineNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.lineIndex) | 0;
    result = result * 31 + Kotlin.hashCode(this.length) | 0;
    return result;
  };
  Section.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.lineNumber, other.lineNumber) && Kotlin.equals(this.lineIndex, other.lineIndex) && Kotlin.equals(this.length, other.length)))));
  };
  function Sectional() {
  }
  Sectional.prototype.span_p684zu$ = function (other) {
    return this.section.span_pdml0f$(other.section);
  };
  Sectional.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Sectional',
    interfaces: []
  };
  function Source(content, name, path) {
    if (name === void 0)
      name = '?';
    if (path === void 0)
      path = '!!no path!!';
    this.content = content;
    this.name = name;
    this.path = path;
    this.lines = lines(this.content);
  }
  Source.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Source',
    interfaces: []
  };
  Source.prototype.component1 = function () {
    return this.content;
  };
  Source.prototype.component2 = function () {
    return this.name;
  };
  Source.prototype.component3 = function () {
    return this.path;
  };
  Source.prototype.copy_6hosri$ = function (content, name, path) {
    return new Source(content === void 0 ? this.content : content, name === void 0 ? this.name : name, path === void 0 ? this.path : path);
  };
  Source.prototype.toString = function () {
    return 'Source(content=' + Kotlin.toString(this.content) + (', name=' + Kotlin.toString(this.name)) + (', path=' + Kotlin.toString(this.path)) + ')';
  };
  Source.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.path) | 0;
    return result;
  };
  Source.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.content, other.content) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.path, other.path)))));
  };
  function Grammar(prefixParsers, infixParsers) {
    if (prefixParsers === void 0)
      prefixParsers = emptyMap();
    if (infixParsers === void 0)
      infixParsers = emptyMap();
    this.prefixParsers = prefixParsers;
    this.infixParsers = infixParsers;
  }
  Grammar.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Grammar',
    interfaces: []
  };
  Grammar.prototype.component1 = function () {
    return this.prefixParsers;
  };
  Grammar.prototype.component2 = function () {
    return this.infixParsers;
  };
  Grammar.prototype.copy_bdhv32$ = function (prefixParsers, infixParsers) {
    return new Grammar(prefixParsers === void 0 ? this.prefixParsers : prefixParsers, infixParsers === void 0 ? this.infixParsers : infixParsers);
  };
  Grammar.prototype.toString = function () {
    return 'Grammar(prefixParsers=' + Kotlin.toString(this.prefixParsers) + (', infixParsers=' + Kotlin.toString(this.infixParsers)) + ')';
  };
  Grammar.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.prefixParsers) | 0;
    result = result * 31 + Kotlin.hashCode(this.infixParsers) | 0;
    return result;
  };
  Grammar.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.prefixParsers, other.prefixParsers) && Kotlin.equals(this.infixParsers, other.infixParsers)))));
  };
  function InfixParser() {
  }
  InfixParser.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InfixParser',
    interfaces: []
  };
  function Parser() {
  }
  Parser.prototype.parse_r7b30y$ = function (source, lexer) {
    return this.parse_7y97bu$(lexer.parseToList_llobtt$(source));
  };
  Parser.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Parser',
    interfaces: []
  };
  function ParserContext() {
  }
  ParserContext.prototype.parseExpression_za3lpa$ = function (precedence, callback$default) {
    if (precedence === void 0)
      precedence = 0;
    return callback$default ? callback$default(precedence) : this.parseExpression_za3lpa$$default(precedence);
  };
  ParserContext.prototype.parseExpression_u6b096$$default = function ($receiver, precedence) {
    return this.withGrammar_sxynet$(this.grammar).parseExpression_za3lpa$(precedence);
  };
  ParserContext.prototype.parseExpression_u6b096$ = function ($receiver, precedence, callback$default) {
    if (precedence === void 0)
      precedence = 0;
    return callback$default ? callback$default($receiver, precedence) : this.parseExpression_u6b096$$default($receiver, precedence);
  };
  ParserContext.prototype.peek_za3lpa$ = function (distance, callback$default) {
    if (distance === void 0)
      distance = 0;
    return callback$default ? callback$default(distance) : this.peek_za3lpa$$default(distance);
  };
  ParserContext.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ParserContext',
    interfaces: []
  };
  function PrefixParser() {
  }
  PrefixParser.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PrefixParser',
    interfaces: []
  };
  function SyntaxException(message, position) {
    RuntimeException_init(message + ' at ' + position, this);
    this.position = position;
    this.name = 'SyntaxException';
  }
  SyntaxException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SyntaxException',
    interfaces: [RuntimeException]
  };
  function Token(type, value, section) {
    this.type = type;
    this.value = value;
    this.section_t9z7rp$_0 = section;
  }
  Object.defineProperty(Token.prototype, 'section', {
    get: function () {
      return this.section_t9z7rp$_0;
    }
  });
  Token.prototype.toString = function () {
    return this.type.toString() + '[' + this.value + '] ' + this.section;
  };
  Token.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Token',
    interfaces: [Sectional]
  };
  Token.prototype.component1 = function () {
    return this.type;
  };
  Token.prototype.component2 = function () {
    return this.value;
  };
  Token.prototype.component3 = function () {
    return this.section;
  };
  Token.prototype.copy_e3j0u$ = function (type, value, section) {
    return new Token(type === void 0 ? this.type : type, value === void 0 ? this.value : value, section === void 0 ? this.section : section);
  };
  Token.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.section) | 0;
    return result;
  };
  Token.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.section, other.section)))));
  };
  function isLetter($receiver) {
    return (new CharRange(97, 122)).contains_mef7kx$($receiver) || (new CharRange(65, 90)).contains_mef7kx$($receiver);
  }
  function isDigit($receiver) {
    return (new CharRange(48, 57)).contains_mef7kx$($receiver);
  }
  function isLetterOrDigit($receiver) {
    return isLetter($receiver) || isDigit($receiver);
  }
  function section($receiver, offset, length) {
    if (length === void 0)
      length = 0;
    return new Section($receiver.source, $receiver.lineNumber, $receiver.lineIndex - length - offset | 0, length + offset | 0);
  }
  function makeToken($receiver, tokenType, offset) {
    if (offset === void 0)
      offset = 1;
    return makeToken_0($receiver, tokenType, '', offset);
  }
  function makeToken_0($receiver, tokenType, string, offset) {
    if (offset === void 0)
      offset = 0;
    return new Token(tokenType, string, new Section($receiver.source, $receiver.lineNumber, $receiver.lineIndex - string.length - offset | 0, string.length + offset | 0));
  }
  function readIdentifier($receiver, firstChar) {
    if (firstChar === void 0)
      firstChar = null;
    var buf = StringBuilder_init();
    if (firstChar != null) {
      var $receiver_0 = toBoxedChar(firstChar);
      getCallableRef('append', function ($receiver, p1) {
        return $receiver.append_s8itvh$(unboxChar(p1));
      }.bind(null, buf))($receiver_0);
    }while ($receiver.hasNext()) {
      var cc = unboxChar($receiver.peek());
      if (isLetterOrDigit(cc) || cc === 95) {
        buf.append_s8itvh$(cc);
        unboxChar($receiver.next());
      } else {
        break;
      }
    }
    return buf.toString();
  }
  function readString($receiver, delimiter) {
    var buf = StringBuilder_init();
    var eol = false;
    while ($receiver.hasNext()) {
      var c = unboxChar($receiver.peek());
      if (c === delimiter) {
        $receiver.next();
        eol = true;
        break;
      } else {
        $receiver.next();
        buf.append_s8itvh$(c);
      }
    }
    if (!eol) {
      throw IllegalStateException_init('Unterminated string');
    }return buf.toString();
  }
  function readNumber($receiver, c) {
    var tmp$, tmp$_0, tmp$_1;
    var buf = StringBuilder_init();
    if (c === 48) {
      if ($receiver.match_s8itvh$(120)) {
        fillBufferNumbers($receiver, buf, true);
        var isLong = $receiver.match_s8itvh$(108) || $receiver.match_s8itvh$(76);
        var s = buf.toString();
        tmp$ = toIntOrNull(s, 16);
        if (tmp$ == null) {
          return new LexicalNumber$Invalid(buf.toString());
        }var number = tmp$;
        return new LexicalNumber$Integer(s, number, 16, isLong);
      } else if ($receiver.match_s8itvh$(98)) {
        fillBufferNumbers($receiver, buf, false);
        var isLong_0 = $receiver.match_s8itvh$(108) || $receiver.match_s8itvh$(76);
        var s_0 = buf.toString();
        tmp$_0 = toIntOrNull(s_0, 2);
        if (tmp$_0 == null) {
          return new LexicalNumber$Invalid(buf.toString());
        }var number_0 = tmp$_0;
        return new LexicalNumber$Integer(s_0, number_0, 2, isLong_0);
      } else {
        buf.append_s8itvh$(48);
      }
    } else {
      buf.append_s8itvh$(c);
    }
    fillBufferNumbers($receiver, buf, false);
    if (unboxChar($receiver.peek()) === 46 && isDigit(unboxChar($receiver.peek_za3lpa$(1)))) {
      $receiver.next();
      buf.append_s8itvh$(46);
      fillBufferNumbers($receiver, buf, false);
      var isFloat = $receiver.match_s8itvh$(102) || $receiver.match_s8itvh$(70);
      var s_1 = buf.toString();
      tmp$_1 = new LexicalNumber$Decimal(s_1, toDouble(s_1), isFloat);
    } else {
      var s_2 = buf.toString();
      var int = toIntOrNull_0(s_2);
      if (int != null) {
        var isLong_1 = $receiver.match_s8itvh$(108) || $receiver.match_s8itvh$(76);
        tmp$_1 = new LexicalNumber$Integer(s_2, toInt(s_2), 10, isLong_1);
      } else {
        tmp$_1 = new LexicalNumber$Invalid(buf.toString());
      }
    }
    return tmp$_1;
  }
  function LexicalNumber() {
  }
  function LexicalNumber$Invalid(string) {
    LexicalNumber.call(this);
    this.string_fidsft$_0 = string;
  }
  Object.defineProperty(LexicalNumber$Invalid.prototype, 'string', {
    get: function () {
      return this.string_fidsft$_0;
    }
  });
  LexicalNumber$Invalid.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Invalid',
    interfaces: [LexicalNumber]
  };
  LexicalNumber$Invalid.prototype.component1 = function () {
    return this.string;
  };
  LexicalNumber$Invalid.prototype.copy_61zpoe$ = function (string) {
    return new LexicalNumber$Invalid(string === void 0 ? this.string : string);
  };
  LexicalNumber$Invalid.prototype.toString = function () {
    return 'Invalid(string=' + Kotlin.toString(this.string) + ')';
  };
  LexicalNumber$Invalid.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    return result;
  };
  LexicalNumber$Invalid.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.string, other.string))));
  };
  function LexicalNumber$Decimal(string, value, isFloat) {
    if (isFloat === void 0)
      isFloat = false;
    LexicalNumber.call(this);
    this.string_el7cip$_0 = string;
    this.value = value;
    this.isFloat = isFloat;
  }
  Object.defineProperty(LexicalNumber$Decimal.prototype, 'string', {
    get: function () {
      return this.string_el7cip$_0;
    }
  });
  LexicalNumber$Decimal.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Decimal',
    interfaces: [LexicalNumber]
  };
  LexicalNumber$Decimal.prototype.component1 = function () {
    return this.string;
  };
  LexicalNumber$Decimal.prototype.component2 = function () {
    return this.value;
  };
  LexicalNumber$Decimal.prototype.component3 = function () {
    return this.isFloat;
  };
  LexicalNumber$Decimal.prototype.copy_1truf$ = function (string, value, isFloat) {
    return new LexicalNumber$Decimal(string === void 0 ? this.string : string, value === void 0 ? this.value : value, isFloat === void 0 ? this.isFloat : isFloat);
  };
  LexicalNumber$Decimal.prototype.toString = function () {
    return 'Decimal(string=' + Kotlin.toString(this.string) + (', value=' + Kotlin.toString(this.value)) + (', isFloat=' + Kotlin.toString(this.isFloat)) + ')';
  };
  LexicalNumber$Decimal.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.isFloat) | 0;
    return result;
  };
  LexicalNumber$Decimal.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.string, other.string) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.isFloat, other.isFloat)))));
  };
  function LexicalNumber$Integer(string, value, radix, isLong) {
    if (radix === void 0)
      radix = 10;
    if (isLong === void 0)
      isLong = false;
    LexicalNumber.call(this);
    this.string_tykk5q$_0 = string;
    this.value = value;
    this.radix = radix;
    this.isLong = isLong;
  }
  Object.defineProperty(LexicalNumber$Integer.prototype, 'string', {
    get: function () {
      return this.string_tykk5q$_0;
    }
  });
  LexicalNumber$Integer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Integer',
    interfaces: [LexicalNumber]
  };
  LexicalNumber$Integer.prototype.component1 = function () {
    return this.string;
  };
  LexicalNumber$Integer.prototype.component2 = function () {
    return this.value;
  };
  LexicalNumber$Integer.prototype.component3 = function () {
    return this.radix;
  };
  LexicalNumber$Integer.prototype.component4 = function () {
    return this.isLong;
  };
  LexicalNumber$Integer.prototype.copy_yib5kn$ = function (string, value, radix, isLong) {
    return new LexicalNumber$Integer(string === void 0 ? this.string : string, value === void 0 ? this.value : value, radix === void 0 ? this.radix : radix, isLong === void 0 ? this.isLong : isLong);
  };
  LexicalNumber$Integer.prototype.toString = function () {
    return 'Integer(string=' + Kotlin.toString(this.string) + (', value=' + Kotlin.toString(this.value)) + (', radix=' + Kotlin.toString(this.radix)) + (', isLong=' + Kotlin.toString(this.isLong)) + ')';
  };
  LexicalNumber$Integer.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.radix) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLong) | 0;
    return result;
  };
  LexicalNumber$Integer.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.string, other.string) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.radix, other.radix) && Kotlin.equals(this.isLong, other.isLong)))));
  };
  LexicalNumber.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexicalNumber',
    interfaces: []
  };
  function fillBufferNumbers($receiver, buf, allowHex) {
    while ($receiver.hasNext()) {
      var c = unboxChar($receiver.peek());
      if (isDigit(c) || (allowHex && (new CharRange(65, 70)).contains_mef7kx$(c) || (new CharRange(97, 102)).contains_mef7kx$(c))) {
        buf.append_s8itvh$(unboxChar($receiver.next()));
      } else {
        break;
      }
    }
  }
  function ensureEOF($receiver, block) {
    try {
      return block();
    }finally {
      if (!$receiver.eof)
        throw new SyntaxException("Should've reached end of content", $receiver.eat().section);
    }
  }
  function eatMulti($receiver, types) {
    var transform = getCallableRef('eat', function ($receiver, p1) {
      return $receiver.eat_11rb$(p1);
    }.bind(null, $receiver));
    var destination = ArrayList_init_0(types.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== types.length; ++tmp$) {
      var item = types[tmp$];
      destination.add_11rb$(transform(item));
    }
    return destination;
  }
  function GrammarBuilder() {
    this.prefixParsers_0 = LinkedHashMap_init();
    this.infixParsers_0 = LinkedHashMap_init();
  }
  GrammarBuilder.prototype.import_ha5jj$$default = function (override, grammars) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== grammars.length; ++tmp$) {
      var element = grammars[tmp$];
      var tmp$_0;
      tmp$_0 = element.prefixParsers.entries.iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        var k = element_0.key;
        var v = element_0.value;
        this.prefix_bb9afj$(k, v, override);
      }
      var tmp$_1;
      tmp$_1 = element.infixParsers.entries.iterator();
      while (tmp$_1.hasNext()) {
        var element_1 = tmp$_1.next();
        var k_0 = element_1.key;
        var v_0 = element_1.value;
        this.infix_wdcr7z$(k_0, v_0, override);
      }
    }
  };
  GrammarBuilder.prototype.prefix_bb9afj$$default = function (type, parselet, override) {
    var tmp$ = !override;
    if (tmp$) {
      var $receiver = this.prefixParsers_0;
      var tmp$_0;
      tmp$ = (Kotlin.isType(tmp$_0 = $receiver, Map) ? tmp$_0 : throwCCE()).containsKey_11rb$(type);
    }if (tmp$) {
      throw IllegalArgumentException_init('Prefix parselet associated with ' + type + ' already exists. Did you forget to enable overriding?');
    }this.prefixParsers_0.put_xwzc9p$(type, parselet);
  };
  GrammarBuilder.prototype.prefix_ggj8ix$$default = function (type, override, block) {
    this.prefix_bb9afj$(type, new PrefixParserImpl(block));
  };
  GrammarBuilder.prototype.infix_wdcr7z$$default = function (type, parselet, override) {
    var tmp$ = !override;
    if (tmp$) {
      var $receiver = this.infixParsers_0;
      var tmp$_0;
      tmp$ = (Kotlin.isType(tmp$_0 = $receiver, Map) ? tmp$_0 : throwCCE()).containsKey_11rb$(type);
    }if (tmp$) {
      throw IllegalArgumentException_init('Infix parselet associated with ' + type + ' already exists. Did you forget to enable overriding?');
    }this.infixParsers_0.put_xwzc9p$(type, parselet);
  };
  GrammarBuilder.prototype.infix_lfjh7$$default = function (type, precedence, override, block) {
    this.infix_wdcr7z$(type, new InfixParserImpl(precedence, block));
  };
  GrammarBuilder.prototype.build = function () {
    return new Grammar(toMap(this.prefixParsers_0), toMap(this.infixParsers_0));
  };
  GrammarBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrammarBuilder',
    interfaces: [GrammarDSL]
  };
  function InfixParserImpl(precedence, block) {
    this.precedence_r4qar1$_0 = precedence;
    this.block_0 = block;
  }
  Object.defineProperty(InfixParserImpl.prototype, 'precedence', {
    get: function () {
      return this.precedence_r4qar1$_0;
    }
  });
  InfixParserImpl.prototype.parse_eufodf$ = function (ctx, left, token) {
    return this.block_0(ctx, left, token);
  };
  InfixParserImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InfixParserImpl',
    interfaces: [InfixParser]
  };
  function LexerImpl(root) {
    this.matcher_0 = LexerImpl$LexerImpl$LexerMatcher_init(root);
  }
  LexerImpl.prototype.parse_mi27kl$ = function (source, output) {
    var ctx = new LexerImpl$ContextImpl(this, source, output);
    while (ctx.hasNext()) {
      ctx.read = 0;
      var function_0 = this.doMatch_0(this.matcher_0, ctx).onMatch;
      if (function_0 != null) {
        function_0(ctx, ctx.curr);
      } else {
        this.skipUntilMatch_0(this.matcher_0, ctx);
        var section_0 = section(ctx, ctx.read);
        throw new SyntaxException("No matcher registered for '" + section_0.substring + "'", section_0);
      }
      if (ctx.read === 0) {
        throw IllegalStateException_init('No further characters consumed.');
      }}
  };
  function LexerImpl$LexerMatcher(trie, predicates, onMatch) {
    this.trie = trie;
    this.predicates = predicates;
    this.onMatch = onMatch;
  }
  LexerImpl$LexerMatcher.prototype.tryMatchChild_s8itvh$ = function (char) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$_0 = this.trie.get_11rb$(toBoxedChar(char))) != null)
      tmp$_1 = tmp$_0;
    else {
      var $receiver = this.predicates;
      var firstOrNull$result;
      firstOrNull$break: do {
        var tmp$_2;
        tmp$_2 = $receiver.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          if (element.first(toBoxedChar(char))) {
            firstOrNull$result = element;
            break firstOrNull$break;
          }}
        firstOrNull$result = null;
      }
       while (false);
      tmp$_1 = (tmp$ = firstOrNull$result) != null ? tmp$.second : null;
    }
    return tmp$_1;
  };
  LexerImpl$LexerMatcher.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexerMatcher',
    interfaces: []
  };
  function LexerImpl$LexerImpl$LexerMatcher_init(m, $this) {
    $this = $this || Object.create(LexerImpl$LexerMatcher.prototype);
    var $receiver = m.trie;
    var destination = LinkedHashMap_init();
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (!element.value.isEmpty()) {
        destination.put_xwzc9p$(element.key, element.value);
      }}
    var destination_0 = LinkedHashMap_init_0(mapCapacity(destination.size));
    var tmp$_0;
    tmp$_0 = destination.entries.iterator();
    while (tmp$_0.hasNext()) {
      var element_0 = tmp$_0.next();
      destination_0.put_xwzc9p$(element_0.key, LexerImpl$LexerImpl$LexerMatcher_init(element_0.value));
    }
    var $receiver_0 = m.predicates;
    var destination_1 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var element_1 = tmp$_1.next();
      if (!element_1.second.isEmpty())
        destination_1.add_11rb$(element_1);
    }
    var destination_2 = ArrayList_init_0(collectionSizeOrDefault(destination_1, 10));
    var tmp$_2;
    tmp$_2 = destination_1.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      destination_2.add_11rb$(to(item.first, LexerImpl$LexerImpl$LexerMatcher_init(item.second)));
    }
    LexerImpl$LexerMatcher.call($this, destination_0, destination_2, m.onMatch);
    return $this;
  }
  LexerImpl$LexerMatcher.prototype.component1 = function () {
    return this.trie;
  };
  LexerImpl$LexerMatcher.prototype.component2 = function () {
    return this.predicates;
  };
  LexerImpl$LexerMatcher.prototype.component3 = function () {
    return this.onMatch;
  };
  LexerImpl$LexerMatcher.prototype.copy_h01eeh$ = function (trie, predicates, onMatch) {
    return new LexerImpl$LexerMatcher(trie === void 0 ? this.trie : trie, predicates === void 0 ? this.predicates : predicates, onMatch === void 0 ? this.onMatch : onMatch);
  };
  LexerImpl$LexerMatcher.prototype.toString = function () {
    return 'LexerMatcher(trie=' + Kotlin.toString(this.trie) + (', predicates=' + Kotlin.toString(this.predicates)) + (', onMatch=' + Kotlin.toString(this.onMatch)) + ')';
  };
  LexerImpl$LexerMatcher.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.trie) | 0;
    result = result * 31 + Kotlin.hashCode(this.predicates) | 0;
    result = result * 31 + Kotlin.hashCode(this.onMatch) | 0;
    return result;
  };
  LexerImpl$LexerMatcher.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.trie, other.trie) && Kotlin.equals(this.predicates, other.predicates) && Kotlin.equals(this.onMatch, other.onMatch)))));
  };
  LexerImpl.prototype.skipUntilMatch_0 = function ($receiver, ctx) {
    if (!ctx.hasNext())
      return;
    var char = unboxChar(ctx.peek());
    if ($receiver.tryMatchChild_s8itvh$(char) != null || char === 10)
      return;
    ctx.next();
    this.skipUntilMatch_0($receiver, ctx);
  };
  LexerImpl.prototype.doMatch_0 = function ($receiver, ctx, eat) {
    if (eat === void 0)
      eat = false;
    var tmp$;
    if (eat)
      ctx.next();
    tmp$ = $receiver.tryMatchChild_s8itvh$(unboxChar(ctx.peek()));
    if (tmp$ == null) {
      return $receiver;
    }return this.doMatch_0(tmp$, ctx, true);
  };
  function LexerImpl$ContextImpl($outer, source, output) {
    this.$outer = $outer;
    this.source_29hdz4$_0 = source;
    this.output_0 = output;
    this.reader_lzko14$_0 = new StringReader(this.source.content);
    this.read = 0;
    this.lineNumber_ux4mta$_0 = 1;
    this.lineIndex_an9vmt$_0 = 0;
    this.curr = toBoxedChar(toChar(-1));
  }
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'source', {
    get: function () {
      return this.source_29hdz4$_0;
    }
  });
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'reader', {
    configurable: true,
    get: function () {
      return this.reader_lzko14$_0;
    }
  });
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'lineNumber', {
    configurable: true,
    get: function () {
      return this.lineNumber_ux4mta$_0;
    },
    set: function (lineNumber) {
      this.lineNumber_ux4mta$_0 = lineNumber;
    }
  });
  Object.defineProperty(LexerImpl$ContextImpl.prototype, 'lineIndex', {
    configurable: true,
    get: function () {
      return this.lineIndex_an9vmt$_0;
    },
    set: function (lineIndex) {
      this.lineIndex_an9vmt$_0 = lineIndex;
    }
  });
  LexerImpl$ContextImpl.prototype.peek = function () {
    this.reader.mark_za3lpa$(1);
    var c = toChar(this.reader.read());
    this.reader.reset();
    return toBoxedChar(c);
  };
  function LexerImpl$ContextImpl$peek$lambda(this$ContextImpl) {
    return function () {
      var tmp$;
      var $receiver = this$ContextImpl.reader.read();
      return toBoxedChar((tmp$ = !($receiver === -1) ? $receiver : null) != null ? toChar(tmp$) : null);
    };
  }
  LexerImpl$ContextImpl.prototype.peek_za3lpa$ = function (distance) {
    var tmp$;
    this.reader.mark_za3lpa$(distance + 1 | 0);
    var chars = toList(take(generateSequence(LexerImpl$ContextImpl$peek$lambda(this)), distance + 1 | 0));
    if (chars.size < (distance + 1 | 0))
      tmp$ = toChar(-1);
    else
      tmp$ = unboxChar(chars.get_za3lpa$(distance));
    var result = tmp$;
    this.reader.reset();
    return toBoxedChar(result);
  };
  function LexerImpl$ContextImpl$peekString$lambda(this$ContextImpl) {
    return function () {
      var tmp$;
      var $receiver = this$ContextImpl.reader.read();
      return toBoxedChar((tmp$ = !($receiver === -1) ? $receiver : null) != null ? toChar(tmp$) : null);
    };
  }
  LexerImpl$ContextImpl.prototype.peekString_za3lpa$ = function (length) {
    this.reader.mark_za3lpa$(length);
    var $receiver = take(generateSequence(LexerImpl$ContextImpl$peekString$lambda(this)), length);
    var tmp$;
    var accumulator = StringBuilder_init();
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      accumulator = accumulator.append_s8itvh$(unboxChar(element));
    }
    var value = accumulator.toString();
    this.reader.reset();
    return value;
  };
  LexerImpl$ContextImpl.prototype.match_s8itvh$ = function (expect) {
    var tmp$;
    if (unboxChar(this.peek()) === expect) {
      this.next();
      tmp$ = true;
    } else {
      tmp$ = false;
    }
    return tmp$;
  };
  LexerImpl$ContextImpl.prototype.hasNext = function () {
    this.reader.mark_za3lpa$(1);
    var i = this.reader.read();
    this.reader.reset();
    return i > 0;
  };
  LexerImpl$ContextImpl.prototype.next = function () {
    this.read = this.read + 1 | 0;
    var c = toChar(this.reader.read());
    if (c === 10) {
      this.lineNumber = this.lineNumber + 1 | 0;
      this.lineIndex = 0;
    } else {
      this.lineIndex = this.lineIndex + 1 | 0;
    }
    this.curr = toBoxedChar(c);
    return toBoxedChar(c);
  };
  LexerImpl$ContextImpl.prototype.nextString_za3lpa$ = function (length) {
    var tmp$;
    var buf = StringBuilder_init_0(length);
    var i = 0;
    while (this.hasNext() && (tmp$ = i, i = tmp$ + 1 | 0, tmp$) < length) {
      buf.append_s8itvh$(unboxChar(this.next()));
    }
    return buf.toString();
  };
  LexerImpl$ContextImpl.prototype.process_11rb$ = function (token) {
    this.output_0(token);
  };
  LexerImpl$ContextImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ContextImpl',
    interfaces: [LexerContext]
  };
  LexerImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LexerImpl',
    interfaces: [Lexer]
  };
  function MatcherImpl() {
    this.trie = LinkedHashMap_init();
    this.predicates = ArrayList_init();
    this.onMatch = null;
  }
  MatcherImpl.prototype.isEmpty = function () {
    return this.trie.isEmpty() && this.predicates.isEmpty() && this.onMatch == null;
  };
  MatcherImpl.prototype.matching_61zpoe$ = function (string) {
    var tmp$;
    switch (string.length) {
      case 0:
        tmp$ = this;
        break;
      case 1:
        tmp$ = this.matching_s8itvh$(first(string));
        break;
      default:var $receiver = string.substring(1);
        var tmp$_0;
        var accumulator = this.matching_s8itvh$(first(string));
        tmp$_0 = iterator($receiver);
        while (tmp$_0.hasNext()) {
          var element = unboxChar(tmp$_0.next());
          accumulator = accumulator.matching_s8itvh$(unboxChar(toBoxedChar(element)));
        }

        tmp$ = accumulator;
        break;
    }
    return tmp$;
  };
  MatcherImpl.prototype.matching_s8itvh$ = function (char) {
    var $receiver = this.trie;
    var key = toBoxedChar(char);
    var tmp$;
    var value = $receiver.get_11rb$(key);
    if (value == null) {
      var answer = new MatcherImpl();
      $receiver.put_xwzc9p$(key, answer);
      tmp$ = answer;
    } else {
      tmp$ = value;
    }
    return tmp$;
  };
  MatcherImpl.prototype.matching_akknk2$ = function (block) {
    var m = new MatcherImpl();
    this.predicates.add_11rb$(to(block, m));
    return m;
  };
  MatcherImpl.prototype.configure_t5ujie$ = function (block) {
    this.onMatch = block;
  };
  MatcherImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MatcherImpl',
    interfaces: [LexerDSL]
  };
  function ParserImpl(grammar, block) {
    this.grammar_oashss$_0 = grammar;
    this.block_0 = block;
  }
  Object.defineProperty(ParserImpl.prototype, 'grammar', {
    get: function () {
      return this.grammar_oashss$_0;
    }
  });
  ParserImpl.prototype.parse_7y97bu$ = function (tokens) {
    return this.block_0(new ParserImpl$ContextImpl(this, tokens, this.grammar));
  };
  function ParserImpl$ContextImpl($outer, source, grammar) {
    this.$outer = $outer;
    this.grammar_5atiqr$_0 = grammar;
    this.tokens_0 = toMutableList(source);
    this.index_dle8x4$_0 = 0;
  }
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'grammar', {
    get: function () {
      return this.grammar_5atiqr$_0;
    }
  });
  function ParserImpl$ContextImpl$ChildContextImpl($outer, grammar) {
    this.$outer = $outer;
    this.grammar_mwoigy$_0 = grammar;
    this.$delegate_uplf99$_0 = this.$outer;
  }
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'grammar', {
    get: function () {
      return this.grammar_mwoigy$_0;
    }
  });
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_za3lpa$$default = function (precedence) {
    return this.$outer.parseExpr_1328uj$(this.grammar, precedence);
  };
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'eof', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.eof;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'index', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.index;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl$ChildContextImpl.prototype, 'last', {
    configurable: true,
    get: function () {
      return this.$delegate_uplf99$_0.last;
    }
  });
  ParserImpl$ContextImpl$ChildContextImpl.prototype.back = function () {
    return this.$delegate_uplf99$_0.back();
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.eat = function () {
    return this.$delegate_uplf99$_0.eat();
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.eat_11rb$ = function (type) {
    return this.$delegate_uplf99$_0.eat_11rb$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.match_11rb$ = function (type) {
    return this.$delegate_uplf99$_0.match_11rb$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.matchAny_7l2mas$ = function (type) {
    return this.$delegate_uplf99$_0.matchAny_7l2mas$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.nextIs_11rb$ = function (type) {
    return this.$delegate_uplf99$_0.nextIs_11rb$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.nextIsAny_7l2mas$ = function (types) {
    return this.$delegate_uplf99$_0.nextIsAny_7l2mas$(types);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.peek_za3lpa$$default = function (distance) {
    return this.$delegate_uplf99$_0.peek_za3lpa$$default(distance);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.peekAheadUntil_7l2mas$ = function (type) {
    return this.$delegate_uplf99$_0.peekAheadUntil_7l2mas$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.skipUntil_7l2mas$ = function (type) {
    return this.$delegate_uplf99$_0.skipUntil_7l2mas$(type);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.withGrammar_sxynet$ = function (grammar) {
    return this.$delegate_uplf99$_0.withGrammar_sxynet$(grammar);
  };
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_u6b096$$default = function ($receiver, precedence) {
    return this.$delegate_uplf99$_0.parseExpression_u6b096$$default($receiver, precedence);
  };
  ParserImpl$ContextImpl$ChildContextImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChildContextImpl',
    interfaces: [ParserContext]
  };
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'index', {
    configurable: true,
    get: function () {
      return this.index_dle8x4$_0;
    },
    set: function (index) {
      this.index_dle8x4$_0 = index;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'eof', {
    configurable: true,
    get: function () {
      return this.index === this.tokens_0.size;
    }
  });
  Object.defineProperty(ParserImpl$ContextImpl.prototype, 'last', {
    configurable: true,
    get: function () {
      return this.tokens_0.get_za3lpa$(this.index - 1 | 0);
    }
  });
  ParserImpl$ContextImpl.prototype.withGrammar_sxynet$ = function (grammar) {
    return new ParserImpl$ContextImpl$ChildContextImpl(this, grammar);
  };
  ParserImpl$ContextImpl.prototype.parseExpression_za3lpa$$default = function (precedence) {
    return this.parseExpr_1328uj$(this.grammar, precedence);
  };
  ParserImpl$ContextImpl.prototype.eat = function () {
    var tmp$;
    if (this.eof)
      throw new SyntaxException('Expected token but reached end of file', this.last.section);
    return this.tokens_0.get_za3lpa$((tmp$ = this.index, this.index = tmp$ + 1 | 0, tmp$));
  };
  ParserImpl$ContextImpl.prototype.eat_11rb$ = function (type) {
    if (this.eof)
      throw new SyntaxException('Expected ' + type + ' but reached end of file', this.last.section);
    var token = this.peek_za3lpa$();
    if (!equals(token.type, type)) {
      throw new SyntaxException("Expected '" + type + "' but found '" + token.type + "'.", token.section);
    }return this.eat();
  };
  ParserImpl$ContextImpl.prototype.match_11rb$ = function (type) {
    var tmp$;
    if (this.nextIs_11rb$(type)) {
      this.eat();
      tmp$ = true;
    } else {
      tmp$ = false;
    }
    return tmp$;
  };
  ParserImpl$ContextImpl.prototype.matchAny_7l2mas$ = function (type) {
    var tmp$;
    if (this.nextIsAny_7l2mas$(type.slice())) {
      this.eat();
      tmp$ = true;
    } else {
      tmp$ = false;
    }
    return tmp$;
  };
  ParserImpl$ContextImpl.prototype.back = function () {
    return this.tokens_0.get_za3lpa$((this.index = this.index - 1 | 0, this.index));
  };
  ParserImpl$ContextImpl.prototype.peek_za3lpa$$default = function (distance) {
    return this.tokens_0.get_za3lpa$(this.index + distance | 0);
  };
  ParserImpl$ContextImpl.prototype.nextIs_11rb$ = function (type) {
    return !this.eof && equals(this.peek_za3lpa$().type, type);
  };
  ParserImpl$ContextImpl.prototype.nextIsAny_7l2mas$ = function (types) {
    var tmp$ = !this.eof;
    if (tmp$) {
      var any$result;
      any$break: do {
        var tmp$_0;
        for (tmp$_0 = 0; tmp$_0 !== types.length; ++tmp$_0) {
          var element = types[tmp$_0];
          if (this.nextIs_11rb$(element)) {
            any$result = true;
            break any$break;
          }}
        any$result = false;
      }
       while (false);
      tmp$ = any$result;
    }return tmp$;
  };
  ParserImpl$ContextImpl.prototype.peekAheadUntil_7l2mas$ = function (type) {
    if (this.eof)
      return emptyList();
    var list = ArrayList_init();
    var distance = 0;
    while (!this.eof && !this.nextIsAny_7l2mas$(type.slice())) {
      var tmp$;
      var element = this.peek_za3lpa$((tmp$ = distance, distance = tmp$ + 1 | 0, tmp$));
      list.add_11rb$(element);
    }
    return list;
  };
  ParserImpl$ContextImpl.prototype.skipUntil_7l2mas$ = function (type) {
    while (!this.eof && !this.nextIsAny_7l2mas$(type.slice())) {
      this.eat();
    }
  };
  ParserImpl$ContextImpl.prototype.parseExpr_1328uj$ = function (grammar, precedence) {
    var tmp$, tmp$_0;
    var it = this.eat();
    var tmp$_1, tmp$_2;
    tmp$_2 = (tmp$_1 = grammar.prefixParsers.get_11rb$(it.type)) != null ? tmp$_1.parse_6srjs1$(this, it) : null;
    if (tmp$_2 == null) {
      throw new SyntaxException('Unexpected ' + it, it.section);
    }var left = {v: tmp$_2};
    while (!this.eof && precedence < ((tmp$_0 = (tmp$ = this.grammar.infixParsers.get_11rb$(this.peek_za3lpa$(0).type)) != null ? tmp$.precedence : null) != null ? tmp$_0 : 0)) {
      var it_0 = this.eat();
      var tmp$_3, tmp$_4;
      tmp$_4 = (tmp$_3 = grammar.infixParsers.get_11rb$(it_0.type)) != null ? tmp$_3.parse_eufodf$(this, left.v, it_0) : null;
      if (tmp$_4 == null) {
        throw new SyntaxException('Unexpected ' + it_0, it_0.section);
      }left.v = tmp$_4;
    }
    return left.v;
  };
  ParserImpl$ContextImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ContextImpl',
    interfaces: [ParserContext]
  };
  ParserImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParserImpl',
    interfaces: [Parser]
  };
  function PrefixParserImpl(block) {
    this.block_0 = block;
  }
  PrefixParserImpl.prototype.parse_6srjs1$ = function (parser, token) {
    return this.block_0(parser, token);
  };
  PrefixParserImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PrefixParserImpl',
    interfaces: [PrefixParser]
  };
  function StringReader(s) {
    this.str_0 = s;
    this.length_0 = s.length;
    this.next_0 = 0;
    this.mark_0 = 0;
  }
  StringReader.prototype.read = function () {
    var tmp$, tmp$_0;
    if (this.next_0 >= this.length_0)
      tmp$_0 = -1;
    else {
      tmp$_0 = this.str_0.charCodeAt((tmp$ = this.next_0, this.next_0 = tmp$ + 1 | 0, tmp$)) | 0;
    }
    return tmp$_0;
  };
  StringReader.prototype.skip_s8cxhz$ = function (chars) {
    if (this.next_0 >= this.length_0)
      return L0;
    var a = Kotlin.Long.fromInt(this.length_0).subtract(Kotlin.Long.fromInt(this.next_0));
    var n = a.compareTo_11rb$(chars) <= 0 ? a : chars;
    var a_0 = Kotlin.Long.fromInt(this.next_0).unaryMinus();
    var b = n;
    n = a_0.compareTo_11rb$(b) >= 0 ? a_0 : b;
    this.next_0 = this.next_0 + n.toInt() | 0;
    return n;
  };
  StringReader.prototype.mark_za3lpa$ = function (readAheadLimit) {
    if (!(readAheadLimit >= 0)) {
      var message = 'Read-ahead limit < 0';
      throw IllegalArgumentException_init(message.toString());
    }this.mark_0 = this.next_0;
  };
  StringReader.prototype.reset = function () {
    this.next_0 = this.mark_0;
  };
  StringReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StringReader',
    interfaces: []
  };
  var package$com = _.com || (_.com = {});
  var package$github = package$com.github || (package$com.github = {});
  var package$adriantodt = package$github.adriantodt || (package$github.adriantodt = {});
  var package$tartar = package$adriantodt.tartar || (package$adriantodt.tartar = {});
  package$tartar.createLexer_ct8p1u$ = createLexer;
  package$tartar.createGrammar_dz9vxv$ = createGrammar;
  package$tartar.createParser_lh2cvq$ = createParser;
  var package$api = package$tartar.api || (package$tartar.api = {});
  package$api.GrammarDSL = GrammarDSL;
  package$api.LexerDSL = LexerDSL;
  var package$lexer = package$api.lexer || (package$api.lexer = {});
  package$lexer.Lexer = Lexer;
  package$lexer.LexerContext = LexerContext;
  package$lexer.Section = Section;
  package$lexer.Sectional = Sectional;
  package$lexer.Source = Source;
  var package$parser = package$api.parser || (package$api.parser = {});
  package$parser.Grammar = Grammar;
  package$parser.InfixParser = InfixParser;
  package$parser.Parser = Parser;
  package$parser.ParserContext = ParserContext;
  package$parser.PrefixParser = PrefixParser;
  package$parser.SyntaxException = SyntaxException;
  package$parser.Token = Token;
  var package$extensions = package$tartar.extensions || (package$tartar.extensions = {});
  package$extensions.isLetter_myv2d0$ = isLetter;
  package$extensions.isDigit_myv2d0$ = isDigit;
  package$extensions.isLetterOrDigit_myv2d0$ = isLetterOrDigit;
  package$extensions.section_crcbr0$ = section;
  package$extensions.makeToken_vz4fks$ = makeToken;
  package$extensions.makeToken_o70ryi$ = makeToken_0;
  package$extensions.readIdentifier_t5y1tw$ = readIdentifier;
  package$extensions.readString_ct20bp$ = readString;
  package$extensions.readNumber_ct20bp$ = readNumber;
  LexicalNumber.Invalid = LexicalNumber$Invalid;
  LexicalNumber.Decimal = LexicalNumber$Decimal;
  LexicalNumber.Integer = LexicalNumber$Integer;
  package$extensions.LexicalNumber = LexicalNumber;
  package$extensions.ensureEOF_p3mmbm$ = ensureEOF;
  package$extensions.eatMulti_fzf39z$ = eatMulti;
  var package$impl = package$tartar.impl || (package$tartar.impl = {});
  package$impl.GrammarBuilder = GrammarBuilder;
  package$impl.InfixParserImpl = InfixParserImpl;
  LexerImpl.LexerMatcher_init_8zkqve$ = LexerImpl$LexerImpl$LexerMatcher_init;
  LexerImpl.LexerMatcher = LexerImpl$LexerMatcher;
  LexerImpl.ContextImpl = LexerImpl$ContextImpl;
  package$impl.LexerImpl = LexerImpl;
  package$impl.MatcherImpl = MatcherImpl;
  ParserImpl$ContextImpl.ChildContextImpl = ParserImpl$ContextImpl$ChildContextImpl;
  ParserImpl.ContextImpl = ParserImpl$ContextImpl;
  package$impl.ParserImpl = ParserImpl;
  package$impl.PrefixParserImpl = PrefixParserImpl;
  package$lexer.StringReader = StringReader;
  Token.prototype.span_p684zu$ = Sectional.prototype.span_p684zu$;
  GrammarBuilder.prototype.import_ha5jj$ = GrammarDSL.prototype.import_ha5jj$;
  GrammarBuilder.prototype.prefix_bb9afj$ = GrammarDSL.prototype.prefix_bb9afj$;
  GrammarBuilder.prototype.prefix_ggj8ix$ = GrammarDSL.prototype.prefix_ggj8ix$;
  GrammarBuilder.prototype.infix_wdcr7z$ = GrammarDSL.prototype.infix_wdcr7z$;
  GrammarBuilder.prototype.infix_lfjh7$ = GrammarDSL.prototype.infix_lfjh7$;
  LexerImpl.prototype.parseTo_32dq1j$ = Lexer.prototype.parseTo_32dq1j$;
  LexerImpl.prototype.parseToList_llobtt$ = Lexer.prototype.parseToList_llobtt$;
  MatcherImpl.prototype.matching_6ils5n$ = LexerDSL.prototype.matching_6ils5n$;
  MatcherImpl.prototype.matching_uoi7m8$ = LexerDSL.prototype.matching_uoi7m8$;
  MatcherImpl.prototype.invoke_sdqmiu$$default = LexerDSL.prototype.invoke_sdqmiu$$default;
  MatcherImpl.prototype.invoke_vp8vqt$$default = LexerDSL.prototype.invoke_vp8vqt$$default;
  MatcherImpl.prototype.invoke_sdqmiu$ = LexerDSL.prototype.invoke_sdqmiu$;
  MatcherImpl.prototype.invoke_vp8vqt$ = LexerDSL.prototype.invoke_vp8vqt$;
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_za3lpa$ = ParserContext.prototype.parseExpression_za3lpa$;
  ParserImpl$ContextImpl$ChildContextImpl.prototype.parseExpression_u6b096$ = ParserContext.prototype.parseExpression_u6b096$;
  ParserImpl$ContextImpl$ChildContextImpl.prototype.peek_za3lpa$ = ParserContext.prototype.peek_za3lpa$;
  ParserImpl$ContextImpl.prototype.parseExpression_u6b096$$default = ParserContext.prototype.parseExpression_u6b096$$default;
  ParserImpl$ContextImpl.prototype.parseExpression_za3lpa$ = ParserContext.prototype.parseExpression_za3lpa$;
  ParserImpl$ContextImpl.prototype.parseExpression_u6b096$ = ParserContext.prototype.parseExpression_u6b096$;
  ParserImpl$ContextImpl.prototype.peek_za3lpa$ = ParserContext.prototype.peek_za3lpa$;
  ParserImpl.prototype.parse_r7b30y$ = Parser.prototype.parse_r7b30y$;
  Kotlin.defineModule('tartar-js-legacy', _);
  return _;
}));

//# sourceMappingURL=tartar-js-legacy.js.map
