/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm.types;

import com.github.adriantodt.lin.vm.types.LAny;
import com.github.adriantodt.lin.vm.types.LDecimal;
import com.github.adriantodt.lin.vm.types.LNumber;
import com.github.adriantodt.lin.vm.types.LRange;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\t\u0010\u0018\u001a\u00020\fH\u00d6\u0001J\u0011\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\t\u0010 \u001a\u00020\u0001H\u0096\u0002J\t\u0010!\u001a\u00020\u0001H\u0096\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/github/adriantodt/lin/vm/types/LInteger;", "Lcom/github/adriantodt/lin/vm/types/LNumber;", "value", "", "(J)V", "linType", "", "getLinType", "()Ljava/lang/String;", "getValue", "()J", "compareTo", "", "other", "component1", "copy", "div", "right", "equals", "", "", "getMember", "Lcom/github/adriantodt/lin/vm/types/LAny;", "name", "hashCode", "minus", "plus", "rangeTo", "rem", "times", "toString", "truth", "unaryMinus", "unaryPlus", "lin"})
public final class LInteger
extends LNumber {
    private final long value;

    public LInteger(long value2) {
        super(null);
        this.value = value2;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull LNumber other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LNumber lNumber = other;
        if (lNumber instanceof LDecimal) {
            n = Double.compare(this.value, ((LDecimal)other).getValue());
        } else if (lNumber instanceof LInteger) {
            n = Intrinsics.compare((long)this.value, (long)((LInteger)other).value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @Override
    @NotNull
    public LNumber plus(@NotNull LNumber right2) {
        LNumber lNumber;
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        LNumber lNumber2 = right2;
        if (lNumber2 instanceof LDecimal) {
            lNumber = new LDecimal((double)this.value + ((LDecimal)right2).getValue());
        } else if (lNumber2 instanceof LInteger) {
            lNumber = new LInteger(this.value + ((LInteger)right2).value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lNumber;
    }

    @Override
    @NotNull
    public LNumber minus(@NotNull LNumber right2) {
        LNumber lNumber;
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        LNumber lNumber2 = right2;
        if (lNumber2 instanceof LDecimal) {
            lNumber = new LDecimal((double)this.value - ((LDecimal)right2).getValue());
        } else if (lNumber2 instanceof LInteger) {
            lNumber = new LInteger(this.value - ((LInteger)right2).value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lNumber;
    }

    @Override
    @NotNull
    public LNumber times(@NotNull LNumber right2) {
        LNumber lNumber;
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        LNumber lNumber2 = right2;
        if (lNumber2 instanceof LDecimal) {
            lNumber = new LDecimal((double)this.value * ((LDecimal)right2).getValue());
        } else if (lNumber2 instanceof LInteger) {
            lNumber = new LInteger(this.value * ((LInteger)right2).value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lNumber;
    }

    @Override
    @NotNull
    public LNumber div(@NotNull LNumber right2) {
        LNumber lNumber;
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        LNumber lNumber2 = right2;
        if (lNumber2 instanceof LDecimal) {
            lNumber = new LDecimal((double)this.value / ((LDecimal)right2).getValue());
        } else if (lNumber2 instanceof LInteger) {
            lNumber = new LInteger(this.value / ((LInteger)right2).value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lNumber;
    }

    @Override
    @NotNull
    public LNumber rem(@NotNull LNumber right2) {
        LNumber lNumber;
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        LNumber lNumber2 = right2;
        if (lNumber2 instanceof LDecimal) {
            lNumber = new LDecimal((double)this.value % ((LDecimal)right2).getValue());
        } else if (lNumber2 instanceof LInteger) {
            lNumber = new LInteger(this.value % ((LInteger)right2).value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lNumber;
    }

    @Override
    @NotNull
    public LNumber unaryPlus() {
        return new LInteger(this.value);
    }

    @Override
    @NotNull
    public LNumber unaryMinus() {
        return new LInteger(-this.value);
    }

    @Override
    public boolean truth() {
        return this.value != 0L;
    }

    @Override
    @NotNull
    public String getLinType() {
        return "integer";
    }

    @Override
    @Nullable
    public LAny getMember(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.value);
    }

    @NotNull
    public final LAny rangeTo(@NotNull LInteger right2) {
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        return new LRange(new LongRange(this.value, right2.value));
    }

    public final long component1() {
        return this.value;
    }

    @NotNull
    public final LInteger copy(long value2) {
        return new LInteger(value2);
    }

    public static /* synthetic */ LInteger copy$default(LInteger lInteger, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = lInteger.value;
        }
        return lInteger.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LInteger)) {
            return false;
        }
        LInteger lInteger = (LInteger)other;
        return this.value == lInteger.value;
    }
}

