/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm.impl;

import com.github.adriantodt.lin.bytecode.CompiledFunction;
import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledParameter;
import com.github.adriantodt.lin.bytecode.CompiledSource;
import com.github.adriantodt.lin.vm.StackTrace;
import com.github.adriantodt.lin.vm.impl.DefaultExecutionLayer;
import com.github.adriantodt.lin.vm.impl.Exceptions;
import com.github.adriantodt.lin.vm.impl.ExecutionLayer;
import com.github.adriantodt.lin.vm.impl.VMEvents;
import com.github.adriantodt.lin.vm.scope.DefaultMutableScope;
import com.github.adriantodt.lin.vm.scope.Scope;
import com.github.adriantodt.lin.vm.types.LAny;
import com.github.adriantodt.lin.vm.types.LCompiledFunction;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/adriantodt/lin/vm/impl/FunctionSetupLayer;", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "events", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "function", "Lcom/github/adriantodt/lin/vm/types/LCompiledFunction;", "thisValue", "Lcom/github/adriantodt/lin/vm/types/LAny;", "arguments", "", "(Lcom/github/adriantodt/lin/vm/impl/VMEvents;Lcom/github/adriantodt/lin/vm/types/LCompiledFunction;Lcom/github/adriantodt/lin/vm/types/LAny;Ljava/util/List;)V", "argsLeft", "", "body", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "paramsLeft", "Lcom/github/adriantodt/lin/bytecode/CompiledParameter;", "resolvedParamName", "", "scope", "Lcom/github/adriantodt/lin/vm/scope/DefaultMutableScope;", "onReturn", "", "value", "onThrow", "step", "trace", "Lcom/github/adriantodt/lin/vm/StackTrace;", "lin"})
public final class FunctionSetupLayer
implements ExecutionLayer {
    @NotNull
    private final VMEvents events;
    @NotNull
    private final LCompiledFunction function;
    @Nullable
    private final LAny thisValue;
    @NotNull
    private final CompiledNode body;
    @NotNull
    private final DefaultMutableScope scope;
    @NotNull
    private final List<CompiledParameter> paramsLeft;
    @NotNull
    private final List<LAny> argsLeft;
    @Nullable
    private String resolvedParamName;

    public FunctionSetupLayer(@NotNull VMEvents events, @NotNull LCompiledFunction function, @Nullable LAny thisValue, @NotNull List<? extends LAny> arguments) {
        CompiledNode compiledNode;
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.events = events;
        this.function = function;
        this.thisValue = thisValue;
        CompiledFunction compiledFunction = this.function.getData();
        int parametersId = compiledFunction.component1();
        int bodyId = compiledFunction.component3();
        FunctionSetupLayer functionSetupLayer = this;
        List<CompiledNode> list = this.function.getSource().getNodes();
        if (bodyId >= 0 && bodyId <= CollectionsKt.getLastIndex(list)) {
            compiledNode = list.get(bodyId);
        } else {
            int n = bodyId;
            FunctionSetupLayer functionSetupLayer2 = functionSetupLayer;
            boolean bl = false;
            compiledNode = new CompiledNode(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
            functionSetupLayer = functionSetupLayer2;
        }
        functionSetupLayer.body = compiledNode;
        this.scope = new DefaultMutableScope(this.function.getRootScope());
        this.paramsLeft = CollectionsKt.toMutableList((Collection)this.function.getSource().getFunctionParameters().get(parametersId));
        this.argsLeft = CollectionsKt.toMutableList((Collection)arguments);
    }

    public /* synthetic */ FunctionSetupLayer(VMEvents vMEvents, LCompiledFunction lCompiledFunction, LAny lAny, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            lAny = null;
        }
        this(vMEvents, lCompiledFunction, lAny, list);
    }

    @Override
    public void step() {
        while (!((Collection)this.paramsLeft).isEmpty()) {
            CompiledParameter parameter = (CompiledParameter)CollectionsKt.removeFirst(this.paramsLeft);
            LAny value2 = (LAny)CollectionsKt.removeFirstOrNull(this.argsLeft);
            String paramName = this.function.getSource().stringConst(parameter.getNameConst());
            if (parameter.getVarargs()) {
                throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented: varargs parameter"));
            }
            if (value2 != null) {
                this.scope.declareVariable(paramName, true);
                this.scope.set(paramName, value2);
                continue;
            }
            if (parameter.getDefaultValueNodeId() != -1) {
                CompiledNode paramBody = this.function.getSource().getNodes().get(parameter.getDefaultValueNodeId());
                this.resolvedParamName = paramName;
                this.scope.declareVariable(paramName, true);
                Scope scope = this.scope;
                CompiledSource compiledSource = this.function.getSource();
                String string = this.function.getName();
                if (string == null) {
                    string = "<anonymous function>";
                }
                this.events.pushLayer(new DefaultExecutionLayer(this.events, scope, compiledSource, string, paramBody, this.thisValue));
                return;
            }
            this.events.onThrow(Exceptions.INSTANCE.mismatchedArgs(this.events.stackTrace()));
            return;
        }
        Scope scope = new DefaultMutableScope(this.scope);
        CompiledSource compiledSource = this.function.getSource();
        String string = this.function.getName();
        if (string == null) {
            string = "<anonymous function>";
        }
        this.events.replaceLayer(new DefaultExecutionLayer(this.events, scope, compiledSource, string, this.body, this.thisValue));
    }

    @Override
    public void onReturn(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = this.resolvedParamName;
        if (string == null) {
            throw new IllegalStateException("resolvedParamName should not be null".toString());
        }
        String paramName = string;
        this.scope.set(paramName, value2);
    }

    @Override
    public void onThrow(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.events.onThrow(value2);
    }

    @Override
    @Nullable
    public StackTrace trace() {
        return null;
    }
}

