/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm.impl;

import com.github.adriantodt.lin.bytecode.CompiledFunction;
import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledSection;
import com.github.adriantodt.lin.bytecode.CompiledSource;
import com.github.adriantodt.lin.bytecode.SectionLabel;
import com.github.adriantodt.lin.bytecode.insn.ArrayInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.AssignInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryAddOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryDivideOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryInOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryMultiplyOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryNotEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRangeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRemainingOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinarySubtractOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BranchIfInsn;
import com.github.adriantodt.lin.bytecode.insn.BreakInsn;
import com.github.adriantodt.lin.bytecode.insn.ContinueInsn;
import com.github.adriantodt.lin.bytecode.insn.DeclareVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.DupInsn;
import com.github.adriantodt.lin.bytecode.insn.GetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.GetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.GetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.bytecode.insn.InvokeInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeLocalInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeMemberInsn;
import com.github.adriantodt.lin.bytecode.insn.JumpInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadStringInsn;
import com.github.adriantodt.lin.bytecode.insn.NewArrayInsn;
import com.github.adriantodt.lin.bytecode.insn.NewFunctionInsn;
import com.github.adriantodt.lin.bytecode.insn.NewObjectInsn;
import com.github.adriantodt.lin.bytecode.insn.ObjectInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.PopExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopInsn;
import com.github.adriantodt.lin.bytecode.insn.PopLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushBooleanInsn;
import com.github.adriantodt.lin.bytecode.insn.PushDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.PushExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.PushLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushNullInsn;
import com.github.adriantodt.lin.bytecode.insn.PushScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushThisInsn;
import com.github.adriantodt.lin.bytecode.insn.ReturnInsn;
import com.github.adriantodt.lin.bytecode.insn.SetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.SetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.SetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.ThrowInsn;
import com.github.adriantodt.lin.bytecode.insn.TypeofInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNegativeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNotOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryPositiveOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryTruthOperationInsn;
import com.github.adriantodt.lin.exception.LinNativeException;
import com.github.adriantodt.lin.exception.LinUnsupportedOperationException;
import com.github.adriantodt.lin.exception.StackUnderflowException;
import com.github.adriantodt.lin.vm.LAnyException;
import com.github.adriantodt.lin.vm.StackTrace;
import com.github.adriantodt.lin.vm.impl.Exceptions;
import com.github.adriantodt.lin.vm.impl.ExecutionLayer;
import com.github.adriantodt.lin.vm.impl.FunctionSetupLayer;
import com.github.adriantodt.lin.vm.impl.VMEvents;
import com.github.adriantodt.lin.vm.scope.DefaultMutableScope;
import com.github.adriantodt.lin.vm.scope.MutableScope;
import com.github.adriantodt.lin.vm.scope.Scope;
import com.github.adriantodt.lin.vm.types.LAny;
import com.github.adriantodt.lin.vm.types.LArray;
import com.github.adriantodt.lin.vm.types.LCompiledFunction;
import com.github.adriantodt.lin.vm.types.LDecimal;
import com.github.adriantodt.lin.vm.types.LFalse;
import com.github.adriantodt.lin.vm.types.LInteger;
import com.github.adriantodt.lin.vm.types.LNativeFunction;
import com.github.adriantodt.lin.vm.types.LNull;
import com.github.adriantodt.lin.vm.types.LNumber;
import com.github.adriantodt.lin.vm.types.LObject;
import com.github.adriantodt.lin.vm.types.LString;
import com.github.adriantodt.lin.vm.types.LTrue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b5\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003ijkB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\b\u0010$\u001a\u00020\u001aH\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0002J\b\u0010(\u001a\u00020\u001aH\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0015H\u0002J\b\u0010-\u001a\u00020\u001aH\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\u0018\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\u0010\u00102\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u00106\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0018\u00107\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015H\u0002J\u0018\u00108\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0015H\u0002J\u0010\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0010\u0010<\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0015H\u0002J\b\u0010>\u001a\u00020\u001aH\u0002J\u0010\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u0015H\u0002J\b\u0010A\u001a\u00020\u001aH\u0002J\b\u0010B\u001a\u00020\u001aH\u0002J\b\u0010C\u001a\u00020\u001aH\u0002J\b\u0010D\u001a\u00020\u001aH\u0002J\b\u0010E\u001a\u00020\u001aH\u0002J\b\u0010F\u001a\u00020\u001aH\u0002J\u0010\u0010G\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020\u0015H\u0002J\u0018\u0010J\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u0015H\u0002J\u0010\u0010M\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020\u0015H\u0002J\u0018\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u0015H\u0002J\b\u0010Q\u001a\u00020\u001aH\u0002J\b\u0010R\u001a\u00020\u001aH\u0002J\b\u0010S\u001a\u00020\u001aH\u0002J\b\u0010T\u001a\u00020\u001aH\u0002J\u0010\u0010U\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u0010V\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u0010W\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010X\u001a\u00020\u001aH\u0002J\b\u0010Y\u001a\u00020\u001aH\u0002J\b\u0010Z\u001a\u00020\u001aH\u0002J\b\u0010[\u001a\u00020\u001aH\u0002J\b\u0010\\\u001a\u00020\u001aH\u0002J\b\u0010]\u001a\u00020\u001aH\u0002J(\u0010^\u001a\u00020\u001a2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010_\u001a\u00020\r2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\r0aH\u0002J\u0010\u0010b\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\rH\u0016J\u0010\u0010c\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\rH\u0016J\b\u0010d\u001a\u00020\rH\u0002J\b\u0010e\u001a\u00020\rH\u0002J\b\u0010f\u001a\u00020\u001aH\u0016J\n\u0010g\u001a\u0004\u0018\u00010hH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer;", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "events", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "scope", "Lcom/github/adriantodt/lin/vm/scope/Scope;", "source", "Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "functionName", "", "node", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "thisValue", "Lcom/github/adriantodt/lin/vm/types/LAny;", "(Lcom/github/adriantodt/lin/vm/impl/VMEvents;Lcom/github/adriantodt/lin/vm/scope/Scope;Lcom/github/adriantodt/lin/bytecode/CompiledSource;Ljava/lang/String;Lcom/github/adriantodt/lin/bytecode/CompiledNode;Lcom/github/adriantodt/lin/vm/types/LAny;)V", "exceptionHandlers", "", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$ExceptionHandler;", "loopHandlers", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$LoopHandler;", "next", "", "stack", "findSectionIndex", "last", "handleArrayInsert", "", "handleAssign", "nameConst", "handleBinaryAddOperation", "handleBinaryComparison", "comparison", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "handleBinaryDivideOperation", "handleBinaryEqualsOperation", "handleBinaryInOperation", "handleBinaryMultiplyOperation", "handleBinaryNotEqualsOperation", "handleBinaryRangeOperation", "handleBinaryRemainingOperation", "handleBinarySubtractOperation", "handleBranchIf", "value", "", "labelCode", "handleBreak", "handleContinue", "handleDeclareVariable", "mutable", "handleDup", "handleGetMemberProperty", "handleGetSubscript", "size", "handleGetVariable", "handleInvoke", "handleInvokeLocal", "handleInvokeMember", "handleJump", "handleLoadDecimal", "valueConst", "handleLoadInteger", "handleLoadString", "handleNewArray", "handleNewFunction", "functionId", "handleNewObject", "handleObjectInsert", "handlePop", "handlePopExceptionHandling", "handlePopLoopHandling", "handlePopScope", "handlePushBoolean", "handlePushDecimal", "immediateValue", "handlePushExceptionHandling", "catchLabel", "endLabel", "handlePushInteger", "handlePushLoopHandling", "breakLabel", "continueLabel", "handlePushNull", "handlePushScope", "handlePushThis", "handleReturn", "handleSetMemberProperty", "handleSetSubscript", "handleSetVariable", "handleThrow", "handleTypeof", "handleUnaryNegativeOperation", "handleUnaryNotOperation", "handleUnaryPositiveOperation", "handleUnaryTruthOperation", "invocation", "function", "args", "", "onReturn", "onThrow", "peekStack", "popStack", "step", "trace", "Lcom/github/adriantodt/lin/vm/StackTrace;", "Comparison", "ExceptionHandler", "LoopHandler", "lin"})
public final class DefaultExecutionLayer
implements ExecutionLayer {
    @NotNull
    private final VMEvents events;
    @NotNull
    private Scope scope;
    @NotNull
    private final CompiledSource source;
    @NotNull
    private final String functionName;
    @NotNull
    private final CompiledNode node;
    @Nullable
    private final LAny thisValue;
    private int next;
    @NotNull
    private final List<LAny> stack;
    @NotNull
    private final List<ExceptionHandler> exceptionHandlers;
    @NotNull
    private final List<LoopHandler> loopHandlers;

    public DefaultExecutionLayer(@NotNull VMEvents events, @NotNull Scope scope, @NotNull CompiledSource source, @NotNull String functionName, @NotNull CompiledNode node2, @Nullable LAny thisValue) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        this.events = events;
        this.scope = scope;
        this.source = source;
        this.functionName = functionName;
        this.node = node2;
        this.thisValue = thisValue;
        this.stack = new ArrayList();
        this.exceptionHandlers = new ArrayList();
        this.loopHandlers = new ArrayList();
    }

    public /* synthetic */ DefaultExecutionLayer(VMEvents vMEvents, Scope scope, CompiledSource compiledSource, String string, CompiledNode compiledNode, LAny lAny, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            compiledNode = compiledSource.getNodes().get(0);
        }
        if ((n & 0x20) != 0) {
            lAny = null;
        }
        this(vMEvents, scope, compiledSource, string, compiledNode, lAny);
    }

    @Override
    public void step() {
        int n = this.next;
        this.next = n + 1;
        Insn insn = (Insn)CollectionsKt.getOrNull(this.node.getInstructions(), (int)n);
        if (insn == null) {
            LAny lAny = (LAny)CollectionsKt.removeLastOrNull(this.stack);
            if (lAny == null) {
                lAny = LNull.INSTANCE;
            }
            this.events.onReturn(lAny);
            return;
        }
        try {
            Insn insn2 = insn;
            if (Intrinsics.areEqual((Object)insn2, (Object)ArrayInsertInsn.INSTANCE)) {
                this.handleArrayInsert();
            } else if (insn2 instanceof AssignInsn) {
                this.handleAssign(((AssignInsn)insn).getNameConst());
            } else if (insn2 instanceof BranchIfInsn) {
                this.handleBranchIf(((BranchIfInsn)insn).getValue(), ((BranchIfInsn)insn).getLabelCode());
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BreakInsn.INSTANCE)) {
                this.handleBreak();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)ContinueInsn.INSTANCE)) {
                this.handleContinue();
            } else if (insn2 instanceof DeclareVariableInsn) {
                this.handleDeclareVariable(((DeclareVariableInsn)insn).getMutable(), ((DeclareVariableInsn)insn).getNameConst());
            } else if (Intrinsics.areEqual((Object)insn2, (Object)DupInsn.INSTANCE)) {
                this.handleDup();
            } else if (insn2 instanceof GetMemberPropertyInsn) {
                this.handleGetMemberProperty(((GetMemberPropertyInsn)insn).getNameConst());
            } else if (insn2 instanceof GetSubscriptInsn) {
                this.handleGetSubscript(((GetSubscriptInsn)insn).getSize());
            } else if (insn2 instanceof GetVariableInsn) {
                this.handleGetVariable(((GetVariableInsn)insn).getNameConst());
            } else if (insn2 instanceof InvokeInsn) {
                this.handleInvoke(((InvokeInsn)insn).getSize());
            } else if (insn2 instanceof InvokeLocalInsn) {
                this.handleInvokeLocal(((InvokeLocalInsn)insn).getNameConst(), ((InvokeLocalInsn)insn).getSize());
            } else if (insn2 instanceof InvokeMemberInsn) {
                this.handleInvokeMember(((InvokeMemberInsn)insn).getNameConst(), ((InvokeMemberInsn)insn).getSize());
            } else if (insn2 instanceof JumpInsn) {
                this.handleJump(((JumpInsn)insn).getLabelCode());
            } else if (insn2 instanceof LoadDecimalInsn) {
                this.handleLoadDecimal(((LoadDecimalInsn)insn).getValueConst());
            } else if (insn2 instanceof LoadIntegerInsn) {
                this.handleLoadInteger(((LoadIntegerInsn)insn).getValueConst());
            } else if (insn2 instanceof LoadStringInsn) {
                this.handleLoadString(((LoadStringInsn)insn).getValueConst());
            } else if (Intrinsics.areEqual((Object)insn2, (Object)NewArrayInsn.INSTANCE)) {
                this.handleNewArray();
            } else if (insn2 instanceof NewFunctionInsn) {
                this.handleNewFunction(((NewFunctionInsn)insn).getFunctionId());
            } else if (Intrinsics.areEqual((Object)insn2, (Object)NewObjectInsn.INSTANCE)) {
                this.handleNewObject();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)ObjectInsertInsn.INSTANCE)) {
                this.handleObjectInsert();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PopExceptionHandlingInsn.INSTANCE)) {
                this.handlePopExceptionHandling();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PopInsn.INSTANCE)) {
                this.handlePop();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PopLoopHandlingInsn.INSTANCE)) {
                this.handlePopLoopHandling();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PopScopeInsn.INSTANCE)) {
                this.handlePopScope();
            } else if (insn2 instanceof PushBooleanInsn) {
                this.handlePushBoolean(((PushBooleanInsn)insn).getValue());
            } else if (insn2 instanceof PushDecimalInsn) {
                this.handlePushDecimal(((PushDecimalInsn)insn).getImmediateValue());
            } else if (insn2 instanceof PushExceptionHandlingInsn) {
                this.handlePushExceptionHandling(((PushExceptionHandlingInsn)insn).getCatchLabel(), ((PushExceptionHandlingInsn)insn).getEndLabel());
            } else if (insn2 instanceof PushIntegerInsn) {
                this.handlePushInteger(((PushIntegerInsn)insn).getImmediateValue());
            } else if (insn2 instanceof PushLoopHandlingInsn) {
                this.handlePushLoopHandling(((PushLoopHandlingInsn)insn).getBreakLabel(), ((PushLoopHandlingInsn)insn).getContinueLabel());
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PushNullInsn.INSTANCE)) {
                this.handlePushNull();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PushScopeInsn.INSTANCE)) {
                this.handlePushScope();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)PushThisInsn.INSTANCE)) {
                this.handlePushThis();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)ReturnInsn.INSTANCE)) {
                this.handleReturn();
            } else if (insn2 instanceof SetMemberPropertyInsn) {
                this.handleSetMemberProperty(((SetMemberPropertyInsn)insn).getNameConst());
            } else if (insn2 instanceof SetSubscriptInsn) {
                this.handleSetSubscript(((SetSubscriptInsn)insn).getSize());
            } else if (insn2 instanceof SetVariableInsn) {
                this.handleSetVariable(((SetVariableInsn)insn).getNameConst());
            } else if (Intrinsics.areEqual((Object)insn2, (Object)ThrowInsn.INSTANCE)) {
                this.handleThrow();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)TypeofInsn.INSTANCE)) {
                this.handleTypeof();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryAddOperationInsn.INSTANCE)) {
                this.handleBinaryAddOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryDivideOperationInsn.INSTANCE)) {
                this.handleBinaryDivideOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryEqualsOperationInsn.INSTANCE)) {
                this.handleBinaryEqualsOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryGtOperationInsn.INSTANCE)) {
                this.handleBinaryComparison(Comparison.GT);
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryGteOperationInsn.INSTANCE)) {
                this.handleBinaryComparison(Comparison.GTE);
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryInOperationInsn.INSTANCE)) {
                this.handleBinaryInOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryLtOperationInsn.INSTANCE)) {
                this.handleBinaryComparison(Comparison.LT);
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryLteOperationInsn.INSTANCE)) {
                this.handleBinaryComparison(Comparison.LTE);
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryMultiplyOperationInsn.INSTANCE)) {
                this.handleBinaryMultiplyOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryNotEqualsOperationInsn.INSTANCE)) {
                this.handleBinaryNotEqualsOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryRangeOperationInsn.INSTANCE)) {
                this.handleBinaryRangeOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinaryRemainingOperationInsn.INSTANCE)) {
                this.handleBinaryRemainingOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)BinarySubtractOperationInsn.INSTANCE)) {
                this.handleBinarySubtractOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)UnaryNegativeOperationInsn.INSTANCE)) {
                this.handleUnaryNegativeOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)UnaryNotOperationInsn.INSTANCE)) {
                this.handleUnaryNotOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)UnaryPositiveOperationInsn.INSTANCE)) {
                this.handleUnaryPositiveOperation();
            } else if (Intrinsics.areEqual((Object)insn2, (Object)UnaryTruthOperationInsn.INSTANCE)) {
                this.handleUnaryTruthOperation();
            }
        }
        catch (Exception e) {
            Exception exception = e;
            this.onThrow(exception instanceof LAnyException ? ((LAnyException)e).getValue() : (exception instanceof LinNativeException ? (LAny)Exceptions.INSTANCE.toObject((LinNativeException)((Object)e), this.events.stackTrace()) : Exceptions.INSTANCE.fromNative(e, this.events.stackTrace())));
        }
    }

    @Override
    public void onReturn(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.stack.add(value2);
    }

    @Override
    public void onThrow(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ExceptionHandler handler = (ExceptionHandler)CollectionsKt.removeLastOrNull(this.exceptionHandlers);
        if (handler == null) {
            this.events.onThrow(value2);
            return;
        }
        if (handler.getKeepOnStack() < this.stack.size()) {
            System.out.println((Object)("WTF? Stack is missing " + (handler.getKeepOnStack() - this.stack.size()) + " items!! This is probably a bug!"));
        } else if (handler.getKeepOnStack() > this.stack.size()) {
            int n = handler.getKeepOnStack() - this.stack.size();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int it2 = n3 = n2++;
                boolean bl = false;
                this.popStack();
            }
        }
        this.next = handler.getJumpOnException();
        this.stack.add(value2);
    }

    private final LAny popStack() {
        LAny lAny = (LAny)CollectionsKt.removeLastOrNull(this.stack);
        if (lAny == null) {
            throw new StackUnderflowException("Tried to remove an item from the stack, but the stack is empty.");
        }
        return lAny;
    }

    private final LAny peekStack() {
        LAny lAny = (LAny)CollectionsKt.lastOrNull(this.stack);
        if (lAny == null) {
            throw new StackUnderflowException("Tried to get the last item from the stack, but the stack is empty.");
        }
        return lAny;
    }

    private final void handleArrayInsert() {
        LAny value2 = this.popStack();
        LAny lAny = this.peekStack();
        LArray lArray = lAny instanceof LArray ? (LArray)lAny : null;
        if (lArray == null) {
            throw new IllegalStateException("Value is not an LArray.".toString());
        }
        LArray array = lArray;
        array.getValue().add(value2);
    }

    private final void handleAssign(int nameConst) {
        this.scope.set(this.source.stringConst(nameConst), this.popStack());
    }

    private final void handleBranchIf(boolean value2, int labelCode) {
        boolean truth = this.popStack().truth();
        if (truth == value2) {
            this.next = this.node.resolveLabel(labelCode);
        }
    }

    private final void handleBreak() {
        LoopHandler last = (LoopHandler)CollectionsKt.removeLast(this.loopHandlers);
        this.next = last.getJumpOnBreak();
    }

    private final void handleContinue() {
        LoopHandler last = (LoopHandler)CollectionsKt.removeLast(this.loopHandlers);
        this.next = last.getJumpOnContinue();
    }

    private final void handleDeclareVariable(boolean mutable, int nameConst) {
        Scope scope = this.scope;
        MutableScope mutableScope = scope instanceof MutableScope ? (MutableScope)scope : null;
        if (mutableScope == null) {
            throw new IllegalStateException("Current scope is not mutable".toString());
        }
        MutableScope s = mutableScope;
        s.declareVariable(this.source.stringConst(nameConst), mutable);
    }

    private final void handleDup() {
        this.stack.add(this.peekStack());
    }

    private final void handleGetMemberProperty(int nameConst) {
        String name;
        LAny target2 = this.popStack();
        LAny member = target2.getMember(name = this.source.stringConst(nameConst));
        if (member != null) {
            this.stack.add(member);
        }
        this.onThrow(Exceptions.INSTANCE.noElementExists(name, this.events.stackTrace()));
    }

    private final void handleGetSubscript(int size) {
        LAny element;
        LAny arg;
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        int n = 0;
        while (n < size) {
            int n2;
            int n3;
            int n4 = n3 = (n2 = n++);
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.popStack());
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny parent = this.popStack();
        if (parent instanceof LArray && size == 1 && (arg = (LAny)CollectionsKt.first((List)arguments)) instanceof LInteger && (element = (LAny)CollectionsKt.getOrNull(((LArray)parent).getValue(), (int)((int)((LInteger)arg).getValue()))) != null) {
            this.stack.add(element);
            return;
        }
        if (parent instanceof LObject && size == 1) {
            arg = (LAny)CollectionsKt.first((List)arguments);
            element = ((LObject)parent).getValue().get(arg);
            if (element != null) {
                this.stack.add(element);
                return;
            }
        }
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)("Not yet implemented: GetSubscript -> " + parent + arguments)));
    }

    private final void handleGetVariable(int nameConst) {
        this.stack.add(this.scope.get(this.source.stringConst(nameConst)));
    }

    private final void handleInvoke(int size) {
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        int n = 0;
        while (n < size) {
            int n2;
            int n3;
            int n4 = n3 = (n2 = n++);
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.popStack());
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny function = this.popStack();
        this.invocation(null, function, arguments);
    }

    private final void handleInvokeLocal(int nameConst, int size) {
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        int n = 0;
        while (n < size) {
            int n2;
            int n3;
            int n4 = n3 = (n2 = n++);
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.popStack());
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny function = this.scope.get(this.source.stringConst(nameConst));
        this.invocation(null, function, arguments);
    }

    private final void handleInvokeMember(int nameConst, int size) {
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        int n = 0;
        while (n < size) {
            int n2;
            int n3;
            int n4 = n3 = (n2 = n++);
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.popStack());
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny parent = this.popStack();
        LAny lAny = parent.getMember(this.source.stringConst(nameConst));
        if (lAny == null) {
            lAny = LNull.INSTANCE;
        }
        LAny function = lAny;
        this.invocation(parent, function, arguments);
    }

    private final void handleJump(int labelCode) {
        this.next = this.node.resolveLabel(labelCode);
    }

    private final void handleLoadDecimal(int valueConst) {
        this.stack.add(new LDecimal(Double.longBitsToDouble(this.source.longConst(valueConst))));
    }

    private final void handleLoadInteger(int valueConst) {
        this.stack.add(new LInteger(this.source.longConst(valueConst)));
    }

    private final void handleLoadString(int valueConst) {
        this.stack.add(new LString(this.source.stringConst(valueConst)));
    }

    private final void handleNewArray() {
        this.stack.add(new LArray(null, 1, null));
    }

    private final void handleNewFunction(int functionId) {
        CompiledFunction functionData = this.source.getFunctions().get(functionId);
        this.stack.add(new LCompiledFunction(this.source, functionData, this.scope));
    }

    private final void handleNewObject() {
        this.stack.add(new LObject(null, 1, null));
    }

    private final void handleObjectInsert() {
        LAny value2 = this.popStack();
        LAny key = this.popStack();
        Object object = this.peekStack();
        LObject lObject = object instanceof LObject ? (LObject)object : null;
        if (lObject == null) {
            object = "Value is not an LObject.";
            throw new IllegalStateException(object.toString());
        }
        LObject obj = lObject;
        obj.getValue().put(key, value2);
    }

    private final void handlePopExceptionHandling() {
        CollectionsKt.removeLast(this.exceptionHandlers);
    }

    private final void handlePop() {
        this.popStack();
    }

    private final void handlePopLoopHandling() {
        CollectionsKt.removeLast(this.loopHandlers);
    }

    private final void handlePopScope() {
        Scope scope = this.scope.getParent();
        if (scope == null) {
            throw new IllegalStateException("Can't pop root scope.".toString());
        }
        this.scope = scope;
    }

    private final void handlePushBoolean(boolean value2) {
        this.stack.add(value2 ? (LAny)LTrue.INSTANCE : (LAny)LFalse.INSTANCE);
    }

    private final void handlePushDecimal(int immediateValue) {
        this.stack.add(new LDecimal(immediateValue));
    }

    private final void handlePushExceptionHandling(int catchLabel, int endLabel) {
        this.exceptionHandlers.add(new ExceptionHandler(this.stack.size(), this.node.resolveLabel(catchLabel), this.node.resolveLabel(endLabel)));
    }

    private final void handlePushInteger(int immediateValue) {
        this.stack.add(new LInteger(immediateValue));
    }

    private final void handlePushLoopHandling(int breakLabel, int continueLabel) {
        this.loopHandlers.add(new LoopHandler(this.stack.size(), this.node.resolveLabel(breakLabel), this.node.resolveLabel(continueLabel)));
    }

    private final void handlePushNull() {
        this.stack.add(LNull.INSTANCE);
    }

    private final void handlePushScope() {
        this.scope = new DefaultMutableScope(this.scope);
    }

    private final void handlePushThis() {
        LAny lAny = this.thisValue;
        if (lAny == null) {
            throw new IllegalStateException("There's no 'this' defined.".toString());
        }
        this.stack.add(lAny);
    }

    private final void handleReturn() {
        this.events.onReturn(this.popStack());
    }

    private final void handleSetMemberProperty(int nameConst) {
        Object object;
        LAny value2 = this.popStack();
        String s = this.source.stringConst(nameConst);
        LAny parent = this.popStack();
        if (parent instanceof LObject) {
            object = ((LObject)parent).getValue();
            LString lString = new LString(s);
            object.put(lString, value2);
        }
        object = "Not yet implemented: SetMember " + parent + "." + s + " = " + value2;
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)object));
    }

    private final void handleSetSubscript(int size) {
        LAny arg;
        LAny value2 = this.popStack();
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        int n = 0;
        while (n < size) {
            int n2;
            int n3;
            int n4 = n3 = (n2 = n++);
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.popStack());
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny parent = this.popStack();
        if (parent instanceof LArray && size == 1 && (arg = (LAny)CollectionsKt.first((List)arguments)) instanceof LInteger) {
            ((LArray)parent).getValue().set((int)((LInteger)arg).getValue(), value2);
            return;
        }
        if (parent instanceof LObject && size == 1) {
            arg = (LAny)CollectionsKt.first((List)arguments);
            ((LObject)parent).getValue().put(arg, value2);
            return;
        }
        String string = "Not yet implemented: SetSubscript -> " + parent + arguments + " = " + value2;
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)string));
    }

    private final void handleSetVariable(int nameConst) {
        this.scope.set(this.source.stringConst(nameConst), this.popStack());
    }

    private final void handleThrow() {
        this.onThrow(this.popStack());
    }

    private final void handleTypeof() {
        this.stack.add(new LString(this.popStack().getLinType()));
    }

    private final void handleBinaryAddOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LString || right2 instanceof LString) {
            this.stack.add(new LString("" + left + right2));
            return;
        }
        if (left instanceof LArray && right2 instanceof LArray) {
            this.stack.add(new LArray(CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)((LArray)left).getValue(), (Iterable)((LArray)right2).getValue()))));
            return;
        }
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).plus((LNumber)right2));
            return;
        }
        throw new LinUnsupportedOperationException("add", left.getLinType(), right2.getLinType());
    }

    private final void handleBinaryDivideOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).div((LNumber)right2));
            return;
        }
        throw new LinUnsupportedOperationException("divide", left.getLinType(), right2.getLinType());
    }

    private final void handleBinaryEqualsOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        this.stack.add(LAny.Companion.ofBoolean(Intrinsics.areEqual((Object)right2, (Object)left)));
    }

    private final void handleBinaryMultiplyOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LString && right2 instanceof LInteger) {
            this.stack.add(new LString(StringsKt.repeat((CharSequence)((LString)left).getValue(), (int)((int)((LInteger)right2).getValue()))));
        }
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).times((LNumber)right2));
            return;
        }
        throw new LinUnsupportedOperationException("multiply", left.getLinType(), right2.getLinType());
    }

    private final void handleBinaryNotEqualsOperation() {
        LAny left;
        LAny right2 = this.popStack();
        this.stack.add(LAny.Companion.ofBoolean(!Intrinsics.areEqual((Object)right2, (Object)(left = this.popStack()))));
    }

    private final void handleBinaryRangeOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LInteger && right2 instanceof LInteger) {
            this.stack.add(((LInteger)left).rangeTo((LInteger)right2));
            return;
        }
        throw new LinUnsupportedOperationException("range", left.getLinType(), right2.getLinType());
    }

    private final void handleBinaryRemainingOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).rem((LNumber)right2));
            return;
        }
        throw new LinUnsupportedOperationException("remaining", left.getLinType(), right2.getLinType());
    }

    private final void handleBinarySubtractOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).minus((LNumber)right2));
            return;
        }
        throw new LinUnsupportedOperationException("subtract", left.getLinType(), right2.getLinType());
    }

    private final void handleBinaryComparison(Comparison comparison) {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (left instanceof LString && right2 instanceof LString) {
            this.stack.add(LAny.Companion.ofBoolean(comparison.toBoolean(((LString)left).getValue().compareTo(((LString)right2).getValue()))));
            return;
        }
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(LAny.Companion.ofBoolean(comparison.toBoolean(((LNumber)left).compareTo((LNumber)right2))));
            return;
        }
        throw new LinUnsupportedOperationException("comparison", left.getLinType(), right2.getLinType());
    }

    private final void handleBinaryInOperation() {
        LAny right2 = this.popStack();
        LAny left = this.popStack();
        if (right2 instanceof LArray) {
            this.stack.add(LAny.Companion.ofBoolean(((LArray)right2).getValue().contains(left)));
            return;
        }
        if (right2 instanceof LObject) {
            this.stack.add(LAny.Companion.ofBoolean(((LObject)right2).getValue().containsKey(left)));
            return;
        }
        throw new LinUnsupportedOperationException("in", left.getLinType(), right2.getLinType());
    }

    private final void handleUnaryNegativeOperation() {
        LAny target2 = this.popStack();
        if (target2 instanceof LNumber) {
            this.stack.add(((LNumber)target2).unaryMinus());
            return;
        }
        throw new LinUnsupportedOperationException("negative", target2.getLinType());
    }

    private final void handleUnaryNotOperation() {
        this.stack.add(LAny.Companion.ofBoolean(!this.popStack().truth()));
    }

    private final void handleUnaryPositiveOperation() {
        LAny target2 = this.popStack();
        if (target2 instanceof LNumber) {
            this.stack.add(((LNumber)target2).unaryPlus());
            return;
        }
        throw new LinUnsupportedOperationException("positive", target2.getLinType());
    }

    private final void handleUnaryTruthOperation() {
        this.stack.add(LAny.Companion.ofBoolean(this.popStack().truth()));
    }

    private final void invocation(LAny thisValue, LAny function, List<? extends LAny> args) {
        LAny lAny = function;
        if (lAny instanceof LNativeFunction) {
            try {
                this.stack.add((LAny)((LNativeFunction)function).getBlock().invoke((Object)thisValue, args));
            }
            catch (Exception e) {
                String string = ((LNativeFunction)function).getName();
                if (string == null) {
                    string = "<anonymous function>";
                }
                List stackTrace = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new StackTrace(string, null, 0, 0, 14, null)), (Iterable)this.events.stackTrace());
                Exception exception = e;
                this.onThrow(exception instanceof LAnyException ? ((LAnyException)e).getValue() : (exception instanceof LinNativeException ? (LAny)Exceptions.INSTANCE.toObject((LinNativeException)((Object)e), stackTrace) : Exceptions.INSTANCE.fromNative(e, stackTrace)));
            }
        } else if (lAny instanceof LCompiledFunction) {
            FunctionSetupLayer layer = new FunctionSetupLayer(this.events, (LCompiledFunction)function, thisValue, args);
            this.events.pushLayer(layer);
            layer.step();
        } else {
            this.onThrow(Exceptions.INSTANCE.notAFunction(function.getLinType(), this.events.stackTrace()));
        }
    }

    @Override
    @Nullable
    public StackTrace trace() {
        CompiledSection compiledSection = (CompiledSection)CollectionsKt.getOrNull(this.source.getSections(), (int)this.findSectionIndex(this.next - 1));
        if (compiledSection == null) {
            return null;
        }
        CompiledSection section = compiledSection;
        return new StackTrace(this.functionName, this.source.stringConst(section.getNameConst()), section.getLine(), section.getColumn());
    }

    private final int findSectionIndex(int last) {
        int atInsn = 0;
        for (SectionLabel sectionLabel : this.node.getSectionLabels()) {
            int length = sectionLabel.component1();
            int index = sectionLabel.component2();
            if (atInsn + length < last) {
                atInsn += length;
                continue;
            }
            return index;
        }
        return -1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$ExceptionHandler;", "", "keepOnStack", "", "jumpOnException", "jumpOnEnd", "(III)V", "getJumpOnEnd", "()I", "getJumpOnException", "getKeepOnStack", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "lin"})
    public static final class ExceptionHandler {
        private final int keepOnStack;
        private final int jumpOnException;
        private final int jumpOnEnd;

        public ExceptionHandler(int keepOnStack, int jumpOnException, int jumpOnEnd) {
            this.keepOnStack = keepOnStack;
            this.jumpOnException = jumpOnException;
            this.jumpOnEnd = jumpOnEnd;
        }

        public final int getKeepOnStack() {
            return this.keepOnStack;
        }

        public final int getJumpOnException() {
            return this.jumpOnException;
        }

        public final int getJumpOnEnd() {
            return this.jumpOnEnd;
        }

        public final int component1() {
            return this.keepOnStack;
        }

        public final int component2() {
            return this.jumpOnException;
        }

        public final int component3() {
            return this.jumpOnEnd;
        }

        @NotNull
        public final ExceptionHandler copy(int keepOnStack, int jumpOnException, int jumpOnEnd) {
            return new ExceptionHandler(keepOnStack, jumpOnException, jumpOnEnd);
        }

        public static /* synthetic */ ExceptionHandler copy$default(ExceptionHandler exceptionHandler, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = exceptionHandler.keepOnStack;
            }
            if ((n4 & 2) != 0) {
                n2 = exceptionHandler.jumpOnException;
            }
            if ((n4 & 4) != 0) {
                n3 = exceptionHandler.jumpOnEnd;
            }
            return exceptionHandler.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ExceptionHandler(keepOnStack=" + this.keepOnStack + ", jumpOnException=" + this.jumpOnException + ", jumpOnEnd=" + this.jumpOnEnd + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.keepOnStack);
            result = result * 31 + Integer.hashCode(this.jumpOnException);
            result = result * 31 + Integer.hashCode(this.jumpOnEnd);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExceptionHandler)) {
                return false;
            }
            ExceptionHandler exceptionHandler = (ExceptionHandler)other;
            if (this.keepOnStack != exceptionHandler.keepOnStack) {
                return false;
            }
            if (this.jumpOnException != exceptionHandler.jumpOnException) {
                return false;
            }
            return this.jumpOnEnd == exceptionHandler.jumpOnEnd;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$LoopHandler;", "", "keepOnStack", "", "jumpOnBreak", "jumpOnContinue", "(III)V", "getJumpOnBreak", "()I", "getJumpOnContinue", "getKeepOnStack", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "lin"})
    public static final class LoopHandler {
        private final int keepOnStack;
        private final int jumpOnBreak;
        private final int jumpOnContinue;

        public LoopHandler(int keepOnStack, int jumpOnBreak, int jumpOnContinue) {
            this.keepOnStack = keepOnStack;
            this.jumpOnBreak = jumpOnBreak;
            this.jumpOnContinue = jumpOnContinue;
        }

        public final int getKeepOnStack() {
            return this.keepOnStack;
        }

        public final int getJumpOnBreak() {
            return this.jumpOnBreak;
        }

        public final int getJumpOnContinue() {
            return this.jumpOnContinue;
        }

        public final int component1() {
            return this.keepOnStack;
        }

        public final int component2() {
            return this.jumpOnBreak;
        }

        public final int component3() {
            return this.jumpOnContinue;
        }

        @NotNull
        public final LoopHandler copy(int keepOnStack, int jumpOnBreak, int jumpOnContinue) {
            return new LoopHandler(keepOnStack, jumpOnBreak, jumpOnContinue);
        }

        public static /* synthetic */ LoopHandler copy$default(LoopHandler loopHandler, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = loopHandler.keepOnStack;
            }
            if ((n4 & 2) != 0) {
                n2 = loopHandler.jumpOnBreak;
            }
            if ((n4 & 4) != 0) {
                n3 = loopHandler.jumpOnContinue;
            }
            return loopHandler.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "LoopHandler(keepOnStack=" + this.keepOnStack + ", jumpOnBreak=" + this.jumpOnBreak + ", jumpOnContinue=" + this.jumpOnContinue + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.keepOnStack);
            result = result * 31 + Integer.hashCode(this.jumpOnBreak);
            result = result * 31 + Integer.hashCode(this.jumpOnContinue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopHandler)) {
                return false;
            }
            LoopHandler loopHandler = (LoopHandler)other;
            if (this.keepOnStack != loopHandler.keepOnStack) {
                return false;
            }
            if (this.jumpOnBreak != loopHandler.jumpOnBreak) {
                return false;
            }
            return this.jumpOnContinue == loopHandler.jumpOnContinue;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "", "(Ljava/lang/String;I)V", "toBoolean", "", "i", "", "GT", "GTE", "LT", "LTE", "lin"})
    public static final abstract class Comparison
    extends Enum<Comparison> {
        public static final /* enum */ Comparison GT = new GT("GT", 0);
        public static final /* enum */ Comparison GTE = new GTE("GTE", 1);
        public static final /* enum */ Comparison LT = new LT("LT", 2);
        public static final /* enum */ Comparison LTE = new LTE("LTE", 3);
        private static final /* synthetic */ Comparison[] $VALUES;

        private Comparison() {
        }

        public abstract boolean toBoolean(int var1);

        public static Comparison[] values() {
            return (Comparison[])$VALUES.clone();
        }

        public static Comparison valueOf(String value2) {
            return Enum.valueOf(Comparison.class, value2);
        }

        public /* synthetic */ Comparison(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = comparisonArray = new Comparison[]{Comparison.GT, Comparison.GTE, Comparison.LT, Comparison.LTE};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$GT;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class GT
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            GT() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i > 0;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$GTE;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class GTE
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            GTE() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i >= 0;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$LT;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class LT
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            LT() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i < 0;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$LTE;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class LTE
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            LTE() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i <= 0;
            }
        }
    }
}

