/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm;

import com.github.adriantodt.lin.bytecode.CompiledSource;
import com.github.adriantodt.lin.vm.LinResult;
import com.github.adriantodt.lin.vm.StackTrace;
import com.github.adriantodt.lin.vm.impl.DefaultExecutionLayer;
import com.github.adriantodt.lin.vm.impl.ExecutionLayer;
import com.github.adriantodt.lin.vm.impl.VMEvents;
import com.github.adriantodt.lin.vm.scope.DefaultMutableScope;
import com.github.adriantodt.lin.vm.scope.Scope;
import com.github.adriantodt.lin.vm.types.LAny;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine;", "", "source", "Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "scope", "Lcom/github/adriantodt/lin/vm/scope/Scope;", "(Lcom/github/adriantodt/lin/bytecode/CompiledSource;Lcom/github/adriantodt/lin/vm/scope/Scope;)V", "layerInitializer", "Lkotlin/Function1;", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "(Lkotlin/jvm/functions/Function1;)V", "currentLayer", "layerStack", "", "result", "Lcom/github/adriantodt/lin/vm/LinResult;", "hasNextStep", "", "run", "step", "", "EventsImpl", "lin"})
public final class LinVirtualMachine {
    @NotNull
    private final List<ExecutionLayer> layerStack;
    @NotNull
    private ExecutionLayer currentLayer;
    @Nullable
    private LinResult result;

    public LinVirtualMachine(@NotNull Function1<? super VMEvents, ? extends ExecutionLayer> layerInitializer) {
        Intrinsics.checkNotNullParameter(layerInitializer, (String)"layerInitializer");
        this.layerStack = new ArrayList();
        this.currentLayer = (ExecutionLayer)layerInitializer.invoke((Object)new EventsImpl(this));
    }

    public LinVirtualMachine(final @NotNull CompiledSource source, final @NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this((Function1<? super VMEvents, ? extends ExecutionLayer>)((Function1)new Function1<VMEvents, ExecutionLayer>(){

            @NotNull
            public final ExecutionLayer invoke(@NotNull VMEvents it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return new DefaultExecutionLayer(it2, new DefaultMutableScope(scope), source, "<main>", null, null, 48, null);
            }
        }));
    }

    @NotNull
    public final LinResult run() {
        while (this.hasNextStep()) {
            this.step();
        }
        return this.result();
    }

    public final boolean hasNextStep() {
        return this.result == null;
    }

    public final void step() {
        this.currentLayer.step();
    }

    @NotNull
    public final LinResult result() {
        LinResult linResult = this.result;
        if (linResult == null) {
            throw new RuntimeException("Execution not finished");
        }
        return linResult;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine$EventsImpl;", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "vm", "Lcom/github/adriantodt/lin/vm/LinVirtualMachine;", "(Lcom/github/adriantodt/lin/vm/LinVirtualMachine;)V", "onReturn", "", "value", "Lcom/github/adriantodt/lin/vm/types/LAny;", "onThrow", "pushLayer", "layer", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "replaceLayer", "stackTrace", "", "Lcom/github/adriantodt/lin/vm/StackTrace;", "lin"})
    private static final class EventsImpl
    implements VMEvents {
        @NotNull
        private final LinVirtualMachine vm;

        public EventsImpl(@NotNull LinVirtualMachine vm) {
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            this.vm = vm;
        }

        @Override
        public void pushLayer(@NotNull ExecutionLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            ((Collection)this.vm.layerStack).add(this.vm.currentLayer);
            this.vm.currentLayer = layer;
        }

        @Override
        public void replaceLayer(@NotNull ExecutionLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            this.vm.currentLayer = layer;
        }

        @Override
        public void onReturn(@NotNull LAny value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ExecutionLayer layer = (ExecutionLayer)CollectionsKt.removeLastOrNull((List)this.vm.layerStack);
            if (layer == null) {
                this.vm.result = new LinResult.Returned(value2);
                return;
            }
            this.vm.currentLayer = layer;
            layer.onReturn(value2);
        }

        @Override
        public void onThrow(@NotNull LAny value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ExecutionLayer layer = (ExecutionLayer)CollectionsKt.removeLastOrNull((List)this.vm.layerStack);
            if (layer == null) {
                this.vm.result = new LinResult.Thrown(value2);
                return;
            }
            this.vm.currentLayer = layer;
            layer.onThrow(value2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<StackTrace> stackTrace() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = CollectionsKt.asReversed((List)CollectionsKt.plus((Collection)this.vm.layerStack, (Object)this.vm.currentLayer));
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                StackTrace it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ExecutionLayer p0 = (ExecutionLayer)element$iv$iv;
                boolean bl2 = false;
                if (p0.trace() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }
}

