/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.compiler;

import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledParameter;
import com.github.adriantodt.lin.bytecode.JumpLabel;
import com.github.adriantodt.lin.bytecode.SectionLabel;
import com.github.adriantodt.lin.bytecode.insn.ArrayInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.AssignInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryAddOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryDivideOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryInOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryMultiplyOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryNotEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRangeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRemainingOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinarySubtractOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BranchIfInsn;
import com.github.adriantodt.lin.bytecode.insn.BreakInsn;
import com.github.adriantodt.lin.bytecode.insn.ContinueInsn;
import com.github.adriantodt.lin.bytecode.insn.DeclareVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.DupInsn;
import com.github.adriantodt.lin.bytecode.insn.GetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.GetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.GetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.bytecode.insn.InvokeInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeLocalInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeMemberInsn;
import com.github.adriantodt.lin.bytecode.insn.JumpInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadStringInsn;
import com.github.adriantodt.lin.bytecode.insn.NewArrayInsn;
import com.github.adriantodt.lin.bytecode.insn.NewFunctionInsn;
import com.github.adriantodt.lin.bytecode.insn.NewObjectInsn;
import com.github.adriantodt.lin.bytecode.insn.ObjectInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.PopExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopInsn;
import com.github.adriantodt.lin.bytecode.insn.PopLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushBooleanInsn;
import com.github.adriantodt.lin.bytecode.insn.PushDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.PushExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.PushLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushNullInsn;
import com.github.adriantodt.lin.bytecode.insn.PushScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushThisInsn;
import com.github.adriantodt.lin.bytecode.insn.ReturnInsn;
import com.github.adriantodt.lin.bytecode.insn.SetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.SetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.SetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.ThrowInsn;
import com.github.adriantodt.lin.bytecode.insn.TypeofInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNegativeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNotOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryPositiveOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryTruthOperationInsn;
import com.github.adriantodt.lin.compiler.CompiledSourceBuilder;
import com.github.adriantodt.lin.utils.BinaryOperationType;
import com.github.adriantodt.lin.utils.UnaryOperationType;
import com.github.adriantodt.tartar.api.lexer.Section;
import com.github.adriantodt.tartar.api.lexer.Sectional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 d2\u00020\u0001:\u0001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0014J\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0014J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0005H\u0002J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0005J\u0016\u0010-\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0005J\u0016\u0010.\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u0005J\"\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001406H\u0086\b\u00f8\u0001\u0000J\"\u00102\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001406H\u0086\b\u00f8\u0001\u0000J\u0006\u00108\u001a\u00020\u0014J\u000e\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;J\u000e\u00109\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u0005J\u0006\u0010<\u001a\u00020\u0014J&\u0010=\u001a\u00020\u00142\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010A\u001a\u00020\u0005J\u0006\u0010B\u001a\u00020\u0014J\u0006\u0010C\u001a\u00020\u0005J\u0006\u0010D\u001a\u00020\u0014J\u0006\u0010E\u001a\u00020\u0014J\u0006\u0010F\u001a\u00020\u0014J\u0006\u0010G\u001a\u00020\u0014J\u0006\u0010H\u001a\u00020\u0014J\u000e\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020$J\u000e\u0010K\u001a\u00020\u00142\u0006\u0010J\u001a\u00020LJ\u0016\u0010M\u001a\u00020\u00142\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u0005J\u000e\u0010P\u001a\u00020\u00142\u0006\u0010J\u001a\u00020QJ\u0016\u0010R\u001a\u00020\u00142\u0006\u0010S\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0005J\u0006\u0010U\u001a\u00020\u0014J\u0006\u0010V\u001a\u00020\u0014J\u000e\u0010W\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0017J\u0006\u0010X\u001a\u00020\u0014J\u0006\u0010Y\u001a\u00020\u0014J\u000e\u0010Z\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010[\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010\\\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010]\u001a\u00020\u0014J\u0006\u0010^\u001a\u00020\u0014J\u000e\u0010_\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020`J*\u0010a\u001a\u00020\u00142\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001406H\u0086\b\u00f8\u0001\u0000J*\u0010b\u001a\u00020\u00142\u0006\u0010S\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001406H\u0086\b\u00f8\u0001\u0000J\u001a\u0010c\u001a\u00020\u00142\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001406H\u0086\b\u00f8\u0001\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006e"}, d2={"Lcom/github/adriantodt/lin/compiler/CompiledNodeBuilder;", "", "parent", "Lcom/github/adriantodt/lin/compiler/CompiledSourceBuilder;", "nodeId", "", "(Lcom/github/adriantodt/lin/compiler/CompiledSourceBuilder;I)V", "instructions", "", "Lcom/github/adriantodt/lin/bytecode/insn/Insn;", "jumpLabels", "Lcom/github/adriantodt/lin/bytecode/JumpLabel;", "lastSectionInsn", "nextLabelCode", "getNodeId", "()I", "sectionLabels", "Lcom/github/adriantodt/lin/bytecode/SectionLabel;", "sectionStack", "arrayInsertInsn", "", "assignInsn", "name", "", "binaryOperationInsn", "operator", "Lcom/github/adriantodt/lin/utils/BinaryOperationType;", "branchIfFalseInsn", "labelCode", "branchIfTrueInsn", "breakInsn", "build", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "continueInsn", "declareVariableInsn", "mutable", "", "dupInsn", "generateSectionLabel", "lastSectionId", "getMemberPropertyInsn", "getSubscriptInsn", "size", "getVariableInsn", "invokeInsn", "invokeLocalInsn", "invokeMemberInsn", "jumpInsn", "markLabel", "code", "markSection", "sectional", "Lcom/github/adriantodt/tartar/api/lexer/Sectional;", "block", "Lkotlin/Function0;", "sectionId", "markSectionEnd", "markSectionStart", "section", "Lcom/github/adriantodt/tartar/api/lexer/Section;", "newArrayInsn", "newFunctionInsn", "parameters", "", "Lcom/github/adriantodt/lin/bytecode/CompiledParameter;", "bodyId", "newObjectInsn", "nextLabel", "objectInsertInsn", "popExceptionHandlingInsn", "popInsn", "popLoopHandlingInsn", "popScopeInsn", "pushBooleanInsn", "value", "pushDecimalInsn", "", "pushExceptionHandlingInsn", "catchLabel", "endLabel", "pushIntegerInsn", "", "pushLoopHandlingInsn", "continueLabel", "breakLabel", "pushNullInsn", "pushScopeInsn", "pushStringInsn", "pushThisInsn", "returnInsn", "setMemberPropertyInsn", "setSubscriptInsn", "setVariableInsn", "throwInsn", "typeofInsn", "unaryOperationInsn", "Lcom/github/adriantodt/lin/utils/UnaryOperationType;", "withExceptionHandling", "withLoopHandling", "withScope", "Companion", "lin"})
public final class CompiledNodeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompiledSourceBuilder parent;
    private final int nodeId;
    @NotNull
    private final List<Insn> instructions;
    @NotNull
    private final List<JumpLabel> jumpLabels;
    @NotNull
    private final List<SectionLabel> sectionLabels;
    @NotNull
    private final List<Integer> sectionStack;
    private int lastSectionInsn;
    private int nextLabelCode;
    private static final int I24_MAX = 0x7FFFFF;
    private static final int I24_MIN = -8388608;
    @NotNull
    private static final IntRange i24Range = new IntRange(-8388608, 0x7FFFFF);

    public CompiledNodeBuilder(@NotNull CompiledSourceBuilder parent, int nodeId) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.nodeId = nodeId;
        this.instructions = new ArrayList();
        this.jumpLabels = new ArrayList();
        this.sectionLabels = new ArrayList();
        this.sectionStack = new ArrayList();
    }

    public final int getNodeId() {
        return this.nodeId;
    }

    public final int nextLabel() {
        int n = this.nextLabelCode;
        this.nextLabelCode = n + 1;
        return n;
    }

    public final void newArrayInsn() {
        ((Collection)this.instructions).add(NewArrayInsn.INSTANCE);
    }

    public final void arrayInsertInsn() {
        ((Collection)this.instructions).add(ArrayInsertInsn.INSTANCE);
    }

    public final void assignInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new AssignInsn(this.parent.constantId(name)));
    }

    public final void pushBooleanInsn(boolean value2) {
        ((Collection)this.instructions).add(new PushBooleanInsn(value2));
    }

    public final void pushDecimalInsn(double value2) {
        if (value2 % 1.0 == 0.0) {
            IntRange intRange = i24Range;
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = (int)value2;
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (bl) {
                ((Collection)this.instructions).add(new PushDecimalInsn((int)value2));
                return;
            }
        }
        ((Collection)this.instructions).add(new LoadDecimalInsn(this.parent.constantId(value2)));
    }

    public final void pushIntegerInsn(long value2) {
        if (value2 % 1L == 0L) {
            IntRange intRange = i24Range;
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = (int)value2;
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (bl) {
                ((Collection)this.instructions).add(new PushIntegerInsn((int)value2));
                return;
            }
        }
        ((Collection)this.instructions).add(new LoadIntegerInsn(this.parent.constantId(value2)));
    }

    public final void invokeInsn(int size) {
        ((Collection)this.instructions).add(new InvokeInsn(size));
    }

    public final void invokeLocalInsn(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new InvokeLocalInsn(this.parent.constantId(name), size));
    }

    public final void invokeMemberInsn(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new InvokeMemberInsn(this.parent.constantId(name), size));
    }

    public final void pushStringInsn(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ((Collection)this.instructions).add(new LoadStringInsn(this.parent.constantId(value2)));
    }

    public final void returnInsn() {
        ((Collection)this.instructions).add(ReturnInsn.INSTANCE);
    }

    public final void pushThisInsn() {
        ((Collection)this.instructions).add(PushThisInsn.INSTANCE);
    }

    public final void pushNullInsn() {
        ((Collection)this.instructions).add(PushNullInsn.INSTANCE);
    }

    public final void typeofInsn() {
        ((Collection)this.instructions).add(TypeofInsn.INSTANCE);
    }

    public final void newObjectInsn() {
        ((Collection)this.instructions).add(NewObjectInsn.INSTANCE);
    }

    public final void objectInsertInsn() {
        ((Collection)this.instructions).add(ObjectInsertInsn.INSTANCE);
    }

    public final void breakInsn() {
        ((Collection)this.instructions).add(BreakInsn.INSTANCE);
    }

    public final void continueInsn() {
        ((Collection)this.instructions).add(ContinueInsn.INSTANCE);
    }

    public final void throwInsn() {
        ((Collection)this.instructions).add(ThrowInsn.INSTANCE);
    }

    public final void jumpInsn(int labelCode) {
        ((Collection)this.instructions).add(new JumpInsn(labelCode));
    }

    public final void branchIfFalseInsn(int labelCode) {
        ((Collection)this.instructions).add(new BranchIfInsn(false, labelCode));
    }

    public final void branchIfTrueInsn(int labelCode) {
        ((Collection)this.instructions).add(new BranchIfInsn(true, labelCode));
    }

    public final void unaryOperationInsn(@NotNull UnaryOperationType operator) {
        Insn insn;
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Collection collection = this.instructions;
        switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 1: {
                insn = UnaryPositiveOperationInsn.INSTANCE;
                break;
            }
            case 2: {
                insn = UnaryNegativeOperationInsn.INSTANCE;
                break;
            }
            case 3: {
                insn = UnaryNotOperationInsn.INSTANCE;
                break;
            }
            case 4: {
                insn = UnaryTruthOperationInsn.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        collection.add(insn);
    }

    public final void binaryOperationInsn(@NotNull BinaryOperationType operator) {
        Insn insn;
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Collection collection = this.instructions;
        switch (WhenMappings.$EnumSwitchMapping$1[operator.ordinal()]) {
            case 1: {
                insn = BinaryAddOperationInsn.INSTANCE;
                break;
            }
            case 2: {
                insn = BinarySubtractOperationInsn.INSTANCE;
                break;
            }
            case 3: {
                insn = BinaryMultiplyOperationInsn.INSTANCE;
                break;
            }
            case 4: {
                insn = BinaryDivideOperationInsn.INSTANCE;
                break;
            }
            case 5: {
                insn = BinaryRemainingOperationInsn.INSTANCE;
                break;
            }
            case 6: {
                insn = BinaryEqualsOperationInsn.INSTANCE;
                break;
            }
            case 7: {
                insn = BinaryNotEqualsOperationInsn.INSTANCE;
                break;
            }
            case 8: {
                insn = BinaryLtOperationInsn.INSTANCE;
                break;
            }
            case 9: {
                insn = BinaryLteOperationInsn.INSTANCE;
                break;
            }
            case 10: {
                insn = BinaryGtOperationInsn.INSTANCE;
                break;
            }
            case 11: {
                insn = BinaryGteOperationInsn.INSTANCE;
                break;
            }
            case 12: {
                insn = BinaryInOperationInsn.INSTANCE;
                break;
            }
            case 13: {
                insn = BinaryRangeOperationInsn.INSTANCE;
                break;
            }
            default: {
                throw new RuntimeException("The operator " + operator + " can't be converted to a instruction and must be de-sugared.");
            }
        }
        collection.add(insn);
    }

    public final void declareVariableInsn(@NotNull String name, boolean mutable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new DeclareVariableInsn(this.parent.constantId(name), mutable));
    }

    public final void getVariableInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new GetVariableInsn(this.parent.constantId(name)));
    }

    public final void setVariableInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new SetVariableInsn(this.parent.constantId(name)));
    }

    public final void getMemberPropertyInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new GetMemberPropertyInsn(this.parent.constantId(name)));
    }

    public final void setMemberPropertyInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Collection)this.instructions).add(new SetMemberPropertyInsn(this.parent.constantId(name)));
    }

    public final void getSubscriptInsn(int size) {
        ((Collection)this.instructions).add(new GetSubscriptInsn(size));
    }

    public final void setSubscriptInsn(int size) {
        ((Collection)this.instructions).add(new SetSubscriptInsn(size));
    }

    public final void newFunctionInsn(@NotNull List<CompiledParameter> parameters, @Nullable String name, int bodyId) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        ((Collection)this.instructions).add(new NewFunctionInsn(this.parent.registerFunction(this.parent.registerParameters(parameters), name, bodyId)));
    }

    public final void dupInsn() {
        ((Collection)this.instructions).add(DupInsn.INSTANCE);
    }

    public final void popInsn() {
        ((Collection)this.instructions).add(PopInsn.INSTANCE);
    }

    public final void pushScopeInsn() {
        ((Collection)this.instructions).add(PushScopeInsn.INSTANCE);
    }

    public final void popScopeInsn() {
        ((Collection)this.instructions).add(PopScopeInsn.INSTANCE);
    }

    public final void pushExceptionHandlingInsn(int catchLabel, int endLabel) {
        ((Collection)this.instructions).add(new PushExceptionHandlingInsn(catchLabel, endLabel));
    }

    public final void popExceptionHandlingInsn() {
        ((Collection)this.instructions).add(PopExceptionHandlingInsn.INSTANCE);
    }

    public final void pushLoopHandlingInsn(int continueLabel, int breakLabel) {
        ((Collection)this.instructions).add(new PushLoopHandlingInsn(continueLabel, breakLabel));
    }

    public final void popLoopHandlingInsn() {
        ((Collection)this.instructions).add(PopLoopHandlingInsn.INSTANCE);
    }

    public final void markLabel(int code) {
        int n = this.instructions.size();
        ((Collection)this.jumpLabels).add(new JumpLabel(code, n));
    }

    public final void markSectionStart(int sectionId) {
        Integer last = (Integer)CollectionsKt.lastOrNull(this.sectionStack);
        this.sectionStack.add(sectionId);
        if (last != null) {
            this.generateSectionLabel(last);
        }
    }

    public final void markSectionStart(@NotNull Section section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        this.markSectionStart(this.parent.sectionId(section));
    }

    public final void markSectionEnd() {
        int last = ((Number)CollectionsKt.removeLast(this.sectionStack)).intValue();
        this.generateSectionLabel(last);
    }

    public final void markSection(int sectionId, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$markSection = false;
        this.markSectionStart(sectionId);
        block.invoke();
        this.markSectionEnd();
    }

    public final void markSection(@NotNull Sectional sectional, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)sectional, (String)"sectional");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$markSection = false;
        Section section = sectional.getSection();
        if (section == null) {
            block.invoke();
            return;
        }
        Section section2 = section;
        this.markSectionStart(section2);
        block.invoke();
        this.markSectionEnd();
    }

    public final void withExceptionHandling(int catchLabel, int endLabel, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withExceptionHandling = false;
        this.pushExceptionHandlingInsn(catchLabel, endLabel);
        block.invoke();
        this.popExceptionHandlingInsn();
    }

    public final void withLoopHandling(int continueLabel, int breakLabel, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withLoopHandling = false;
        this.pushLoopHandlingInsn(continueLabel, breakLabel);
        block.invoke();
        this.popLoopHandlingInsn();
    }

    public final void withScope(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withScope = false;
        this.pushScopeInsn();
        block.invoke();
        this.popScopeInsn();
    }

    private final void generateSectionLabel(int lastSectionId) {
        int currSectionInsn = this.instructions.size();
        if (this.lastSectionInsn < currSectionInsn) {
            int length = currSectionInsn - this.lastSectionInsn;
            this.sectionLabels.add(new SectionLabel(length, lastSectionId));
            this.lastSectionInsn = currSectionInsn;
        }
    }

    @NotNull
    public final CompiledNode build() {
        if (!((Collection)this.sectionStack).isEmpty()) {
            System.out.println((Object)"This should not have happened.");
            this.generateSectionLabel(((Number)CollectionsKt.last(this.sectionStack)).intValue());
        }
        return new CompiledNode(CollectionsKt.toList((Iterable)this.instructions), CollectionsKt.toList((Iterable)this.jumpLabels), CollectionsKt.toList((Iterable)this.sectionLabels));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/adriantodt/lin/compiler/CompiledNodeBuilder$Companion;", "", "()V", "I24_MAX", "", "I24_MIN", "i24Range", "Lkotlin/ranges/IntRange;", "lin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnaryOperationType.values().length];
            nArray[UnaryOperationType.POSITIVE.ordinal()] = 1;
            nArray[UnaryOperationType.NEGATIVE.ordinal()] = 2;
            nArray[UnaryOperationType.NOT.ordinal()] = 3;
            nArray[UnaryOperationType.TRUTH.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BinaryOperationType.values().length];
            nArray[BinaryOperationType.ADD.ordinal()] = 1;
            nArray[BinaryOperationType.SUBTRACT.ordinal()] = 2;
            nArray[BinaryOperationType.MULTIPLY.ordinal()] = 3;
            nArray[BinaryOperationType.DIVIDE.ordinal()] = 4;
            nArray[BinaryOperationType.REMAINING.ordinal()] = 5;
            nArray[BinaryOperationType.EQUALS.ordinal()] = 6;
            nArray[BinaryOperationType.NOT_EQUALS.ordinal()] = 7;
            nArray[BinaryOperationType.LT.ordinal()] = 8;
            nArray[BinaryOperationType.LTE.ordinal()] = 9;
            nArray[BinaryOperationType.GT.ordinal()] = 10;
            nArray[BinaryOperationType.GTE.ordinal()] = 11;
            nArray[BinaryOperationType.IN.ordinal()] = 12;
            nArray[BinaryOperationType.RANGE.ordinal()] = 13;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

