/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.bytecode.insn;

import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.bytecode.utils.InsnUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/github/adriantodt/lin/bytecode/insn/PushLoopHandlingInsn;", "Lcom/github/adriantodt/lin/bytecode/insn/Insn;", "continueLabel", "", "breakLabel", "(II)V", "getBreakLabel", "()I", "getContinueLabel", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "serializeTo", "", "buffer", "Lokio/Buffer;", "toString", "", "lin"})
public final class PushLoopHandlingInsn
extends Insn {
    private final int continueLabel;
    private final int breakLabel;

    public PushLoopHandlingInsn(int continueLabel, int breakLabel) {
        super(null);
        this.continueLabel = continueLabel;
        this.breakLabel = breakLabel;
    }

    public final int getContinueLabel() {
        return this.continueLabel;
    }

    public final int getBreakLabel() {
        return this.breakLabel;
    }

    @Override
    public void serializeTo(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        InsnUtilsKt.writeU12Pair(buffer.writeByte(Insn.Opcode.PUSH_LOOP_HANDLING.ordinal()), this.continueLabel, this.breakLabel);
    }

    public final int component1() {
        return this.continueLabel;
    }

    public final int component2() {
        return this.breakLabel;
    }

    @NotNull
    public final PushLoopHandlingInsn copy(int continueLabel, int breakLabel) {
        return new PushLoopHandlingInsn(continueLabel, breakLabel);
    }

    public static /* synthetic */ PushLoopHandlingInsn copy$default(PushLoopHandlingInsn pushLoopHandlingInsn, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = pushLoopHandlingInsn.continueLabel;
        }
        if ((n3 & 2) != 0) {
            n2 = pushLoopHandlingInsn.breakLabel;
        }
        return pushLoopHandlingInsn.copy(n, n2);
    }

    @Override
    @NotNull
    public String toString() {
        return "PushLoopHandlingInsn(continueLabel=" + this.continueLabel + ", breakLabel=" + this.breakLabel + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.continueLabel);
        result = result * 31 + Integer.hashCode(this.breakLabel);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PushLoopHandlingInsn)) {
            return false;
        }
        PushLoopHandlingInsn pushLoopHandlingInsn = (PushLoopHandlingInsn)other;
        if (this.continueLabel != pushLoopHandlingInsn.continueLabel) {
            return false;
        }
        return this.breakLabel == pushLoopHandlingInsn.breakLabel;
    }
}

