/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.bytecode.insn;

import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.bytecode.utils.InsnUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/github/adriantodt/lin/bytecode/insn/DeclareVariableInsn;", "Lcom/github/adriantodt/lin/bytecode/insn/Insn;", "nameConst", "", "mutable", "", "(IZ)V", "getMutable", "()Z", "getNameConst", "()I", "component1", "component2", "copy", "equals", "other", "", "hashCode", "serializeTo", "", "buffer", "Lokio/Buffer;", "toString", "", "lin"})
public final class DeclareVariableInsn
extends Insn {
    private final int nameConst;
    private final boolean mutable;

    public DeclareVariableInsn(int nameConst, boolean mutable) {
        super(null);
        this.nameConst = nameConst;
        this.mutable = mutable;
    }

    public final int getNameConst() {
        return this.nameConst;
    }

    public final boolean getMutable() {
        return this.mutable;
    }

    @Override
    public void serializeTo(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        InsnUtilsKt.writeU24(buffer.writeByte((this.mutable ? Insn.Opcode.DECLARE_VARIABLE_MUTABLE : Insn.Opcode.DECLARE_VARIABLE_IMMUTABLE).ordinal()), this.nameConst);
    }

    public final int component1() {
        return this.nameConst;
    }

    public final boolean component2() {
        return this.mutable;
    }

    @NotNull
    public final DeclareVariableInsn copy(int nameConst, boolean mutable) {
        return new DeclareVariableInsn(nameConst, mutable);
    }

    public static /* synthetic */ DeclareVariableInsn copy$default(DeclareVariableInsn declareVariableInsn, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = declareVariableInsn.nameConst;
        }
        if ((n2 & 2) != 0) {
            bl = declareVariableInsn.mutable;
        }
        return declareVariableInsn.copy(n, bl);
    }

    @Override
    @NotNull
    public String toString() {
        return "DeclareVariableInsn(nameConst=" + this.nameConst + ", mutable=" + this.mutable + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.nameConst);
        int n = this.mutable ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeclareVariableInsn)) {
            return false;
        }
        DeclareVariableInsn declareVariableInsn = (DeclareVariableInsn)other;
        if (this.nameConst != declareVariableInsn.nameConst) {
            return false;
        }
        return this.mutable == declareVariableInsn.mutable;
    }
}

