/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.bytecode;

import com.github.adriantodt.lin.bytecode.CompiledFunction;
import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledParameter;
import com.github.adriantodt.lin.bytecode.CompiledSection;
import com.github.adriantodt.lin.exception.IllegalConstantIndexException;
import com.github.adriantodt.lin.utils.Deserializer;
import com.github.adriantodt.lin.utils.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B_\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u00c6\u0003Jo\u0010\u001d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020#J\u0015\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020#\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020\u00062\u0006\u0010%\u001a\u00020#J\u0010\u0010-\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020#J\t\u0010.\u001a\u00020\u0006H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u00060"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "Lcom/github/adriantodt/lin/utils/Serializable;", "longPool", "", "", "stringPool", "", "functionParameters", "Lcom/github/adriantodt/lin/bytecode/CompiledParameter;", "functions", "Lcom/github/adriantodt/lin/bytecode/CompiledFunction;", "sections", "Lcom/github/adriantodt/lin/bytecode/CompiledSection;", "nodes", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getFunctionParameters", "()Ljava/util/List;", "getFunctions", "getLongPool", "getNodes", "getSections", "getStringPool", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "longConst", "index", "longConstOrNull", "(I)Ljava/lang/Long;", "serializeTo", "", "buffer", "Lokio/Buffer;", "stringConst", "stringConstOrNull", "toString", "Companion", "lin"})
public final class CompiledSource
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Long> longPool;
    @NotNull
    private final List<String> stringPool;
    @NotNull
    private final List<List<CompiledParameter>> functionParameters;
    @NotNull
    private final List<CompiledFunction> functions;
    @NotNull
    private final List<CompiledSection> sections;
    @NotNull
    private final List<CompiledNode> nodes;

    public CompiledSource(@NotNull List<Long> longPool, @NotNull List<String> stringPool, @NotNull List<? extends List<CompiledParameter>> functionParameters, @NotNull List<CompiledFunction> functions, @NotNull List<CompiledSection> sections, @NotNull List<CompiledNode> nodes) {
        Intrinsics.checkNotNullParameter(longPool, (String)"longPool");
        Intrinsics.checkNotNullParameter(stringPool, (String)"stringPool");
        Intrinsics.checkNotNullParameter(functionParameters, (String)"functionParameters");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.longPool = longPool;
        this.stringPool = stringPool;
        this.functionParameters = functionParameters;
        this.functions = functions;
        this.sections = sections;
        this.nodes = nodes;
    }

    @NotNull
    public final List<Long> getLongPool() {
        return this.longPool;
    }

    @NotNull
    public final List<String> getStringPool() {
        return this.stringPool;
    }

    @NotNull
    public final List<List<CompiledParameter>> getFunctionParameters() {
        return this.functionParameters;
    }

    @NotNull
    public final List<CompiledFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final List<CompiledSection> getSections() {
        return this.sections;
    }

    @NotNull
    public final List<CompiledNode> getNodes() {
        return this.nodes;
    }

    @Override
    public void serializeTo(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeInt(this.longPool.size());
        Iterator<Object> iterator2 = this.longPool.iterator();
        while (iterator2.hasNext()) {
            long l = ((Number)iterator2.next()).longValue();
            buffer.writeLong(l);
        }
        buffer.writeInt(this.stringPool.size());
        for (String string : this.stringPool) {
            ByteString encoded = ByteString.Companion.encodeUtf8(string);
            buffer.writeInt(encoded.size()).write(encoded);
        }
        buffer.writeInt(this.functionParameters.size());
        for (List list : this.functionParameters) {
            buffer.writeInt(list.size());
            for (CompiledParameter parameter : list) {
                parameter.serializeTo(buffer);
            }
        }
        buffer.writeInt(this.functions.size());
        for (CompiledFunction compiledFunction : this.functions) {
            compiledFunction.serializeTo(buffer);
        }
        buffer.writeInt(this.sections.size());
        for (CompiledSection compiledSection : this.sections) {
            compiledSection.serializeTo(buffer);
        }
        buffer.writeInt(this.nodes.size());
        for (CompiledNode compiledNode : this.nodes) {
            compiledNode.serializeTo(buffer);
        }
    }

    @Nullable
    public final Long longConstOrNull(int index) {
        return (Long)CollectionsKt.getOrNull(this.longPool, (int)index);
    }

    public final long longConst(int index) {
        Long l = this.longConstOrNull(index);
        if (l == null) {
            throw new IllegalConstantIndexException(index);
        }
        return l;
    }

    @Nullable
    public final String stringConstOrNull(int index) {
        return (String)CollectionsKt.getOrNull(this.stringPool, (int)index);
    }

    @NotNull
    public final String stringConst(int index) {
        String string = this.stringConstOrNull(index);
        if (string == null) {
            throw new IllegalConstantIndexException(index);
        }
        return string;
    }

    @Override
    @NotNull
    public ByteString toBytes() {
        return Serializable.DefaultImpls.toBytes(this);
    }

    @NotNull
    public final List<Long> component1() {
        return this.longPool;
    }

    @NotNull
    public final List<String> component2() {
        return this.stringPool;
    }

    @NotNull
    public final List<List<CompiledParameter>> component3() {
        return this.functionParameters;
    }

    @NotNull
    public final List<CompiledFunction> component4() {
        return this.functions;
    }

    @NotNull
    public final List<CompiledSection> component5() {
        return this.sections;
    }

    @NotNull
    public final List<CompiledNode> component6() {
        return this.nodes;
    }

    @NotNull
    public final CompiledSource copy(@NotNull List<Long> longPool, @NotNull List<String> stringPool, @NotNull List<? extends List<CompiledParameter>> functionParameters, @NotNull List<CompiledFunction> functions, @NotNull List<CompiledSection> sections, @NotNull List<CompiledNode> nodes) {
        Intrinsics.checkNotNullParameter(longPool, (String)"longPool");
        Intrinsics.checkNotNullParameter(stringPool, (String)"stringPool");
        Intrinsics.checkNotNullParameter(functionParameters, (String)"functionParameters");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        return new CompiledSource(longPool, stringPool, functionParameters, functions, sections, nodes);
    }

    public static /* synthetic */ CompiledSource copy$default(CompiledSource compiledSource, List list, List list2, List list3, List list4, List list5, List list6, int n, Object object) {
        if ((n & 1) != 0) {
            list = compiledSource.longPool;
        }
        if ((n & 2) != 0) {
            list2 = compiledSource.stringPool;
        }
        if ((n & 4) != 0) {
            list3 = compiledSource.functionParameters;
        }
        if ((n & 8) != 0) {
            list4 = compiledSource.functions;
        }
        if ((n & 0x10) != 0) {
            list5 = compiledSource.sections;
        }
        if ((n & 0x20) != 0) {
            list6 = compiledSource.nodes;
        }
        return compiledSource.copy(list, list2, list3, list4, list5, list6);
    }

    @NotNull
    public String toString() {
        return "CompiledSource(longPool=" + this.longPool + ", stringPool=" + this.stringPool + ", functionParameters=" + this.functionParameters + ", functions=" + this.functions + ", sections=" + this.sections + ", nodes=" + this.nodes + ")";
    }

    public int hashCode() {
        int result = ((Object)this.longPool).hashCode();
        result = result * 31 + ((Object)this.stringPool).hashCode();
        result = result * 31 + ((Object)this.functionParameters).hashCode();
        result = result * 31 + ((Object)this.functions).hashCode();
        result = result * 31 + ((Object)this.sections).hashCode();
        result = result * 31 + ((Object)this.nodes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompiledSource)) {
            return false;
        }
        CompiledSource compiledSource = (CompiledSource)other;
        if (!Intrinsics.areEqual(this.longPool, compiledSource.longPool)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stringPool, compiledSource.stringPool)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.functionParameters, compiledSource.functionParameters)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.functions, compiledSource.functions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sections, compiledSource.sections)) {
            return false;
        }
        return Intrinsics.areEqual(this.nodes, compiledSource.nodes);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledSource$Companion;", "Lcom/github/adriantodt/lin/utils/Deserializer;", "Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "()V", "deserializeFrom", "buffer", "Lokio/Buffer;", "lin"})
    public static final class Companion
    implements Deserializer<CompiledSource> {
        private Companion() {
        }

        @Override
        @NotNull
        public CompiledSource deserializeFrom(@NotNull Buffer buffer) {
            int n;
            int n2;
            int it2;
            int it3;
            int n3;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            List longPool = new ArrayList();
            int n4 = buffer.readInt();
            int n5 = 0;
            while (n5 < n4) {
                it3 = n3 = n5++;
                boolean bl = false;
                ((Collection)longPool).add(buffer.readLong());
            }
            List stringPool = new ArrayList();
            n5 = buffer.readInt();
            n3 = 0;
            while (n3 < n5) {
                it2 = it3 = n3++;
                boolean bl = false;
                int size = buffer.readInt();
                ((Collection)stringPool).add(buffer.readByteString((long)size).utf8());
            }
            List functionParameters = new ArrayList();
            n3 = buffer.readInt();
            it3 = 0;
            while (it3 < n3) {
                int it4 = it2 = it3++;
                boolean bl = false;
                List list = new ArrayList();
                int n6 = buffer.readInt();
                int n7 = 0;
                while (n7 < n6) {
                    int n8;
                    int it5 = n8 = n7++;
                    boolean bl2 = false;
                    ((Collection)list).add(CompiledParameter.Companion.deserializeFrom(buffer));
                }
                ((Collection)functionParameters).add(list);
            }
            List functions = new ArrayList();
            it3 = buffer.readInt();
            it2 = 0;
            while (it2 < it3) {
                int it6 = n2 = it2++;
                boolean bl = false;
                ((Collection)functions).add(CompiledFunction.Companion.deserializeFrom(buffer));
            }
            List sections = new ArrayList();
            it2 = buffer.readInt();
            n2 = 0;
            while (n2 < it2) {
                int it7 = n = n2++;
                boolean bl = false;
                ((Collection)sections).add(CompiledSection.Companion.deserializeFrom(buffer));
            }
            List nodes = new ArrayList();
            n2 = buffer.readInt();
            n = 0;
            while (n < n2) {
                int n9;
                int it8 = n9 = n++;
                boolean bl = false;
                ((Collection)nodes).add(CompiledNode.Companion.deserializeFrom(buffer));
            }
            return new CompiledSource(longPool, stringPool, functionParameters, functions, sections, nodes);
        }

        @Override
        @NotNull
        public CompiledSource fromBytes(@NotNull ByteString source) {
            return (CompiledSource)Deserializer.DefaultImpls.fromBytes(this, source);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

