/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.bytecode;

import com.github.adriantodt.lin.bytecode.JumpLabel;
import com.github.adriantodt.lin.bytecode.SectionLabel;
import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.utils.Deserializer;
import com.github.adriantodt.lin.utils.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J9\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "Lcom/github/adriantodt/lin/utils/Serializable;", "instructions", "", "Lcom/github/adriantodt/lin/bytecode/insn/Insn;", "jumpLabels", "Lcom/github/adriantodt/lin/bytecode/JumpLabel;", "sectionLabels", "Lcom/github/adriantodt/lin/bytecode/SectionLabel;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getInstructions", "()Ljava/util/List;", "getJumpLabels", "getSectionLabels", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "resolveLabel", "code", "serializeTo", "", "buffer", "Lokio/Buffer;", "toString", "", "Companion", "lin"})
public final class CompiledNode
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Insn> instructions;
    @NotNull
    private final List<JumpLabel> jumpLabels;
    @NotNull
    private final List<SectionLabel> sectionLabels;

    public CompiledNode(@NotNull List<? extends Insn> instructions, @NotNull List<JumpLabel> jumpLabels, @NotNull List<SectionLabel> sectionLabels) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(jumpLabels, (String)"jumpLabels");
        Intrinsics.checkNotNullParameter(sectionLabels, (String)"sectionLabels");
        this.instructions = instructions;
        this.jumpLabels = jumpLabels;
        this.sectionLabels = sectionLabels;
    }

    @NotNull
    public final List<Insn> getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final List<JumpLabel> getJumpLabels() {
        return this.jumpLabels;
    }

    @NotNull
    public final List<SectionLabel> getSectionLabels() {
        return this.sectionLabels;
    }

    @Override
    public void serializeTo(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeInt(this.instructions.size());
        for (Insn insn : this.instructions) {
            insn.serializeTo(buffer);
        }
        buffer.writeInt(this.jumpLabels.size());
        Iterable iterable2 = this.jumpLabels;
        boolean $i$f$sortedBy = false;
        for (JumpLabel jumpLabel : CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JumpLabel it2 = (JumpLabel)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it2.getCode());
                it2 = (JumpLabel)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getCode()));
            }
        })) {
            jumpLabel.serializeTo(buffer);
        }
        buffer.writeInt(this.sectionLabels.size());
        for (SectionLabel sectionLabel : this.sectionLabels) {
            sectionLabel.serializeTo(buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int resolveLabel(int code) {
        void $this$binarySearchBy_u24default$iv;
        List<JumpLabel> list = this.jumpLabels;
        Comparable key$iv = Integer.valueOf(code);
        int fromIndex$iv = 0;
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        void $this$binarySearchBy$iv$iv = $this$binarySearchBy_u24default$iv;
        boolean $i$f$binarySearchBy = false;
        int indexOf = CollectionsKt.binarySearch((List)$this$binarySearchBy$iv$iv, (int)fromIndex$iv, (int)toIndex$iv, (Function1)((Function1)new Function1<JumpLabel, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                this.$key = $key;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @NotNull
            public final Integer invoke(Object it2) {
                JumpLabel it3 = (JumpLabel)it2;
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(it3.getCode()), (Comparable)this.$key);
            }
        }));
        if (!(indexOf >= 0)) {
            boolean bl = false;
            String string = "Label " + code + " was not found.";
            throw new IllegalStateException(string.toString());
        }
        return this.jumpLabels.get(indexOf).getAt();
    }

    @Override
    @NotNull
    public ByteString toBytes() {
        return Serializable.DefaultImpls.toBytes(this);
    }

    @NotNull
    public final List<Insn> component1() {
        return this.instructions;
    }

    @NotNull
    public final List<JumpLabel> component2() {
        return this.jumpLabels;
    }

    @NotNull
    public final List<SectionLabel> component3() {
        return this.sectionLabels;
    }

    @NotNull
    public final CompiledNode copy(@NotNull List<? extends Insn> instructions, @NotNull List<JumpLabel> jumpLabels, @NotNull List<SectionLabel> sectionLabels) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(jumpLabels, (String)"jumpLabels");
        Intrinsics.checkNotNullParameter(sectionLabels, (String)"sectionLabels");
        return new CompiledNode(instructions, jumpLabels, sectionLabels);
    }

    public static /* synthetic */ CompiledNode copy$default(CompiledNode compiledNode, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = compiledNode.instructions;
        }
        if ((n & 2) != 0) {
            list2 = compiledNode.jumpLabels;
        }
        if ((n & 4) != 0) {
            list3 = compiledNode.sectionLabels;
        }
        return compiledNode.copy(list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "CompiledNode(instructions=" + this.instructions + ", jumpLabels=" + this.jumpLabels + ", sectionLabels=" + this.sectionLabels + ")";
    }

    public int hashCode() {
        int result = ((Object)this.instructions).hashCode();
        result = result * 31 + ((Object)this.jumpLabels).hashCode();
        result = result * 31 + ((Object)this.sectionLabels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompiledNode)) {
            return false;
        }
        CompiledNode compiledNode = (CompiledNode)other;
        if (!Intrinsics.areEqual(this.instructions, compiledNode.instructions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.jumpLabels, compiledNode.jumpLabels)) {
            return false;
        }
        return Intrinsics.areEqual(this.sectionLabels, compiledNode.sectionLabels);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledNode$Companion;", "Lcom/github/adriantodt/lin/utils/Deserializer;", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "()V", "deserializeFrom", "buffer", "Lokio/Buffer;", "lin"})
    public static final class Companion
    implements Deserializer<CompiledNode> {
        private Companion() {
        }

        @Override
        @NotNull
        public CompiledNode deserializeFrom(@NotNull Buffer buffer) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            List instructions = new ArrayList();
            int n3 = buffer.readInt();
            int n4 = 0;
            while (n4 < n3) {
                int it2 = n2 = n4++;
                boolean bl = false;
                ((Collection)instructions).add(Insn.Companion.deserializeFrom(buffer));
            }
            List jumpLabels = new ArrayList();
            n4 = buffer.readInt();
            n2 = 0;
            while (n2 < n4) {
                int it3 = n = n2++;
                boolean bl = false;
                ((Collection)jumpLabels).add(JumpLabel.Companion.deserializeFrom(buffer));
            }
            List sectionLabels = new ArrayList();
            n2 = buffer.readInt();
            n = 0;
            while (n < n2) {
                int n5;
                int it4 = n5 = n++;
                boolean bl = false;
                ((Collection)sectionLabels).add(SectionLabel.Companion.deserializeFrom(buffer));
            }
            return new CompiledNode(instructions, jumpLabels, sectionLabels);
        }

        @Override
        @NotNull
        public CompiledNode fromBytes(@NotNull ByteString source) {
            return (CompiledNode)Deserializer.DefaultImpls.fromBytes(this, source);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

