/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm.impl;

import com.github.adriantodt.lin.bytecode.CompiledFunction;
import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledParameter;
import com.github.adriantodt.lin.vm.impl.DefaultExecutionLayer;
import com.github.adriantodt.lin.vm.impl.ExecutionLayer;
import com.github.adriantodt.lin.vm.impl.VMEvents;
import com.github.adriantodt.lin.vm.scope.DefaultMutableScope;
import com.github.adriantodt.lin.vm.types.LAny;
import com.github.adriantodt.lin.vm.types.LFunction;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/adriantodt/lin/vm/impl/FunctionSetupLayer;", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "events", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "function", "Lcom/github/adriantodt/lin/vm/types/LFunction$Compiled;", "thisValue", "Lcom/github/adriantodt/lin/vm/types/LAny;", "arguments", "", "(Lcom/github/adriantodt/lin/vm/impl/VMEvents;Lcom/github/adriantodt/lin/vm/types/LFunction$Compiled;Lcom/github/adriantodt/lin/vm/types/LAny;Ljava/util/List;)V", "argsLeft", "", "body", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "paramsLeft", "Lcom/github/adriantodt/lin/bytecode/CompiledParameter;", "resolvedParamName", "", "scope", "Lcom/github/adriantodt/lin/vm/scope/DefaultMutableScope;", "onReturn", "", "value", "onThrow", "processArguments", "step", "lin"})
public final class FunctionSetupLayer
implements ExecutionLayer {
    @NotNull
    private final VMEvents events;
    @NotNull
    private final LFunction.Compiled function;
    @Nullable
    private final LAny thisValue;
    @NotNull
    private final CompiledNode body;
    @NotNull
    private final DefaultMutableScope scope;
    @NotNull
    private final List<CompiledParameter> paramsLeft;
    @NotNull
    private final List<LAny> argsLeft;
    @Nullable
    private String resolvedParamName;

    public FunctionSetupLayer(@NotNull VMEvents events, @NotNull LFunction.Compiled function, @Nullable LAny thisValue, @NotNull List<? extends LAny> arguments) {
        CompiledNode compiledNode;
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.events = events;
        this.function = function;
        this.thisValue = thisValue;
        CompiledFunction compiledFunction = this.function.getData();
        int parametersId = compiledFunction.component1();
        int bodyId = compiledFunction.component3();
        FunctionSetupLayer functionSetupLayer = this;
        List<CompiledNode> list = this.function.getSource().getNodes();
        boolean bl = false;
        if (bodyId >= 0 && bodyId <= CollectionsKt.getLastIndex(list)) {
            compiledNode = list.get(bodyId);
        } else {
            int n = bodyId;
            FunctionSetupLayer functionSetupLayer2 = functionSetupLayer;
            boolean bl2 = false;
            CompiledNode compiledNode2 = new CompiledNode(CollectionsKt.emptyList(), CollectionsKt.emptyList());
            functionSetupLayer = functionSetupLayer2;
            compiledNode = compiledNode2;
        }
        functionSetupLayer.body = compiledNode;
        this.scope = new DefaultMutableScope(this.function.getRootScope());
        this.paramsLeft = CollectionsKt.toMutableList((Collection)this.function.getSource().getFunctionParameters().get(parametersId));
        this.argsLeft = CollectionsKt.toMutableList((Collection)arguments);
    }

    public /* synthetic */ FunctionSetupLayer(VMEvents vMEvents, LFunction.Compiled compiled, LAny lAny, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            lAny = null;
        }
        this(vMEvents, compiled, lAny, list);
    }

    private final void processArguments() {
        block2: {
            String paramName;
            CompiledParameter parameter;
            while (true) {
                Collection collection = this.paramsLeft;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block2;
                parameter = (CompiledParameter)CollectionsKt.removeFirst(this.paramsLeft);
                LAny value2 = (LAny)CollectionsKt.removeFirstOrNull(this.argsLeft);
                paramName = this.function.getSource().getStringPool().get(parameter.getNameConst());
                if (value2 == null) break;
                this.scope.declareVariable(paramName, true);
                this.scope.set(paramName, value2);
            }
            if (parameter.getDefaultValueNodeId() != -1) {
                CompiledNode paramBody = this.function.getSource().getNodes().get(parameter.getDefaultValueNodeId());
                this.resolvedParamName = paramName;
                this.scope.declareVariable(paramName, true);
                this.events.pushLayer(new DefaultExecutionLayer(this.events, this.scope, this.function.getSource(), paramBody, this.thisValue));
                return;
            }
            String string = "Properly send 'mismatched_args' error downstream.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        this.events.replaceLayer(new DefaultExecutionLayer(this.events, new DefaultMutableScope(this.scope), this.function.getSource(), this.body, this.thisValue));
    }

    @Override
    public void step() {
        this.processArguments();
    }

    @Override
    public void onReturn(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = this.resolvedParamName;
        if (string == null) {
            String string2 = "resolvedParamName should not be null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String paramName = string;
        this.scope.set(paramName, value2);
    }

    @Override
    public void onThrow(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.events.onThrow(value2);
    }
}

