/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm.impl;

import com.github.adriantodt.lin.bytecode.CompiledFunction;
import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledSource;
import com.github.adriantodt.lin.bytecode.insn.ArrayInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.AssignInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryAddOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryDivideOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryInOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryMultiplyOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryNotEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRangeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRemainingOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinarySubtractOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BranchIfInsn;
import com.github.adriantodt.lin.bytecode.insn.BreakInsn;
import com.github.adriantodt.lin.bytecode.insn.CheckNotNullInsn;
import com.github.adriantodt.lin.bytecode.insn.ContinueInsn;
import com.github.adriantodt.lin.bytecode.insn.DeclareVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.DupInsn;
import com.github.adriantodt.lin.bytecode.insn.GetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.GetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.GetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.bytecode.insn.InvokeInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeLocalInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeMemberInsn;
import com.github.adriantodt.lin.bytecode.insn.JumpInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadStringInsn;
import com.github.adriantodt.lin.bytecode.insn.NewArrayInsn;
import com.github.adriantodt.lin.bytecode.insn.NewFunctionInsn;
import com.github.adriantodt.lin.bytecode.insn.NewObjectInsn;
import com.github.adriantodt.lin.bytecode.insn.ObjectInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.PopExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopInsn;
import com.github.adriantodt.lin.bytecode.insn.PopLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushBooleanInsn;
import com.github.adriantodt.lin.bytecode.insn.PushDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.PushExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.PushLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushNullInsn;
import com.github.adriantodt.lin.bytecode.insn.PushScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushThisInsn;
import com.github.adriantodt.lin.bytecode.insn.ReturnInsn;
import com.github.adriantodt.lin.bytecode.insn.SetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.SetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.SetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.ThrowInsn;
import com.github.adriantodt.lin.bytecode.insn.TypeofInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNegativeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNotOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryPositiveOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryTruthOperationInsn;
import com.github.adriantodt.lin.vm.impl.ExecutionLayer;
import com.github.adriantodt.lin.vm.impl.FunctionSetupLayer;
import com.github.adriantodt.lin.vm.impl.VMEvents;
import com.github.adriantodt.lin.vm.scope.DefaultMutableScope;
import com.github.adriantodt.lin.vm.scope.MutableScope;
import com.github.adriantodt.lin.vm.scope.Scope;
import com.github.adriantodt.lin.vm.types.LAny;
import com.github.adriantodt.lin.vm.types.LArray;
import com.github.adriantodt.lin.vm.types.LDecimal;
import com.github.adriantodt.lin.vm.types.LFalse;
import com.github.adriantodt.lin.vm.types.LFunction;
import com.github.adriantodt.lin.vm.types.LInteger;
import com.github.adriantodt.lin.vm.types.LNull;
import com.github.adriantodt.lin.vm.types.LNumber;
import com.github.adriantodt.lin.vm.types.LObject;
import com.github.adriantodt.lin.vm.types.LString;
import com.github.adriantodt.lin.vm.types.LTrue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b6\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003bcdB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0013H\u0002J\b\u0010)\u001a\u00020\u0016H\u0002J\b\u0010*\u001a\u00020\u0016H\u0002J\b\u0010+\u001a\u00020\u0016H\u0002J\u0018\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010.\u001a\u00020\u0016H\u0002J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u00103\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0013H\u0002J\u0018\u00104\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0002J\u0018\u00105\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0013H\u0002J\u0010\u00109\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0013H\u0002J\u0010\u0010:\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0013H\u0002J\b\u0010;\u001a\u00020\u0016H\u0002J\u0010\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u0013H\u0002J\b\u0010>\u001a\u00020\u0016H\u0002J\b\u0010?\u001a\u00020\u0016H\u0002J\b\u0010@\u001a\u00020\u0016H\u0002J\b\u0010A\u001a\u00020\u0016H\u0002J\b\u0010B\u001a\u00020\u0016H\u0002J\b\u0010C\u001a\u00020\u0016H\u0002J\u0010\u0010D\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010E\u001a\u00020\u00162\u0006\u0010F\u001a\u00020\u0013H\u0002J\u0018\u0010G\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u0013H\u0002J\u0010\u0010J\u001a\u00020\u00162\u0006\u0010F\u001a\u00020\u0013H\u0002J\u0018\u0010K\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u00132\u0006\u0010M\u001a\u00020\u0013H\u0002J\b\u0010N\u001a\u00020\u0016H\u0002J\b\u0010O\u001a\u00020\u0016H\u0002J\b\u0010P\u001a\u00020\u0016H\u0002J\b\u0010Q\u001a\u00020\u0016H\u0002J\u0010\u0010R\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010S\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0013H\u0002J\u0010\u0010T\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010U\u001a\u00020\u0016H\u0002J\b\u0010V\u001a\u00020\u0016H\u0002J\b\u0010W\u001a\u00020\u0016H\u0002J\b\u0010X\u001a\u00020\u0016H\u0002J\b\u0010Y\u001a\u00020\u0016H\u0002J\b\u0010Z\u001a\u00020\u0016H\u0002J(\u0010[\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\\\u001a\u00020\u000b2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000b0^H\u0002J\u0010\u0010_\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000bH\u0016J\u0010\u0010`\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000bH\u0016J\b\u0010a\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer;", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "events", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "scope", "Lcom/github/adriantodt/lin/vm/scope/Scope;", "source", "Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "node", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "thisValue", "Lcom/github/adriantodt/lin/vm/types/LAny;", "(Lcom/github/adriantodt/lin/vm/impl/VMEvents;Lcom/github/adriantodt/lin/vm/scope/Scope;Lcom/github/adriantodt/lin/bytecode/CompiledSource;Lcom/github/adriantodt/lin/bytecode/CompiledNode;Lcom/github/adriantodt/lin/vm/types/LAny;)V", "exceptionHandlers", "", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$ExceptionHandler;", "loopHandlers", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$LoopHandler;", "next", "", "stack", "handleArrayInsert", "", "handleAssign", "nameConst", "handleBinaryAddOperation", "handleBinaryComparison", "comparison", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "handleBinaryDivideOperation", "handleBinaryEqualsOperation", "handleBinaryInOperation", "handleBinaryMultiplyOperation", "handleBinaryNotEqualsOperation", "handleBinaryRangeOperation", "handleBinaryRemainingOperation", "handleBinarySubtractOperation", "handleBranchIf", "value", "", "labelCode", "handleBreak", "handleCheckNotNull", "handleContinue", "handleDeclareVariable", "mutable", "handleDup", "handleGetMemberProperty", "handleGetSubscript", "size", "handleGetVariable", "handleInvoke", "handleInvokeLocal", "handleInvokeMember", "handleJump", "handleLoadDecimal", "valueConst", "handleLoadInteger", "handleLoadString", "handleNewArray", "handleNewFunction", "functionId", "handleNewObject", "handleObjectInsert", "handlePop", "handlePopExceptionHandling", "handlePopLoopHandling", "handlePopScope", "handlePushBoolean", "handlePushDecimal", "immediateValue", "handlePushExceptionHandling", "catchLabel", "endLabel", "handlePushInteger", "handlePushLoopHandling", "breakLabel", "continueLabel", "handlePushNull", "handlePushScope", "handlePushThis", "handleReturn", "handleSetMemberProperty", "handleSetSubscript", "handleSetVariable", "handleThrow", "handleTypeof", "handleUnaryNegativeOperation", "handleUnaryNotOperation", "handleUnaryPositiveOperation", "handleUnaryTruthOperation", "invocation", "function", "arguments", "", "onReturn", "onThrow", "step", "Comparison", "ExceptionHandler", "LoopHandler", "lin"})
public final class DefaultExecutionLayer
implements ExecutionLayer {
    @NotNull
    private final VMEvents events;
    @NotNull
    private Scope scope;
    @NotNull
    private final CompiledSource source;
    @NotNull
    private final CompiledNode node;
    @Nullable
    private final LAny thisValue;
    private int next;
    @NotNull
    private final List<LAny> stack;
    @NotNull
    private final List<ExceptionHandler> exceptionHandlers;
    @NotNull
    private final List<LoopHandler> loopHandlers;

    public DefaultExecutionLayer(@NotNull VMEvents events, @NotNull Scope scope, @NotNull CompiledSource source, @NotNull CompiledNode node2, @Nullable LAny thisValue) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        this.events = events;
        this.scope = scope;
        this.source = source;
        this.node = node2;
        this.thisValue = thisValue;
        boolean bl = false;
        this.stack = new ArrayList();
        bl = false;
        this.exceptionHandlers = new ArrayList();
        bl = false;
        this.loopHandlers = new ArrayList();
    }

    public /* synthetic */ DefaultExecutionLayer(VMEvents vMEvents, Scope scope, CompiledSource compiledSource, CompiledNode compiledNode, LAny lAny, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            compiledNode = compiledSource.getNodes().get(0);
        }
        if ((n & 0x10) != 0) {
            lAny = null;
        }
        this(vMEvents, scope, compiledSource, compiledNode, lAny);
    }

    @Override
    public void step() {
        Object object = this;
        int n = ((DefaultExecutionLayer)object).next;
        ((DefaultExecutionLayer)object).next = n + 1;
        Insn insn = (Insn)CollectionsKt.getOrNull(this.node.getInstructions(), (int)n);
        if (insn == null) {
            object = (LAny)CollectionsKt.removeLastOrNull(this.stack);
            this.events.onReturn((LAny)(object == null ? (LAny)LNull.INSTANCE : object));
            return;
        }
        object = insn;
        if (Intrinsics.areEqual((Object)object, (Object)ArrayInsertInsn.INSTANCE)) {
            this.handleArrayInsert();
        } else if (object instanceof AssignInsn) {
            this.handleAssign(((AssignInsn)insn).getNameConst());
        } else if (object instanceof BranchIfInsn) {
            this.handleBranchIf(((BranchIfInsn)insn).getValue(), ((BranchIfInsn)insn).getLabelCode());
        } else if (Intrinsics.areEqual((Object)object, (Object)BreakInsn.INSTANCE)) {
            this.handleBreak();
        } else if (Intrinsics.areEqual((Object)object, (Object)CheckNotNullInsn.INSTANCE)) {
            this.handleCheckNotNull();
        } else if (Intrinsics.areEqual((Object)object, (Object)ContinueInsn.INSTANCE)) {
            this.handleContinue();
        } else if (object instanceof DeclareVariableInsn) {
            this.handleDeclareVariable(((DeclareVariableInsn)insn).getMutable(), ((DeclareVariableInsn)insn).getNameConst());
        } else if (Intrinsics.areEqual((Object)object, (Object)DupInsn.INSTANCE)) {
            this.handleDup();
        } else if (object instanceof GetMemberPropertyInsn) {
            this.handleGetMemberProperty(((GetMemberPropertyInsn)insn).getNameConst());
        } else if (object instanceof GetSubscriptInsn) {
            this.handleGetSubscript(((GetSubscriptInsn)insn).getSize());
        } else if (object instanceof GetVariableInsn) {
            this.handleGetVariable(((GetVariableInsn)insn).getNameConst());
        } else if (object instanceof InvokeInsn) {
            this.handleInvoke(((InvokeInsn)insn).getSize());
        } else if (object instanceof InvokeLocalInsn) {
            this.handleInvokeLocal(((InvokeLocalInsn)insn).getNameConst(), ((InvokeLocalInsn)insn).getSize());
        } else if (object instanceof InvokeMemberInsn) {
            this.handleInvokeMember(((InvokeMemberInsn)insn).getNameConst(), ((InvokeMemberInsn)insn).getSize());
        } else if (object instanceof JumpInsn) {
            this.handleJump(((JumpInsn)insn).getLabelCode());
        } else if (object instanceof LoadDecimalInsn) {
            this.handleLoadDecimal(((LoadDecimalInsn)insn).getValueConst());
        } else if (object instanceof LoadIntegerInsn) {
            this.handleLoadInteger(((LoadIntegerInsn)insn).getValueConst());
        } else if (object instanceof LoadStringInsn) {
            this.handleLoadString(((LoadStringInsn)insn).getValueConst());
        } else if (Intrinsics.areEqual((Object)object, (Object)NewArrayInsn.INSTANCE)) {
            this.handleNewArray();
        } else if (object instanceof NewFunctionInsn) {
            this.handleNewFunction(((NewFunctionInsn)insn).getFunctionId());
        } else if (Intrinsics.areEqual((Object)object, (Object)NewObjectInsn.INSTANCE)) {
            this.handleNewObject();
        } else if (Intrinsics.areEqual((Object)object, (Object)ObjectInsertInsn.INSTANCE)) {
            this.handleObjectInsert();
        } else if (Intrinsics.areEqual((Object)object, (Object)PopExceptionHandlingInsn.INSTANCE)) {
            this.handlePopExceptionHandling();
        } else if (Intrinsics.areEqual((Object)object, (Object)PopInsn.INSTANCE)) {
            this.handlePop();
        } else if (Intrinsics.areEqual((Object)object, (Object)PopLoopHandlingInsn.INSTANCE)) {
            this.handlePopLoopHandling();
        } else if (Intrinsics.areEqual((Object)object, (Object)PopScopeInsn.INSTANCE)) {
            this.handlePopScope();
        } else if (object instanceof PushBooleanInsn) {
            this.handlePushBoolean(((PushBooleanInsn)insn).getValue());
        } else if (object instanceof PushDecimalInsn) {
            this.handlePushDecimal(((PushDecimalInsn)insn).getImmediateValue());
        } else if (object instanceof PushExceptionHandlingInsn) {
            this.handlePushExceptionHandling(((PushExceptionHandlingInsn)insn).getCatchLabel(), ((PushExceptionHandlingInsn)insn).getEndLabel());
        } else if (object instanceof PushIntegerInsn) {
            this.handlePushInteger(((PushIntegerInsn)insn).getImmediateValue());
        } else if (object instanceof PushLoopHandlingInsn) {
            this.handlePushLoopHandling(((PushLoopHandlingInsn)insn).getBreakLabel(), ((PushLoopHandlingInsn)insn).getContinueLabel());
        } else if (Intrinsics.areEqual((Object)object, (Object)PushNullInsn.INSTANCE)) {
            this.handlePushNull();
        } else if (Intrinsics.areEqual((Object)object, (Object)PushScopeInsn.INSTANCE)) {
            this.handlePushScope();
        } else if (Intrinsics.areEqual((Object)object, (Object)PushThisInsn.INSTANCE)) {
            this.handlePushThis();
        } else if (Intrinsics.areEqual((Object)object, (Object)ReturnInsn.INSTANCE)) {
            this.handleReturn();
        } else if (object instanceof SetMemberPropertyInsn) {
            this.handleSetMemberProperty(((SetMemberPropertyInsn)insn).getNameConst());
        } else if (object instanceof SetSubscriptInsn) {
            this.handleSetSubscript(((SetSubscriptInsn)insn).getSize());
        } else if (object instanceof SetVariableInsn) {
            this.handleSetVariable(((SetVariableInsn)insn).getNameConst());
        } else if (Intrinsics.areEqual((Object)object, (Object)ThrowInsn.INSTANCE)) {
            this.handleThrow();
        } else if (Intrinsics.areEqual((Object)object, (Object)TypeofInsn.INSTANCE)) {
            this.handleTypeof();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryAddOperationInsn.INSTANCE)) {
            this.handleBinaryAddOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryDivideOperationInsn.INSTANCE)) {
            this.handleBinaryDivideOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryEqualsOperationInsn.INSTANCE)) {
            this.handleBinaryEqualsOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryGtOperationInsn.INSTANCE)) {
            this.handleBinaryComparison(Comparison.GT);
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryGteOperationInsn.INSTANCE)) {
            this.handleBinaryComparison(Comparison.GTE);
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryInOperationInsn.INSTANCE)) {
            this.handleBinaryInOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryLtOperationInsn.INSTANCE)) {
            this.handleBinaryComparison(Comparison.LT);
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryLteOperationInsn.INSTANCE)) {
            this.handleBinaryComparison(Comparison.LTE);
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryMultiplyOperationInsn.INSTANCE)) {
            this.handleBinaryMultiplyOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryNotEqualsOperationInsn.INSTANCE)) {
            this.handleBinaryNotEqualsOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryRangeOperationInsn.INSTANCE)) {
            this.handleBinaryRangeOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinaryRemainingOperationInsn.INSTANCE)) {
            this.handleBinaryRemainingOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)BinarySubtractOperationInsn.INSTANCE)) {
            this.handleBinarySubtractOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)UnaryNegativeOperationInsn.INSTANCE)) {
            this.handleUnaryNegativeOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)UnaryNotOperationInsn.INSTANCE)) {
            this.handleUnaryNotOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)UnaryPositiveOperationInsn.INSTANCE)) {
            this.handleUnaryPositiveOperation();
        } else if (Intrinsics.areEqual((Object)object, (Object)UnaryTruthOperationInsn.INSTANCE)) {
            this.handleUnaryTruthOperation();
        }
    }

    @Override
    public void onReturn(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.stack.add(value2);
    }

    @Override
    public void onThrow(@NotNull LAny value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ExceptionHandler handler = (ExceptionHandler)CollectionsKt.removeLastOrNull(this.exceptionHandlers);
        if (handler == null) {
            this.events.onThrow(value2);
            return;
        }
        this.next = handler.getJumpOnException();
        this.stack.add(value2);
    }

    private final void handleArrayInsert() {
        LArray lArray;
        LAny value2 = (LAny)CollectionsKt.removeLast(this.stack);
        Object object = CollectionsKt.last(this.stack);
        LArray lArray2 = lArray = object instanceof LArray ? (LArray)object : null;
        if (lArray == null) {
            object = "Value is not an LArray.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        LArray array = lArray;
        array.getValue().add(value2);
    }

    private final void handleAssign(int nameConst) {
        this.scope.set(this.source.getStringPool().get(nameConst), (LAny)CollectionsKt.removeLast(this.stack));
    }

    private final void handleBranchIf(boolean value2, int labelCode) {
        boolean truth = ((LAny)CollectionsKt.removeLast(this.stack)).truth();
        if (truth == value2) {
            this.next = this.node.resolveLabel(labelCode);
        }
    }

    private final void handleBreak() {
        LoopHandler last = (LoopHandler)CollectionsKt.removeLast(this.loopHandlers);
        this.next = last.getJumpOnBreak();
    }

    private final void handleCheckNotNull() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleContinue() {
        LoopHandler last = (LoopHandler)CollectionsKt.removeLast(this.loopHandlers);
        this.next = last.getJumpOnContinue();
    }

    private final void handleDeclareVariable(boolean mutable, int nameConst) {
        MutableScope mutableScope;
        Object object = this.scope;
        MutableScope mutableScope2 = mutableScope = object instanceof MutableScope ? (MutableScope)object : null;
        if (mutableScope == null) {
            object = "Current scope is not mutable";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        MutableScope s = mutableScope;
        s.declareVariable(this.source.getStringPool().get(nameConst), mutable);
    }

    private final void handleDup() {
        this.stack.add((LAny)CollectionsKt.last(this.stack));
    }

    private final void handleGetMemberProperty(int nameConst) {
        LAny target2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny lAny = target2.getMember(this.source.getStringPool().get(nameConst));
        if (lAny == null) {
            String string = "Not yet implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        LAny member = lAny;
        this.stack.add(member);
    }

    private final void handleGetSubscript(int size) {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleGetVariable(int nameConst) {
        this.stack.add(this.scope.get(this.source.getStringPool().get(nameConst)));
    }

    private final void handleInvoke(int size) {
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        boolean bl3 = false;
        int n = 0;
        n = 0;
        int n2 = size;
        while (n < n2) {
            int n3 = n++;
            boolean bl4 = false;
            int n4 = n3;
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl5 = false;
            LAny lAny = (LAny)CollectionsKt.removeLast(this.stack);
            arrayList2.add(lAny);
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny function = (LAny)CollectionsKt.removeLast(this.stack);
        this.invocation(null, function, arguments);
    }

    private final void handleInvokeLocal(int nameConst, int size) {
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<LAny> arrayList = new ArrayList<LAny>(size);
        boolean bl3 = false;
        int n = 0;
        n = 0;
        int n2 = size;
        while (n < n2) {
            int n3 = n++;
            boolean bl4 = false;
            int n4 = n3;
            ArrayList<LAny> arrayList2 = arrayList;
            boolean bl5 = false;
            LAny lAny = (LAny)CollectionsKt.removeLast(this.stack);
            arrayList2.add(lAny);
        }
        List arguments = CollectionsKt.reversed((Iterable)arrayList);
        LAny function = this.scope.get(this.source.getStringPool().get(nameConst));
        this.invocation(null, function, arguments);
    }

    private final void handleInvokeMember(int nameConst, int size) {
        boolean bl = false;
        boolean bl2 = false;
        Object object = new ArrayList<LAny>(size);
        boolean bl3 = false;
        int n = 0;
        n = 0;
        int n2 = size;
        while (n < n2) {
            int n3 = n++;
            boolean bl4 = false;
            int n4 = n3;
            ArrayList<LAny> arrayList = object;
            boolean bl5 = false;
            LAny lAny = (LAny)CollectionsKt.removeLast(this.stack);
            arrayList.add(lAny);
        }
        List arguments = CollectionsKt.reversed((Iterable)((List)object));
        LAny parent = (LAny)CollectionsKt.removeLast(this.stack);
        object = parent.getMember(this.source.getStringPool().get(nameConst));
        Object function = object == null ? (LAny)LNull.INSTANCE : object;
        this.invocation(parent, (LAny)function, arguments);
    }

    private final void handleJump(int labelCode) {
        this.next = this.node.resolveLabel(labelCode);
    }

    private final void handleLoadDecimal(int valueConst) {
        DoubleCompanionObject doubleCompanionObject = DoubleCompanionObject.INSTANCE;
        long l = ((Number)this.source.getLongPool().get(valueConst)).longValue();
        boolean bl = false;
        this.stack.add(new LDecimal(Double.longBitsToDouble(l)));
    }

    private final void handleLoadInteger(int valueConst) {
        this.stack.add(new LInteger(((Number)this.source.getLongPool().get(valueConst)).longValue()));
    }

    private final void handleLoadString(int valueConst) {
        this.stack.add(new LString(this.source.getStringPool().get(valueConst)));
    }

    private final void handleNewArray() {
        this.stack.add(new LArray(null, 1, null));
    }

    private final void handleNewFunction(int functionId) {
        CompiledFunction functionData = this.source.getFunctions().get(functionId);
        String functionName = functionData.getNameConst() != -1 ? this.source.getStringPool().get(functionData.getNameConst()) : null;
        this.stack.add(new LFunction.Compiled(functionName, this.source, functionData, this.scope));
    }

    private final void handleNewObject() {
        this.stack.add(new LObject(null, 1, null));
    }

    private final void handleObjectInsert() {
        Object object;
        LAny value2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny key = (LAny)CollectionsKt.removeLast(this.stack);
        Object object2 = CollectionsKt.last(this.stack);
        Object object3 = object = object2 instanceof LObject ? (LObject)object2 : null;
        if (object == null) {
            object2 = "Value is not an LObject.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        LObject obj = object;
        object = obj.getValue();
        boolean bl = false;
        object.put(key, value2);
    }

    private final void handlePopExceptionHandling() {
        CollectionsKt.removeLast(this.exceptionHandlers);
    }

    private final void handlePop() {
        CollectionsKt.removeLast(this.stack);
    }

    private final void handlePopLoopHandling() {
        CollectionsKt.removeLast(this.loopHandlers);
    }

    private final void handlePopScope() {
        Scope scope = this.scope.getParent();
        if (scope == null) {
            String string = "Can't pop root scope.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.scope = scope;
    }

    private final void handlePushBoolean(boolean value2) {
        this.stack.add(value2 ? (LAny)LTrue.INSTANCE : (LAny)LFalse.INSTANCE);
    }

    private final void handlePushDecimal(int immediateValue) {
        this.stack.add(new LDecimal(immediateValue));
    }

    private final void handlePushExceptionHandling(int catchLabel, int endLabel) {
        this.exceptionHandlers.add(new ExceptionHandler(this.stack.size(), this.node.resolveLabel(catchLabel), this.node.resolveLabel(endLabel)));
    }

    private final void handlePushInteger(int immediateValue) {
        this.stack.add(new LInteger(immediateValue));
    }

    private final void handlePushLoopHandling(int breakLabel, int continueLabel) {
        this.loopHandlers.add(new LoopHandler(this.stack.size(), this.node.resolveLabel(breakLabel), this.node.resolveLabel(continueLabel)));
    }

    private final void handlePushNull() {
        this.stack.add(LNull.INSTANCE);
    }

    private final void handlePushScope() {
        this.scope = new DefaultMutableScope(this.scope);
    }

    private final void handlePushThis() {
        LAny lAny = this.thisValue;
        if (lAny == null) {
            String string = "There's no 'this' defined.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.stack.add(lAny);
    }

    private final void handleReturn() {
        this.events.onReturn((LAny)CollectionsKt.removeLast(this.stack));
    }

    private final void handleSetMemberProperty(int nameConst) {
        Object object;
        LAny value2 = (LAny)CollectionsKt.removeLast(this.stack);
        Object object2 = CollectionsKt.removeLast(this.stack);
        Object object3 = object = object2 instanceof LObject ? (LObject)object2 : null;
        if (object == null) {
            object2 = "Not yet implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + (String)object2);
        }
        LObject parent = object;
        object = parent.getValue();
        object2 = new LString(this.source.getStringPool().get(nameConst));
        boolean bl = false;
        object.put(object2, value2);
    }

    private final void handleSetSubscript(int size) {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleSetVariable(int nameConst) {
        this.scope.set(this.source.getStringPool().get(nameConst), (LAny)CollectionsKt.removeLast(this.stack));
    }

    private final void handleThrow() {
        this.events.onThrow((LAny)CollectionsKt.removeLast(this.stack));
    }

    private final void handleTypeof() {
        this.stack.add(new LString(((LAny)CollectionsKt.removeLast(this.stack)).getLinType()));
    }

    private final void handleBinaryAddOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (left instanceof LString || right2 instanceof LString) {
            this.stack.add(new LString("" + left + right2));
            return;
        }
        if (left instanceof LArray && right2 instanceof LArray) {
            this.stack.add(new LArray(CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)((LArray)left).getValue(), (Iterable)((LArray)right2).getValue()))));
            return;
        }
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).plus((LNumber)right2));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinaryDivideOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).div((LNumber)right2));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinaryEqualsOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        this.stack.add(LAny.Companion.ofBoolean(Intrinsics.areEqual((Object)right2, (Object)left)));
    }

    private final void handleBinaryMultiplyOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (left instanceof LString && right2 instanceof LInteger) {
            this.stack.add(new LString(StringsKt.repeat((CharSequence)((LString)left).getValue(), (int)((int)((LInteger)right2).getValue()))));
        }
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).times((LNumber)right2));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinaryNotEqualsOperation() {
        LAny left;
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        this.stack.add(LAny.Companion.ofBoolean(!Intrinsics.areEqual((Object)right2, (Object)(left = (LAny)CollectionsKt.removeLast(this.stack)))));
    }

    private final void handleBinaryRangeOperation() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinaryRemainingOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).rem((LNumber)right2));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinarySubtractOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(((LNumber)left).minus((LNumber)right2));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinaryComparison(Comparison comparison) {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (left instanceof LString && right2 instanceof LString) {
            this.stack.add(LAny.Companion.ofBoolean(comparison.toBoolean(((LString)left).getValue().compareTo(((LString)right2).getValue()))));
            return;
        }
        if (left instanceof LNumber && right2 instanceof LNumber) {
            this.stack.add(LAny.Companion.ofBoolean(comparison.toBoolean(((LNumber)left).compareTo((LNumber)right2))));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleBinaryInOperation() {
        LAny right2 = (LAny)CollectionsKt.removeLast(this.stack);
        LAny left = (LAny)CollectionsKt.removeLast(this.stack);
        if (right2 instanceof LArray) {
            this.stack.add(LAny.Companion.ofBoolean(((LArray)right2).getValue().contains(left)));
            return;
        }
        if (right2 instanceof LObject) {
            Map<LAny, LAny> map = ((LObject)right2).getValue();
            boolean bl = false;
            Map<LAny, LAny> map2 = map;
            boolean bl2 = false;
            this.stack.add(LAny.Companion.ofBoolean(map2.containsKey(left)));
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleUnaryNegativeOperation() {
        LAny target2 = (LAny)CollectionsKt.removeLast(this.stack);
        if (target2 instanceof LNumber) {
            this.stack.add(((LNumber)target2).unaryMinus());
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleUnaryNotOperation() {
        this.stack.add(LAny.Companion.ofBoolean(!((LAny)CollectionsKt.removeLast(this.stack)).truth()));
    }

    private final void handleUnaryPositiveOperation() {
        LAny target2 = (LAny)CollectionsKt.removeLast(this.stack);
        if (target2 instanceof LNumber) {
            this.stack.add(((LNumber)target2).unaryPlus());
            return;
        }
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void handleUnaryTruthOperation() {
        this.stack.add(LAny.Companion.ofBoolean(((LAny)CollectionsKt.removeLast(this.stack)).truth()));
    }

    private final void invocation(LAny thisValue, LAny function, List<? extends LAny> arguments) {
        if (!(function instanceof LFunction)) {
            throw new IllegalStateException("Can't invoke function for type '" + function.getLinType() + "'");
        }
        if (function instanceof LFunction.Native) {
            this.stack.add((LAny)((LFunction.Native)function).getNativeBlock().invoke(arguments));
            return;
        }
        if (!(function instanceof LFunction.Compiled)) {
            throw new AssertionError((Object)"Impossible.");
        }
        FunctionSetupLayer layer = new FunctionSetupLayer(this.events, (LFunction.Compiled)function, thisValue, arguments);
        this.events.pushLayer(layer);
        layer.step();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$ExceptionHandler;", "", "keepOnStack", "", "jumpOnException", "jumpOnEnd", "(III)V", "getJumpOnEnd", "()I", "getJumpOnException", "getKeepOnStack", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "lin"})
    public static final class ExceptionHandler {
        private final int keepOnStack;
        private final int jumpOnException;
        private final int jumpOnEnd;

        public ExceptionHandler(int keepOnStack, int jumpOnException, int jumpOnEnd) {
            this.keepOnStack = keepOnStack;
            this.jumpOnException = jumpOnException;
            this.jumpOnEnd = jumpOnEnd;
        }

        public final int getKeepOnStack() {
            return this.keepOnStack;
        }

        public final int getJumpOnException() {
            return this.jumpOnException;
        }

        public final int getJumpOnEnd() {
            return this.jumpOnEnd;
        }

        public final int component1() {
            return this.keepOnStack;
        }

        public final int component2() {
            return this.jumpOnException;
        }

        public final int component3() {
            return this.jumpOnEnd;
        }

        @NotNull
        public final ExceptionHandler copy(int keepOnStack, int jumpOnException, int jumpOnEnd) {
            return new ExceptionHandler(keepOnStack, jumpOnException, jumpOnEnd);
        }

        public static /* synthetic */ ExceptionHandler copy$default(ExceptionHandler exceptionHandler, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = exceptionHandler.keepOnStack;
            }
            if ((n4 & 2) != 0) {
                n2 = exceptionHandler.jumpOnException;
            }
            if ((n4 & 4) != 0) {
                n3 = exceptionHandler.jumpOnEnd;
            }
            return exceptionHandler.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ExceptionHandler(keepOnStack=" + this.keepOnStack + ", jumpOnException=" + this.jumpOnException + ", jumpOnEnd=" + this.jumpOnEnd + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.keepOnStack);
            result = result * 31 + Integer.hashCode(this.jumpOnException);
            result = result * 31 + Integer.hashCode(this.jumpOnEnd);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExceptionHandler)) {
                return false;
            }
            ExceptionHandler exceptionHandler = (ExceptionHandler)other;
            if (this.keepOnStack != exceptionHandler.keepOnStack) {
                return false;
            }
            if (this.jumpOnException != exceptionHandler.jumpOnException) {
                return false;
            }
            return this.jumpOnEnd == exceptionHandler.jumpOnEnd;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$LoopHandler;", "", "keepOnStack", "", "jumpOnBreak", "jumpOnContinue", "(III)V", "getJumpOnBreak", "()I", "getJumpOnContinue", "getKeepOnStack", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "lin"})
    public static final class LoopHandler {
        private final int keepOnStack;
        private final int jumpOnBreak;
        private final int jumpOnContinue;

        public LoopHandler(int keepOnStack, int jumpOnBreak, int jumpOnContinue) {
            this.keepOnStack = keepOnStack;
            this.jumpOnBreak = jumpOnBreak;
            this.jumpOnContinue = jumpOnContinue;
        }

        public final int getKeepOnStack() {
            return this.keepOnStack;
        }

        public final int getJumpOnBreak() {
            return this.jumpOnBreak;
        }

        public final int getJumpOnContinue() {
            return this.jumpOnContinue;
        }

        public final int component1() {
            return this.keepOnStack;
        }

        public final int component2() {
            return this.jumpOnBreak;
        }

        public final int component3() {
            return this.jumpOnContinue;
        }

        @NotNull
        public final LoopHandler copy(int keepOnStack, int jumpOnBreak, int jumpOnContinue) {
            return new LoopHandler(keepOnStack, jumpOnBreak, jumpOnContinue);
        }

        public static /* synthetic */ LoopHandler copy$default(LoopHandler loopHandler, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = loopHandler.keepOnStack;
            }
            if ((n4 & 2) != 0) {
                n2 = loopHandler.jumpOnBreak;
            }
            if ((n4 & 4) != 0) {
                n3 = loopHandler.jumpOnContinue;
            }
            return loopHandler.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "LoopHandler(keepOnStack=" + this.keepOnStack + ", jumpOnBreak=" + this.jumpOnBreak + ", jumpOnContinue=" + this.jumpOnContinue + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.keepOnStack);
            result = result * 31 + Integer.hashCode(this.jumpOnBreak);
            result = result * 31 + Integer.hashCode(this.jumpOnContinue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopHandler)) {
                return false;
            }
            LoopHandler loopHandler = (LoopHandler)other;
            if (this.keepOnStack != loopHandler.keepOnStack) {
                return false;
            }
            if (this.jumpOnBreak != loopHandler.jumpOnBreak) {
                return false;
            }
            return this.jumpOnContinue == loopHandler.jumpOnContinue;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "", "(Ljava/lang/String;I)V", "toBoolean", "", "i", "", "GT", "GTE", "LT", "LTE", "lin"})
    public static final abstract class Comparison
    extends Enum<Comparison> {
        public static final /* enum */ Comparison GT = new GT("GT", 0);
        public static final /* enum */ Comparison GTE = new GTE("GTE", 1);
        public static final /* enum */ Comparison LT = new LT("LT", 2);
        public static final /* enum */ Comparison LTE = new LTE("LTE", 3);
        private static final /* synthetic */ Comparison[] $VALUES;

        private Comparison() {
        }

        public abstract boolean toBoolean(int var1);

        public static Comparison[] values() {
            return (Comparison[])$VALUES.clone();
        }

        public static Comparison valueOf(String value2) {
            return Enum.valueOf(Comparison.class, value2);
        }

        public /* synthetic */ Comparison(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = comparisonArray = new Comparison[]{Comparison.GT, Comparison.GTE, Comparison.LT, Comparison.LTE};
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$GT;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class GT
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            GT() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i > 0;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$GTE;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class GTE
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            GTE() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i >= 0;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$LT;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class LT
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            LT() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i < 0;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison$LTE;", "Lcom/github/adriantodt/lin/vm/impl/DefaultExecutionLayer$Comparison;", "toBoolean", "", "i", "", "lin"})
        static final class LTE
        extends Comparison {
            /*
             * WARNING - void declaration
             */
            LTE() {
                void var1_1;
            }

            @Override
            public boolean toBoolean(int i) {
                return i <= 0;
            }
        }
    }
}

