/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.vm;

import com.github.adriantodt.lin.bytecode.CompiledSource;
import com.github.adriantodt.lin.vm.LAnyException;
import com.github.adriantodt.lin.vm.impl.DefaultExecutionLayer;
import com.github.adriantodt.lin.vm.impl.ExecutionLayer;
import com.github.adriantodt.lin.vm.impl.VMEvents;
import com.github.adriantodt.lin.vm.scope.DefaultMutableScope;
import com.github.adriantodt.lin.vm.scope.Scope;
import com.github.adriantodt.lin.vm.types.LAny;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000b\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine;", "", "scope", "Lcom/github/adriantodt/lin/vm/scope/Scope;", "source", "Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "(Lcom/github/adriantodt/lin/vm/scope/Scope;Lcom/github/adriantodt/lin/bytecode/CompiledSource;)V", "currentLayer", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "layerStack", "", "result", "Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult;", "hasNextStep", "", "Lcom/github/adriantodt/lin/vm/types/LAny;", "run", "step", "", "Events", "VMResult", "lin"})
public final class LinVirtualMachine {
    @NotNull
    private final List<ExecutionLayer> layerStack;
    @NotNull
    private ExecutionLayer currentLayer;
    @Nullable
    private VMResult result;

    public LinVirtualMachine(@NotNull Scope scope, @NotNull CompiledSource source) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean bl = false;
        this.layerStack = new ArrayList();
        this.currentLayer = new DefaultExecutionLayer(new Events(), new DefaultMutableScope(scope), source, null, null, 24, null);
    }

    @NotNull
    public final LAny run() {
        while (this.hasNextStep()) {
            this.step();
        }
        return this.result();
    }

    public final boolean hasNextStep() {
        return this.result == null;
    }

    public final void step() {
        this.currentLayer.step();
    }

    @NotNull
    public final LAny result() {
        VMResult r = this.result;
        if (r instanceof VMResult.Returned) {
            return ((VMResult.Returned)r).getValue();
        }
        if (r instanceof VMResult.Thrown) {
            throw new LAnyException(((VMResult.Thrown)r).getValue());
        }
        if (r == null) {
            throw new RuntimeException("Execution not finished");
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult;", "", "()V", "Returned", "Thrown", "Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult$Returned;", "Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult$Thrown;", "lin"})
    private static abstract class VMResult {
        private VMResult() {
        }

        public /* synthetic */ VMResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult$Returned;", "Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult;", "value", "Lcom/github/adriantodt/lin/vm/types/LAny;", "(Lcom/github/adriantodt/lin/vm/types/LAny;)V", "getValue", "()Lcom/github/adriantodt/lin/vm/types/LAny;", "lin"})
        public static final class Returned
        extends VMResult {
            @NotNull
            private final LAny value;

            public Returned(@NotNull LAny value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                super(null);
                this.value = value2;
            }

            @NotNull
            public final LAny getValue() {
                return this.value;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult$Thrown;", "Lcom/github/adriantodt/lin/vm/LinVirtualMachine$VMResult;", "value", "Lcom/github/adriantodt/lin/vm/types/LAny;", "(Lcom/github/adriantodt/lin/vm/types/LAny;)V", "getValue", "()Lcom/github/adriantodt/lin/vm/types/LAny;", "lin"})
        public static final class Thrown
        extends VMResult {
            @NotNull
            private final LAny value;

            public Thrown(@NotNull LAny value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                super(null);
                this.value = value2;
            }

            @NotNull
            public final LAny getValue() {
                return this.value;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/github/adriantodt/lin/vm/LinVirtualMachine$Events;", "Lcom/github/adriantodt/lin/vm/impl/VMEvents;", "(Lcom/github/adriantodt/lin/vm/LinVirtualMachine;)V", "onReturn", "", "value", "Lcom/github/adriantodt/lin/vm/types/LAny;", "onThrow", "pushLayer", "layer", "Lcom/github/adriantodt/lin/vm/impl/ExecutionLayer;", "replaceLayer", "lin"})
    private final class Events
    implements VMEvents {
        public Events() {
            Intrinsics.checkNotNullParameter((Object)LinVirtualMachine.this, (String)"this$0");
        }

        @Override
        public void pushLayer(@NotNull ExecutionLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            LinVirtualMachine linVirtualMachine = LinVirtualMachine.this;
            Collection collection = linVirtualMachine.layerStack;
            ExecutionLayer executionLayer = LinVirtualMachine.this.currentLayer;
            boolean bl = false;
            collection.add(executionLayer);
            LinVirtualMachine.this.currentLayer = layer;
        }

        @Override
        public void replaceLayer(@NotNull ExecutionLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            LinVirtualMachine.this.currentLayer = layer;
        }

        @Override
        public void onReturn(@NotNull LAny value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ExecutionLayer layer = (ExecutionLayer)CollectionsKt.removeLastOrNull((List)LinVirtualMachine.this.layerStack);
            if (layer == null) {
                LinVirtualMachine.this.result = new VMResult.Returned(value2);
                return;
            }
            LinVirtualMachine.this.currentLayer = layer;
            layer.onReturn(value2);
        }

        @Override
        public void onThrow(@NotNull LAny value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ExecutionLayer layer = (ExecutionLayer)CollectionsKt.removeLastOrNull((List)LinVirtualMachine.this.layerStack);
            if (layer == null) {
                LinVirtualMachine.this.result = new VMResult.Thrown(value2);
                return;
            }
            LinVirtualMachine.this.currentLayer = layer;
            layer.onThrow(value2);
        }
    }
}

