/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.lexer;

import com.github.adriantodt.lin.lexer.TokenType;
import com.github.adriantodt.tartar.api.lexer.LexerContext;
import com.github.adriantodt.tartar.api.parser.SyntaxException;
import com.github.adriantodt.tartar.api.parser.Token;
import com.github.adriantodt.tartar.extensions.LexerContextKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001f\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u001a*\u0010\b\u001a\u00020\t*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u00022\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"readLinIdentifier", "", "Lcom/github/adriantodt/tartar/api/lexer/LexerContext;", "firstChar", "", "(Lcom/github/adriantodt/tartar/api/lexer/LexerContext;Ljava/lang/Character;)Ljava/lang/String;", "readLinString", "delimiter", "readLinTemplateString", "", "Lcom/github/adriantodt/tartar/api/parser/Token;", "Lcom/github/adriantodt/lin/lexer/TokenType;", "Lcom/github/adriantodt/lin/lexer/LinToken;", "delim", "raw", "", "lin"})
public final class LinLexerUtilsKt {
    @NotNull
    public static final String readLinIdentifier(@NotNull LexerContext<?> $this$readLinIdentifier, @Nullable Character firstChar) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$readLinIdentifier, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        Object object = firstChar;
        if (object != null) {
            Character c = object;
            bl = false;
            boolean bl2 = false;
            char p0 = c.charValue();
            boolean bl3 = false;
            buf.append(p0);
        }
        while ($this$readLinIdentifier.hasNext()) {
            char cc;
            char c = cc = $this$readLinIdentifier.peek();
            bl = false;
            if (!Character.isLetterOrDigit(c) && cc != '_' && cc != '@') break;
            buf.append(cc);
            $this$readLinIdentifier.next();
        }
        object = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buf.toString()");
        return object;
    }

    public static /* synthetic */ String readLinIdentifier$default(LexerContext lexerContext, Character c, int n, Object object) {
        if ((n & 1) != 0) {
            c = null;
        }
        return LinLexerUtilsKt.readLinIdentifier(lexerContext, c);
    }

    @NotNull
    public static final String readLinString(@NotNull LexerContext<?> $this$readLinString, char delimiter) {
        Intrinsics.checkNotNullParameter($this$readLinString, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        boolean eol = false;
        while ($this$readLinString.hasNext()) {
            char c = $this$readLinString.peek();
            if (c == delimiter) {
                $this$readLinString.next();
                eol = true;
                break;
            }
            if (c == '\\') {
                $this$readLinString.next();
                if (!$this$readLinString.hasNext()) break;
                char escapingChar = $this$readLinString.next();
                if (escapingChar == 'n') {
                    buf.append('\n');
                    continue;
                }
                if (escapingChar == 'r') {
                    buf.append('\r');
                    continue;
                }
                if (escapingChar == 'b') {
                    buf.append('\b');
                    continue;
                }
                if (escapingChar == 't') {
                    buf.append('\t');
                    continue;
                }
                if (escapingChar == '\'') {
                    buf.append('\'');
                    continue;
                }
                if (escapingChar == '\"') {
                    buf.append('\"');
                    continue;
                }
                if (escapingChar == '\\') {
                    buf.append('\\');
                    continue;
                }
                if (escapingChar == 'u') {
                    String u = $this$readLinString.nextString(4);
                    if (u.length() != 4) break;
                    String string = u;
                    int n = 16;
                    boolean bl = false;
                    buf.append((char)Integer.parseInt(string, CharsKt.checkRadix((int)n)));
                    continue;
                }
                throw new SyntaxException("Unknown escaping '\\" + escapingChar + "'", LexerContextKt.section$default($this$readLinString, (int)2, (int)0, (int)2, null));
            }
            $this$readLinString.next();
            buf.append(c);
        }
        if (!eol) {
            throw new IllegalStateException("Unterminated String");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    public static final void readLinTemplateString(@NotNull LexerContext<Token<TokenType>> $this$readLinTemplateString, @NotNull String delim, boolean raw) {
        Intrinsics.checkNotNullParameter($this$readLinTemplateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delim, (String)"delim");
        StringBuilder buf = new StringBuilder();
        boolean eol = false;
        while ($this$readLinTemplateString.hasNext()) {
            char c = $this$readLinTemplateString.peek();
            if (c == '$') {
                $this$readLinTemplateString.next();
                if ($this$readLinTemplateString.peek() == '{') {
                    $this$readLinTemplateString.next();
                    String string = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.STRING), (String)string, (int)0, (int)4, null));
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.PLUS), (int)0, (int)2, null));
                    StringsKt.clear((StringBuilder)buf);
                    int braces = 0;
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.L_PAREN), (int)0, (int)2, null));
                    while ($this$readLinTemplateString.hasNext()) {
                        char cc = $this$readLinTemplateString.peek();
                        if (cc == '}') {
                            if (braces == 0) {
                                $this$readLinTemplateString.next();
                                break;
                            }
                            int n = braces;
                            braces = n + -1;
                        } else if (cc == '{') {
                            int n = braces;
                            braces = n + 1;
                        }
                        Iterable $this$forEach$iv = $this$readLinTemplateString.parseOnce();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Token p0 = (Token)element$iv;
                            boolean bl = false;
                            $this$readLinTemplateString.process((Object)p0);
                        }
                    }
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.R_PAREN), (int)0, (int)2, null));
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.PLUS), (int)0, (int)2, null));
                    continue;
                }
                char c2 = $this$readLinTemplateString.peek();
                boolean cc = false;
                if (Character.isLetter(c2)) {
                    String string = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.STRING), (String)string, (int)0, (int)4, null));
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.PLUS), (int)0, (int)2, null));
                    StringsKt.clear((StringBuilder)buf);
                    buf.append($this$readLinTemplateString.next());
                    while ($this$readLinTemplateString.hasNext()) {
                        char c3 = $this$readLinTemplateString.peek();
                        cc = false;
                        if (!Character.isLetterOrDigit(c3)) break;
                        buf.append($this$readLinTemplateString.next());
                    }
                    String string2 = buf.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buf.toString()");
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.IDENTIFIER), (String)string2, (int)0, (int)4, null));
                    StringsKt.clear((StringBuilder)buf);
                    $this$readLinTemplateString.process((Object)LexerContextKt.makeToken$default($this$readLinTemplateString, (Object)((Object)TokenType.PLUS), (int)0, (int)2, null));
                    continue;
                }
                buf.append($this$readLinTemplateString.next());
                continue;
            }
            if (c == '\\' && raw) {
                $this$readLinTemplateString.next();
                if (!$this$readLinTemplateString.hasNext()) break;
                char c4 = $this$readLinTemplateString.next();
                if (c4 == 'n') {
                    buf.append('\n');
                    continue;
                }
                if (c4 == 'r') {
                    buf.append('\r');
                    continue;
                }
                if (c4 == 'b') {
                    buf.append('\b');
                    continue;
                }
                if (c4 == 't') {
                    buf.append('\t');
                    continue;
                }
                if (c4 == '\'') {
                    buf.append('\'');
                    continue;
                }
                if (c4 == '\"') {
                    buf.append('\"');
                    continue;
                }
                if (c4 == '\\') {
                    buf.append('\\');
                    continue;
                }
                if (c4 == 'u') {
                    Character c5;
                    String u = $this$readLinTemplateString.peekString(4);
                    if (u.length() != 4) {
                        throw new IllegalStateException("File terminated before escaping");
                    }
                    Integer n = StringsKt.toIntOrNull((String)u, (int)16);
                    Character c6 = c5 = n == null ? null : Character.valueOf((char)n.intValue());
                    if (c5 == null) {
                        throw new IllegalStateException("Illegal unicode escaping");
                    }
                    buf.append(c5.charValue());
                    $this$readLinTemplateString.nextString(4);
                    continue;
                }
                throw new IllegalStateException("Unknown escaping");
            }
            if (Intrinsics.areEqual((Object)$this$readLinTemplateString.peekString(delim.length()), (Object)delim)) {
                $this$readLinTemplateString.nextString(delim.length());
                eol = true;
                break;
            }
            $this$readLinTemplateString.next();
            buf.append(c);
        }
        if (!eol) {
            throw new IllegalStateException("Unterminated string");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        $this$readLinTemplateString.process((Object)LexerContextKt.makeToken($this$readLinTemplateString, (Object)((Object)TokenType.STRING), (String)string, (int)2));
    }
}

