/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.compiler;

import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledParameter;
import com.github.adriantodt.lin.bytecode.Label;
import com.github.adriantodt.lin.bytecode.insn.ArrayInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.AssignInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryAddOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryDivideOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryGteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryInOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLtOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryLteOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryMultiplyOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryNotEqualsOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRangeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinaryRemainingOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BinarySubtractOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.BranchIfInsn;
import com.github.adriantodt.lin.bytecode.insn.BreakInsn;
import com.github.adriantodt.lin.bytecode.insn.CheckNotNullInsn;
import com.github.adriantodt.lin.bytecode.insn.ContinueInsn;
import com.github.adriantodt.lin.bytecode.insn.DeclareVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.DupInsn;
import com.github.adriantodt.lin.bytecode.insn.GetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.GetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.GetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.bytecode.insn.InvokeInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeLocalInsn;
import com.github.adriantodt.lin.bytecode.insn.InvokeMemberInsn;
import com.github.adriantodt.lin.bytecode.insn.JumpInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.LoadStringInsn;
import com.github.adriantodt.lin.bytecode.insn.NewArrayInsn;
import com.github.adriantodt.lin.bytecode.insn.NewFunctionInsn;
import com.github.adriantodt.lin.bytecode.insn.NewObjectInsn;
import com.github.adriantodt.lin.bytecode.insn.ObjectInsertInsn;
import com.github.adriantodt.lin.bytecode.insn.PopExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopInsn;
import com.github.adriantodt.lin.bytecode.insn.PopLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PopScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushBooleanInsn;
import com.github.adriantodt.lin.bytecode.insn.PushDecimalInsn;
import com.github.adriantodt.lin.bytecode.insn.PushExceptionHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushIntegerInsn;
import com.github.adriantodt.lin.bytecode.insn.PushLoopHandlingInsn;
import com.github.adriantodt.lin.bytecode.insn.PushNullInsn;
import com.github.adriantodt.lin.bytecode.insn.PushScopeInsn;
import com.github.adriantodt.lin.bytecode.insn.PushThisInsn;
import com.github.adriantodt.lin.bytecode.insn.ReturnInsn;
import com.github.adriantodt.lin.bytecode.insn.SetMemberPropertyInsn;
import com.github.adriantodt.lin.bytecode.insn.SetSubscriptInsn;
import com.github.adriantodt.lin.bytecode.insn.SetVariableInsn;
import com.github.adriantodt.lin.bytecode.insn.ThrowInsn;
import com.github.adriantodt.lin.bytecode.insn.TypeofInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNegativeOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryNotOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryPositiveOperationInsn;
import com.github.adriantodt.lin.bytecode.insn.UnaryTruthOperationInsn;
import com.github.adriantodt.lin.compiler.CompiledSourceBuilder;
import com.github.adriantodt.lin.utils.BinaryOperationType;
import com.github.adriantodt.lin.utils.UnaryOperationType;
import com.github.adriantodt.tartar.api.lexer.Sectional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u0010J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0005J\u0016\u0010)\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\u0010J&\u00101\u001a\u00020\u00102\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u0005J\u0006\u00106\u001a\u00020\u0010J\u0006\u00107\u001a\u00020\u0005J\u0006\u00108\u001a\u00020\u0010J\u0006\u00109\u001a\u00020\u0010J\u0006\u0010:\u001a\u00020\u0010J\u0006\u0010;\u001a\u00020\u0010J\u0006\u0010<\u001a\u00020\u0010J\u000e\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020!J\u000e\u0010?\u001a\u00020\u00102\u0006\u0010>\u001a\u00020@J\u0016\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005J\u000e\u0010D\u001a\u00020\u00102\u0006\u0010>\u001a\u00020EJ\u0016\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005J\u0006\u0010I\u001a\u00020\u0010J\u0006\u0010J\u001a\u00020\u0010J\u000e\u0010K\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u0013J\u0006\u0010L\u001a\u00020\u0010J\u0006\u0010M\u001a\u00020\u0010J\u000e\u0010N\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010O\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010P\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010Q\u001a\u00020\u0010J\u0006\u0010R\u001a\u00020\u0010J\u000e\u0010S\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020TJ*\u0010U\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00052\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00100WH\u0086\b\u00f8\u0001\u0000J*\u0010X\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00100WH\u0086\b\u00f8\u0001\u0000J\u001a\u0010Y\u001a\u00020\u00102\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00100WH\u0086\b\u00f8\u0001\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006["}, d2={"Lcom/github/adriantodt/lin/compiler/CompiledNodeBuilder;", "", "parent", "Lcom/github/adriantodt/lin/compiler/CompiledSourceBuilder;", "nodeId", "", "(Lcom/github/adriantodt/lin/compiler/CompiledSourceBuilder;I)V", "instructions", "", "Lcom/github/adriantodt/lin/bytecode/insn/Insn;", "labels", "Lcom/github/adriantodt/lin/bytecode/Label;", "nextLabelCode", "getNodeId", "()I", "arrayInsertInsn", "", "assignInsn", "name", "", "binaryOperationInsn", "operator", "Lcom/github/adriantodt/lin/utils/BinaryOperationType;", "branchIfFalseInsn", "labelCode", "branchIfTrueInsn", "breakInsn", "build", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "checkNotNullInsn", "continueInsn", "declareVariableInsn", "mutable", "", "dupInsn", "getMemberPropertyInsn", "getSubscriptInsn", "size", "getVariableInsn", "invokeInsn", "invokeLocalInsn", "invokeMemberInsn", "jumpInsn", "markLabel", "code", "markSection", "sectional", "Lcom/github/adriantodt/tartar/api/lexer/Sectional;", "newArrayInsn", "newFunctionInsn", "parameters", "", "Lcom/github/adriantodt/lin/bytecode/CompiledParameter;", "bodyId", "newObjectInsn", "nextLabel", "objectInsertInsn", "popExceptionHandlingInsn", "popInsn", "popLoopHandlingInsn", "popScopeInsn", "pushBooleanInsn", "value", "pushDecimalInsn", "", "pushExceptionHandlingInsn", "catchLabel", "endLabel", "pushIntegerInsn", "", "pushLoopHandlingInsn", "continueLabel", "breakLabel", "pushNullInsn", "pushScopeInsn", "pushStringInsn", "pushThisInsn", "returnInsn", "setMemberPropertyInsn", "setSubscriptInsn", "setVariableInsn", "throwInsn", "typeofInsn", "unaryOperationInsn", "Lcom/github/adriantodt/lin/utils/UnaryOperationType;", "withExceptionHandling", "block", "Lkotlin/Function0;", "withLoopHandling", "withScope", "Companion", "lin"})
public final class CompiledNodeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompiledSourceBuilder parent;
    private final int nodeId;
    @NotNull
    private final List<Insn> instructions;
    @NotNull
    private final List<Label> labels;
    private int nextLabelCode;
    private static final int I24_MAX = 0x7FFFFF;
    private static final int I24_MIN = -8388608;
    @NotNull
    private static final IntRange i24Range = new IntRange(-8388608, 0x7FFFFF);

    public CompiledNodeBuilder(@NotNull CompiledSourceBuilder parent, int nodeId) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.nodeId = nodeId;
        boolean bl = false;
        this.instructions = new ArrayList();
        bl = false;
        this.labels = new ArrayList();
    }

    public final int getNodeId() {
        return this.nodeId;
    }

    public final int nextLabel() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        int n = compiledNodeBuilder.nextLabelCode;
        compiledNodeBuilder.nextLabelCode = n + 1;
        return n;
    }

    public final void newArrayInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        NewArrayInsn newArrayInsn = NewArrayInsn.INSTANCE;
        boolean bl = false;
        collection.add(newArrayInsn);
    }

    public final void arrayInsertInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        ArrayInsertInsn arrayInsertInsn = ArrayInsertInsn.INSTANCE;
        boolean bl = false;
        collection.add(arrayInsertInsn);
    }

    public final void assignInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        AssignInsn assignInsn = new AssignInsn(this.parent.constantId(name));
        boolean bl = false;
        collection.add(assignInsn);
    }

    public final void pushBooleanInsn(boolean value2) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PushBooleanInsn pushBooleanInsn = new PushBooleanInsn(value2);
        boolean bl = false;
        collection.add(pushBooleanInsn);
    }

    public final void pushDecimalInsn(double value2) {
        int n;
        Object object;
        if (value2 % 1.0 == 0.0) {
            object = i24Range;
            int n2 = object.getFirst();
            int n3 = object.getLast();
            n = (int)value2;
            boolean bl = n2 <= n ? n <= n3 : false;
            if (bl) {
                object = this;
                Collection collection = object.instructions;
                PushDecimalInsn pushDecimalInsn = new PushDecimalInsn((int)value2);
                n = 0;
                collection.add(pushDecimalInsn);
                return;
            }
        }
        object = this;
        Collection collection = object.instructions;
        LoadDecimalInsn loadDecimalInsn = new LoadDecimalInsn(this.parent.constantId(value2));
        n = 0;
        collection.add(loadDecimalInsn);
    }

    public final void pushIntegerInsn(long value2) {
        int n;
        Object object;
        if (value2 % 1L == 0L) {
            object = i24Range;
            int n2 = object.getFirst();
            int n3 = object.getLast();
            n = (int)value2;
            boolean bl = n2 <= n ? n <= n3 : false;
            if (bl) {
                object = this;
                Collection collection = object.instructions;
                PushIntegerInsn pushIntegerInsn = new PushIntegerInsn((int)value2);
                n = 0;
                collection.add(pushIntegerInsn);
                return;
            }
        }
        object = this;
        Collection collection = object.instructions;
        LoadIntegerInsn loadIntegerInsn = new LoadIntegerInsn(this.parent.constantId(value2));
        n = 0;
        collection.add(loadIntegerInsn);
    }

    public final void invokeInsn(int size) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        InvokeInsn invokeInsn = new InvokeInsn(size);
        boolean bl = false;
        collection.add(invokeInsn);
    }

    public final void invokeLocalInsn(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        InvokeLocalInsn invokeLocalInsn = new InvokeLocalInsn(this.parent.constantId(name), size);
        boolean bl = false;
        collection.add(invokeLocalInsn);
    }

    public final void invokeMemberInsn(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        InvokeMemberInsn invokeMemberInsn = new InvokeMemberInsn(this.parent.constantId(name), size);
        boolean bl = false;
        collection.add(invokeMemberInsn);
    }

    public final void pushStringInsn(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        LoadStringInsn loadStringInsn = new LoadStringInsn(this.parent.constantId(value2));
        boolean bl = false;
        collection.add(loadStringInsn);
    }

    public final void checkNotNullInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        CheckNotNullInsn checkNotNullInsn = CheckNotNullInsn.INSTANCE;
        boolean bl = false;
        collection.add(checkNotNullInsn);
    }

    public final void returnInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        ReturnInsn returnInsn = ReturnInsn.INSTANCE;
        boolean bl = false;
        collection.add(returnInsn);
    }

    public final void pushThisInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PushThisInsn pushThisInsn = PushThisInsn.INSTANCE;
        boolean bl = false;
        collection.add(pushThisInsn);
    }

    public final void pushNullInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PushNullInsn pushNullInsn = PushNullInsn.INSTANCE;
        boolean bl = false;
        collection.add(pushNullInsn);
    }

    public final void typeofInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        TypeofInsn typeofInsn = TypeofInsn.INSTANCE;
        boolean bl = false;
        collection.add(typeofInsn);
    }

    public final void newObjectInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        NewObjectInsn newObjectInsn = NewObjectInsn.INSTANCE;
        boolean bl = false;
        collection.add(newObjectInsn);
    }

    public final void objectInsertInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        ObjectInsertInsn objectInsertInsn = ObjectInsertInsn.INSTANCE;
        boolean bl = false;
        collection.add(objectInsertInsn);
    }

    public final void breakInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        BreakInsn breakInsn = BreakInsn.INSTANCE;
        boolean bl = false;
        collection.add(breakInsn);
    }

    public final void continueInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        ContinueInsn continueInsn = ContinueInsn.INSTANCE;
        boolean bl = false;
        collection.add(continueInsn);
    }

    public final void throwInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        ThrowInsn throwInsn = ThrowInsn.INSTANCE;
        boolean bl = false;
        collection.add(throwInsn);
    }

    public final void jumpInsn(int labelCode) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        JumpInsn jumpInsn = new JumpInsn(labelCode);
        boolean bl = false;
        collection.add(jumpInsn);
    }

    public final void branchIfFalseInsn(int labelCode) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        BranchIfInsn branchIfInsn = new BranchIfInsn(false, labelCode);
        boolean bl = false;
        collection.add(branchIfInsn);
    }

    public final void branchIfTrueInsn(int labelCode) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        BranchIfInsn branchIfInsn = new BranchIfInsn(true, labelCode);
        boolean bl = false;
        collection.add(branchIfInsn);
    }

    public final void unaryOperationInsn(@NotNull UnaryOperationType operator) {
        Insn insn;
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        Object object = operator;
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                insn = UnaryPositiveOperationInsn.INSTANCE;
                break;
            }
            case 2: {
                insn = UnaryNegativeOperationInsn.INSTANCE;
                break;
            }
            case 3: {
                insn = UnaryNotOperationInsn.INSTANCE;
                break;
            }
            case 4: {
                insn = UnaryTruthOperationInsn.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        object = insn;
        n = 0;
        collection.add(object);
    }

    public final void binaryOperationInsn(@NotNull BinaryOperationType operator) {
        Insn insn;
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        Object object = operator;
        int n = WhenMappings.$EnumSwitchMapping$1[object.ordinal()];
        switch (n) {
            case 1: {
                insn = BinaryAddOperationInsn.INSTANCE;
                break;
            }
            case 2: {
                insn = BinarySubtractOperationInsn.INSTANCE;
                break;
            }
            case 3: {
                insn = BinaryMultiplyOperationInsn.INSTANCE;
                break;
            }
            case 4: {
                insn = BinaryDivideOperationInsn.INSTANCE;
                break;
            }
            case 5: {
                insn = BinaryRemainingOperationInsn.INSTANCE;
                break;
            }
            case 6: {
                insn = BinaryEqualsOperationInsn.INSTANCE;
                break;
            }
            case 7: {
                insn = BinaryNotEqualsOperationInsn.INSTANCE;
                break;
            }
            case 8: {
                insn = BinaryLtOperationInsn.INSTANCE;
                break;
            }
            case 9: {
                insn = BinaryLteOperationInsn.INSTANCE;
                break;
            }
            case 10: {
                insn = BinaryGtOperationInsn.INSTANCE;
                break;
            }
            case 11: {
                insn = BinaryGteOperationInsn.INSTANCE;
                break;
            }
            case 12: {
                insn = BinaryInOperationInsn.INSTANCE;
                break;
            }
            case 13: {
                insn = BinaryRangeOperationInsn.INSTANCE;
                break;
            }
            default: {
                throw new RuntimeException("The operator " + operator + " can't be converted to a instruction and must be de-sugared.");
            }
        }
        object = insn;
        n = 0;
        collection.add(object);
    }

    public final void declareVariableInsn(@NotNull String name, boolean mutable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        DeclareVariableInsn declareVariableInsn = new DeclareVariableInsn(this.parent.constantId(name), mutable);
        boolean bl = false;
        collection.add(declareVariableInsn);
    }

    public final void getVariableInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        GetVariableInsn getVariableInsn = new GetVariableInsn(this.parent.constantId(name));
        boolean bl = false;
        collection.add(getVariableInsn);
    }

    public final void setVariableInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        SetVariableInsn setVariableInsn = new SetVariableInsn(this.parent.constantId(name));
        boolean bl = false;
        collection.add(setVariableInsn);
    }

    public final void getMemberPropertyInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        GetMemberPropertyInsn getMemberPropertyInsn = new GetMemberPropertyInsn(this.parent.constantId(name));
        boolean bl = false;
        collection.add(getMemberPropertyInsn);
    }

    public final void setMemberPropertyInsn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        SetMemberPropertyInsn setMemberPropertyInsn = new SetMemberPropertyInsn(this.parent.constantId(name));
        boolean bl = false;
        collection.add(setMemberPropertyInsn);
    }

    public final void getSubscriptInsn(int size) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        GetSubscriptInsn getSubscriptInsn = new GetSubscriptInsn(size);
        boolean bl = false;
        collection.add(getSubscriptInsn);
    }

    public final void setSubscriptInsn(int size) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        SetSubscriptInsn setSubscriptInsn = new SetSubscriptInsn(size);
        boolean bl = false;
        collection.add(setSubscriptInsn);
    }

    public final void newFunctionInsn(@NotNull List<CompiledParameter> parameters, @Nullable String name, int bodyId) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        NewFunctionInsn newFunctionInsn = new NewFunctionInsn(this.parent.registerFunction(this.parent.registerParameters(parameters), name, bodyId));
        boolean bl = false;
        collection.add(newFunctionInsn);
    }

    public final void dupInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        DupInsn dupInsn = DupInsn.INSTANCE;
        boolean bl = false;
        collection.add(dupInsn);
    }

    public final void popInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PopInsn popInsn = PopInsn.INSTANCE;
        boolean bl = false;
        collection.add(popInsn);
    }

    public final void pushScopeInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PushScopeInsn pushScopeInsn = PushScopeInsn.INSTANCE;
        boolean bl = false;
        collection.add(pushScopeInsn);
    }

    public final void popScopeInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PopScopeInsn popScopeInsn = PopScopeInsn.INSTANCE;
        boolean bl = false;
        collection.add(popScopeInsn);
    }

    public final void pushExceptionHandlingInsn(int catchLabel, int endLabel) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PushExceptionHandlingInsn pushExceptionHandlingInsn = new PushExceptionHandlingInsn(catchLabel, endLabel);
        boolean bl = false;
        collection.add(pushExceptionHandlingInsn);
    }

    public final void popExceptionHandlingInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PopExceptionHandlingInsn popExceptionHandlingInsn = PopExceptionHandlingInsn.INSTANCE;
        boolean bl = false;
        collection.add(popExceptionHandlingInsn);
    }

    public final void pushLoopHandlingInsn(int continueLabel, int breakLabel) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PushLoopHandlingInsn pushLoopHandlingInsn = new PushLoopHandlingInsn(continueLabel, breakLabel);
        boolean bl = false;
        collection.add(pushLoopHandlingInsn);
    }

    public final void popLoopHandlingInsn() {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.instructions;
        PopLoopHandlingInsn popLoopHandlingInsn = PopLoopHandlingInsn.INSTANCE;
        boolean bl = false;
        collection.add(popLoopHandlingInsn);
    }

    public final void markLabel(int code) {
        CompiledNodeBuilder compiledNodeBuilder = this;
        Collection collection = compiledNodeBuilder.labels;
        int n = this.instructions.size();
        Label label = new Label(code, n);
        boolean bl = false;
        collection.add(label);
    }

    public final void markSection(@NotNull Sectional sectional) {
        Intrinsics.checkNotNullParameter((Object)sectional, (String)"sectional");
    }

    public final void withExceptionHandling(int catchLabel, int endLabel, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withExceptionHandling = false;
        this.pushExceptionHandlingInsn(catchLabel, endLabel);
        block.invoke();
        this.popExceptionHandlingInsn();
    }

    public final void withLoopHandling(int continueLabel, int breakLabel, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withLoopHandling = false;
        this.pushLoopHandlingInsn(continueLabel, breakLabel);
        block.invoke();
        this.popLoopHandlingInsn();
    }

    public final void withScope(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withScope = false;
        this.pushScopeInsn();
        block.invoke();
        this.popScopeInsn();
    }

    @NotNull
    public final CompiledNode build() {
        return new CompiledNode(CollectionsKt.toList((Iterable)this.instructions), CollectionsKt.toList((Iterable)this.labels));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/adriantodt/lin/compiler/CompiledNodeBuilder$Companion;", "", "()V", "I24_MAX", "", "I24_MIN", "i24Range", "Lkotlin/ranges/IntRange;", "lin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnaryOperationType.values().length];
            nArray[UnaryOperationType.POSITIVE.ordinal()] = 1;
            nArray[UnaryOperationType.NEGATIVE.ordinal()] = 2;
            nArray[UnaryOperationType.NOT.ordinal()] = 3;
            nArray[UnaryOperationType.TRUTH.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BinaryOperationType.values().length];
            nArray[BinaryOperationType.ADD.ordinal()] = 1;
            nArray[BinaryOperationType.SUBTRACT.ordinal()] = 2;
            nArray[BinaryOperationType.MULTIPLY.ordinal()] = 3;
            nArray[BinaryOperationType.DIVIDE.ordinal()] = 4;
            nArray[BinaryOperationType.REMAINING.ordinal()] = 5;
            nArray[BinaryOperationType.EQUALS.ordinal()] = 6;
            nArray[BinaryOperationType.NOT_EQUALS.ordinal()] = 7;
            nArray[BinaryOperationType.LT.ordinal()] = 8;
            nArray[BinaryOperationType.LTE.ordinal()] = 9;
            nArray[BinaryOperationType.GT.ordinal()] = 10;
            nArray[BinaryOperationType.GTE.ordinal()] = 11;
            nArray[BinaryOperationType.IN.ordinal()] = 12;
            nArray[BinaryOperationType.RANGE.ordinal()] = 13;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

