/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.bytecode;

import com.github.adriantodt.lin.bytecode.CompiledFunction;
import com.github.adriantodt.lin.bytecode.CompiledNode;
import com.github.adriantodt.lin.bytecode.CompiledParameter;
import com.github.adriantodt.lin.utils.Deserializer;
import com.github.adriantodt.lin.utils.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%BQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003J_\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "Lcom/github/adriantodt/lin/utils/Serializable;", "longPool", "", "", "stringPool", "", "functionParameters", "Lcom/github/adriantodt/lin/bytecode/CompiledParameter;", "functions", "Lcom/github/adriantodt/lin/bytecode/CompiledFunction;", "nodes", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getFunctionParameters", "()Ljava/util/List;", "getFunctions", "getLongPool", "getNodes", "getStringPool", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "serializeTo", "", "buffer", "Lokio/Buffer;", "toString", "Companion", "lin"})
public final class CompiledSource
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Long> longPool;
    @NotNull
    private final List<String> stringPool;
    @NotNull
    private final List<List<CompiledParameter>> functionParameters;
    @NotNull
    private final List<CompiledFunction> functions;
    @NotNull
    private final List<CompiledNode> nodes;

    public CompiledSource(@NotNull List<Long> longPool, @NotNull List<String> stringPool, @NotNull List<? extends List<CompiledParameter>> functionParameters, @NotNull List<CompiledFunction> functions, @NotNull List<CompiledNode> nodes) {
        Intrinsics.checkNotNullParameter(longPool, (String)"longPool");
        Intrinsics.checkNotNullParameter(stringPool, (String)"stringPool");
        Intrinsics.checkNotNullParameter(functionParameters, (String)"functionParameters");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.longPool = longPool;
        this.stringPool = stringPool;
        this.functionParameters = functionParameters;
        this.functions = functions;
        this.nodes = nodes;
    }

    @NotNull
    public final List<Long> getLongPool() {
        return this.longPool;
    }

    @NotNull
    public final List<String> getStringPool() {
        return this.stringPool;
    }

    @NotNull
    public final List<List<CompiledParameter>> getFunctionParameters() {
        return this.functionParameters;
    }

    @NotNull
    public final List<CompiledFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final List<CompiledNode> getNodes() {
        return this.nodes;
    }

    @Override
    public void serializeTo(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeInt(this.longPool.size());
        Iterator<Object> iterator = this.longPool.iterator();
        while (iterator.hasNext()) {
            long l = ((Number)iterator.next()).longValue();
            buffer.writeLong(l);
        }
        buffer.writeInt(this.stringPool.size());
        for (String string : this.stringPool) {
            ByteString encoded = ByteString.Companion.encodeUtf8(string);
            buffer.writeInt(encoded.size()).write(encoded);
        }
        buffer.writeInt(this.functionParameters.size());
        for (List list : this.functionParameters) {
            buffer.writeInt(list.size());
            for (CompiledParameter parameter : list) {
                parameter.serializeTo(buffer);
            }
        }
        buffer.writeInt(this.functions.size());
        for (CompiledFunction compiledFunction : this.functions) {
            compiledFunction.serializeTo(buffer);
        }
        buffer.writeInt(this.nodes.size());
        for (CompiledNode compiledNode : this.nodes) {
            compiledNode.serializeTo(buffer);
        }
    }

    @Override
    @NotNull
    public ByteString toBytes() {
        return Serializable.DefaultImpls.toBytes(this);
    }

    @NotNull
    public final List<Long> component1() {
        return this.longPool;
    }

    @NotNull
    public final List<String> component2() {
        return this.stringPool;
    }

    @NotNull
    public final List<List<CompiledParameter>> component3() {
        return this.functionParameters;
    }

    @NotNull
    public final List<CompiledFunction> component4() {
        return this.functions;
    }

    @NotNull
    public final List<CompiledNode> component5() {
        return this.nodes;
    }

    @NotNull
    public final CompiledSource copy(@NotNull List<Long> longPool, @NotNull List<String> stringPool, @NotNull List<? extends List<CompiledParameter>> functionParameters, @NotNull List<CompiledFunction> functions, @NotNull List<CompiledNode> nodes) {
        Intrinsics.checkNotNullParameter(longPool, (String)"longPool");
        Intrinsics.checkNotNullParameter(stringPool, (String)"stringPool");
        Intrinsics.checkNotNullParameter(functionParameters, (String)"functionParameters");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        return new CompiledSource(longPool, stringPool, functionParameters, functions, nodes);
    }

    public static /* synthetic */ CompiledSource copy$default(CompiledSource compiledSource, List list, List list2, List list3, List list4, List list5, int n, Object object) {
        if ((n & 1) != 0) {
            list = compiledSource.longPool;
        }
        if ((n & 2) != 0) {
            list2 = compiledSource.stringPool;
        }
        if ((n & 4) != 0) {
            list3 = compiledSource.functionParameters;
        }
        if ((n & 8) != 0) {
            list4 = compiledSource.functions;
        }
        if ((n & 0x10) != 0) {
            list5 = compiledSource.nodes;
        }
        return compiledSource.copy(list, list2, list3, list4, list5);
    }

    @NotNull
    public String toString() {
        return "CompiledSource(longPool=" + this.longPool + ", stringPool=" + this.stringPool + ", functionParameters=" + this.functionParameters + ", functions=" + this.functions + ", nodes=" + this.nodes + ")";
    }

    public int hashCode() {
        int result = ((Object)this.longPool).hashCode();
        result = result * 31 + ((Object)this.stringPool).hashCode();
        result = result * 31 + ((Object)this.functionParameters).hashCode();
        result = result * 31 + ((Object)this.functions).hashCode();
        result = result * 31 + ((Object)this.nodes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompiledSource)) {
            return false;
        }
        CompiledSource compiledSource = (CompiledSource)other;
        if (!Intrinsics.areEqual(this.longPool, compiledSource.longPool)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stringPool, compiledSource.stringPool)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.functionParameters, compiledSource.functionParameters)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.functions, compiledSource.functions)) {
            return false;
        }
        return Intrinsics.areEqual(this.nodes, compiledSource.nodes);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledSource$Companion;", "Lcom/github/adriantodt/lin/utils/Deserializer;", "Lcom/github/adriantodt/lin/bytecode/CompiledSource;", "()V", "deserializeFrom", "buffer", "Lokio/Buffer;", "lin"})
    public static final class Companion
    implements Deserializer<CompiledSource> {
        private Companion() {
        }

        @Override
        @NotNull
        public CompiledSource deserializeFrom(@NotNull Buffer buffer) {
            int n;
            int n2;
            Collection<CompiledFunction> list;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int n3 = 0;
            List longPool = new ArrayList();
            n3 = buffer.readInt();
            int n4 = 0;
            int n5 = 0;
            n5 = 0;
            int n6 = n3;
            while (n5 < n6) {
                int it = n5++;
                boolean bl2 = false;
                Collection collection = longPool;
                Long l = buffer.readLong();
                boolean bl3 = false;
                collection.add(l);
            }
            n4 = 0;
            List stringPool = new ArrayList();
            n4 = buffer.readInt();
            n5 = 0;
            n6 = 0;
            n6 = 0;
            int n7 = n4;
            while (n6 < n7) {
                int it = n6++;
                boolean bl4 = false;
                int size = buffer.readInt();
                Collection collection = stringPool;
                String string = buffer.readByteString((long)size).utf8();
                bl = false;
                collection.add(string);
            }
            n5 = 0;
            List functionParameters = new ArrayList();
            n5 = buffer.readInt();
            n6 = 0;
            n7 = 0;
            int n8 = n5;
            for (n7 = 0; n7 < n8; ++n7) {
                int it = n7;
                boolean bl5 = false;
                int n9 = 0;
                list = new ArrayList();
                n9 = buffer.readInt();
                bl = false;
                n2 = 0;
                n2 = 0;
                n = n9;
                while (n2 < n) {
                    int it2 = n2++;
                    boolean bl6 = false;
                    Collection collection = list;
                    CompiledParameter compiledParameter = CompiledParameter.Companion.deserializeFrom(buffer);
                    boolean bl7 = false;
                    collection.add(compiledParameter);
                }
                Collection collection = functionParameters;
                bl = false;
                collection.add(list);
            }
            n6 = 0;
            List functions = new ArrayList();
            n6 = buffer.readInt();
            n7 = 0;
            n8 = 0;
            n8 = 0;
            int n10 = n6;
            while (n8 < n10) {
                int it = n8++;
                boolean bl8 = false;
                list = functions;
                CompiledFunction compiledFunction = CompiledFunction.Companion.deserializeFrom(buffer);
                n2 = 0;
                list.add(compiledFunction);
            }
            n7 = 0;
            List nodes = new ArrayList();
            n7 = buffer.readInt();
            n8 = 0;
            n10 = 0;
            n10 = 0;
            int n11 = n7;
            while (n10 < n11) {
                int it = n10++;
                boolean bl9 = false;
                Collection collection = nodes;
                CompiledNode compiledNode = CompiledNode.Companion.deserializeFrom(buffer);
                n = 0;
                collection.add(compiledNode);
            }
            return new CompiledSource(longPool, stringPool, functionParameters, functions, nodes);
        }

        @Override
        @NotNull
        public CompiledSource fromBytes(@NotNull ByteString source) {
            return Deserializer.DefaultImpls.fromBytes(this, source);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

