/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.lin.bytecode;

import com.github.adriantodt.lin.bytecode.Label;
import com.github.adriantodt.lin.bytecode.insn.Insn;
import com.github.adriantodt.lin.utils.Deserializer;
import com.github.adriantodt.lin.utils.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "Lcom/github/adriantodt/lin/utils/Serializable;", "instructions", "", "Lcom/github/adriantodt/lin/bytecode/insn/Insn;", "labels", "Lcom/github/adriantodt/lin/bytecode/Label;", "(Ljava/util/List;Ljava/util/List;)V", "getInstructions", "()Ljava/util/List;", "getLabels", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "resolveLabel", "code", "serializeTo", "", "buffer", "Lokio/Buffer;", "toString", "", "Companion", "lin"})
public final class CompiledNode
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Insn> instructions;
    @NotNull
    private final List<Label> labels;

    public CompiledNode(@NotNull List<? extends Insn> instructions, @NotNull List<Label> labels) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        this.instructions = instructions;
        this.labels = labels;
    }

    @NotNull
    public final List<Insn> getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final List<Label> getLabels() {
        return this.labels;
    }

    @Override
    public void serializeTo(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeInt(this.instructions.size());
        for (Insn insn : this.instructions) {
            insn.serializeTo(buffer);
        }
        buffer.writeInt(this.labels.size());
        Iterable $this$sortedBy$iv = this.labels;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        for (Label label : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Label it = (Label)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getCode());
                it = (Label)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getCode();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        })) {
            label.serializeTo(buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int resolveLabel(int code) {
        void $this$binarySearchBy$iv;
        List<Label> list = this.labels;
        Comparable key$iv = Integer.valueOf(code);
        int fromIndex$iv = 0;
        int toIndex$iv = $this$binarySearchBy$iv.size();
        boolean $i$f$binarySearchBy = false;
        int indexOf = CollectionsKt.binarySearch((List)$this$binarySearchBy$iv, (int)fromIndex$iv, (int)toIndex$iv, (Function1)((Function1)new Function1<Label, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                this.$key = comparable;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final int invoke(Object it) {
                Label it2 = (Label)it;
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(it2.getCode()), (Comparable)this.$key);
            }
        }));
        boolean bl = indexOf >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Label " + code + " was not found.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.labels.get(indexOf).getAt();
    }

    @Override
    @NotNull
    public ByteString toBytes() {
        return Serializable.DefaultImpls.toBytes(this);
    }

    @NotNull
    public final List<Insn> component1() {
        return this.instructions;
    }

    @NotNull
    public final List<Label> component2() {
        return this.labels;
    }

    @NotNull
    public final CompiledNode copy(@NotNull List<? extends Insn> instructions, @NotNull List<Label> labels) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        return new CompiledNode(instructions, labels);
    }

    public static /* synthetic */ CompiledNode copy$default(CompiledNode compiledNode, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = compiledNode.instructions;
        }
        if ((n & 2) != 0) {
            list2 = compiledNode.labels;
        }
        return compiledNode.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "CompiledNode(instructions=" + this.instructions + ", labels=" + this.labels + ")";
    }

    public int hashCode() {
        int result = ((Object)this.instructions).hashCode();
        result = result * 31 + ((Object)this.labels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompiledNode)) {
            return false;
        }
        CompiledNode compiledNode = (CompiledNode)other;
        if (!Intrinsics.areEqual(this.instructions, compiledNode.instructions)) {
            return false;
        }
        return Intrinsics.areEqual(this.labels, compiledNode.labels);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/adriantodt/lin/bytecode/CompiledNode$Companion;", "Lcom/github/adriantodt/lin/utils/Deserializer;", "Lcom/github/adriantodt/lin/bytecode/CompiledNode;", "()V", "deserializeFrom", "buffer", "Lokio/Buffer;", "lin"})
    public static final class Companion
    implements Deserializer<CompiledNode> {
        private Companion() {
        }

        @Override
        @NotNull
        public CompiledNode deserializeFrom(@NotNull Buffer buffer) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int n = 0;
            List instructions = new ArrayList();
            n = buffer.readInt();
            int n2 = 0;
            int n3 = 0;
            n3 = 0;
            int n4 = n;
            while (n3 < n4) {
                int it = n3++;
                boolean bl = false;
                Collection collection = instructions;
                object = Insn.Companion.deserializeFrom(buffer);
                boolean bl2 = false;
                collection.add(object);
            }
            n2 = 0;
            List labels = new ArrayList();
            n2 = buffer.readInt();
            n3 = 0;
            n4 = 0;
            n4 = 0;
            int n5 = n2;
            while (n4 < n5) {
                int it = n4++;
                boolean bl = false;
                object = labels;
                Label label = Label.Companion.deserializeFrom(buffer);
                boolean bl3 = false;
                object.add(label);
            }
            return new CompiledNode(instructions, labels);
        }

        @Override
        @NotNull
        public CompiledNode fromBytes(@NotNull ByteString source) {
            return Deserializer.DefaultImpls.fromBytes(this, source);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

