/*
 * Decompiled with CFR 0.152.
 */
package com.github.adriantodt.unifiedplatform.js;

import com.github.adriantodt.unifiedplatform.js.BrowserInfo;
import com.github.adriantodt.unifiedplatform.js.EngineInfo;
import com.github.adriantodt.unifiedplatform.js.OsInfo;
import com.github.adriantodt.unifiedplatform.js.PlatformInfo;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment;", "", "()V", "Browser", "Node", "Unknown", "Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment$Browser;", "Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment$Node;", "Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment$Unknown;", "kotlin-unified-platform"})
public abstract class JsEnvironment {
    private JsEnvironment() {
    }

    public /* synthetic */ JsEnvironment(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment$Browser;", "Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment;", "isWebWorker", "", "browser", "Lcom/github/adriantodt/unifiedplatform/js/BrowserInfo;", "engine", "Lcom/github/adriantodt/unifiedplatform/js/EngineInfo;", "platform", "Lcom/github/adriantodt/unifiedplatform/js/PlatformInfo;", "osInfo", "Lcom/github/adriantodt/unifiedplatform/js/OsInfo;", "(ZLcom/github/adriantodt/unifiedplatform/js/BrowserInfo;Lcom/github/adriantodt/unifiedplatform/js/EngineInfo;Lcom/github/adriantodt/unifiedplatform/js/PlatformInfo;Lcom/github/adriantodt/unifiedplatform/js/OsInfo;)V", "getBrowser", "()Lcom/github/adriantodt/unifiedplatform/js/BrowserInfo;", "getEngine", "()Lcom/github/adriantodt/unifiedplatform/js/EngineInfo;", "()Z", "getOsInfo", "()Lcom/github/adriantodt/unifiedplatform/js/OsInfo;", "getPlatform", "()Lcom/github/adriantodt/unifiedplatform/js/PlatformInfo;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-unified-platform"})
    public static final class Browser
    extends JsEnvironment {
        private final boolean isWebWorker;
        @NotNull
        private final BrowserInfo browser;
        @NotNull
        private final EngineInfo engine;
        @NotNull
        private final PlatformInfo platform;
        @NotNull
        private final OsInfo osInfo;

        public Browser(boolean isWebWorker, @NotNull BrowserInfo browser, @NotNull EngineInfo engine, @NotNull PlatformInfo platform, @NotNull OsInfo osInfo) {
            Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter((Object)osInfo, (String)"osInfo");
            super(null);
            this.isWebWorker = isWebWorker;
            this.browser = browser;
            this.engine = engine;
            this.platform = platform;
            this.osInfo = osInfo;
        }

        public final boolean isWebWorker() {
            return this.isWebWorker;
        }

        @NotNull
        public final BrowserInfo getBrowser() {
            return this.browser;
        }

        @NotNull
        public final EngineInfo getEngine() {
            return this.engine;
        }

        @NotNull
        public final PlatformInfo getPlatform() {
            return this.platform;
        }

        @NotNull
        public final OsInfo getOsInfo() {
            return this.osInfo;
        }

        @NotNull
        public String toString() {
            return (this.isWebWorker ? "browser-webworker" : "browser") + ", " + this.browser + ", " + this.engine + ", " + this.platform + ", " + this.osInfo;
        }

        public final boolean component1() {
            return this.isWebWorker;
        }

        @NotNull
        public final BrowserInfo component2() {
            return this.browser;
        }

        @NotNull
        public final EngineInfo component3() {
            return this.engine;
        }

        @NotNull
        public final PlatformInfo component4() {
            return this.platform;
        }

        @NotNull
        public final OsInfo component5() {
            return this.osInfo;
        }

        @NotNull
        public final Browser copy(boolean isWebWorker, @NotNull BrowserInfo browser, @NotNull EngineInfo engine, @NotNull PlatformInfo platform, @NotNull OsInfo osInfo) {
            Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter((Object)osInfo, (String)"osInfo");
            return new Browser(isWebWorker, browser, engine, platform, osInfo);
        }

        public static /* synthetic */ Browser copy$default(Browser browser, boolean bl, BrowserInfo browserInfo, EngineInfo engineInfo, PlatformInfo platformInfo, OsInfo osInfo, int n, Object object) {
            if ((n & 1) != 0) {
                bl = browser.isWebWorker;
            }
            if ((n & 2) != 0) {
                browserInfo = browser.browser;
            }
            if ((n & 4) != 0) {
                engineInfo = browser.engine;
            }
            if ((n & 8) != 0) {
                platformInfo = browser.platform;
            }
            if ((n & 0x10) != 0) {
                osInfo = browser.osInfo;
            }
            return browser.copy(bl, browserInfo, engineInfo, platformInfo, osInfo);
        }

        public int hashCode() {
            int n = this.isWebWorker ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + this.browser.hashCode();
            result = result * 31 + this.engine.hashCode();
            result = result * 31 + this.platform.hashCode();
            result = result * 31 + this.osInfo.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Browser)) {
                return false;
            }
            Browser browser = (Browser)other;
            if (this.isWebWorker != browser.isWebWorker) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.browser, (Object)browser.browser)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.engine, (Object)browser.engine)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.platform, (Object)browser.platform)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.osInfo, (Object)browser.osInfo);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment$Node;", "Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment;", "model", "", "arch", "platform", "type", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "getModel", "getPlatform", "getType", "getVersion", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin-unified-platform"})
    public static final class Node
    extends JsEnvironment {
        @NotNull
        private final String model;
        @NotNull
        private final String arch;
        @NotNull
        private final String platform;
        @NotNull
        private final String type;
        @NotNull
        private final String version;

        public Node(@NotNull String model, @NotNull String arch, @NotNull String platform, @NotNull String type, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.model = model;
            this.arch = arch;
            this.platform = platform;
            this.type = type;
            this.version = version;
        }

        @NotNull
        public final String getModel() {
            return this.model;
        }

        @NotNull
        public final String getArch() {
            return this.arch;
        }

        @NotNull
        public final String getPlatform() {
            return this.platform;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("node-").append(this.version).append(", ").append(this.platform);
            String string = this.arch;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
            return stringBuilder.append(string3).toString();
        }

        @NotNull
        public final String component1() {
            return this.model;
        }

        @NotNull
        public final String component2() {
            return this.arch;
        }

        @NotNull
        public final String component3() {
            return this.platform;
        }

        @NotNull
        public final String component4() {
            return this.type;
        }

        @NotNull
        public final String component5() {
            return this.version;
        }

        @NotNull
        public final Node copy(@NotNull String model, @NotNull String arch, @NotNull String platform, @NotNull String type, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new Node(model, arch, platform, type, version);
        }

        public static /* synthetic */ Node copy$default(Node node, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = node.model;
            }
            if ((n & 2) != 0) {
                string2 = node.arch;
            }
            if ((n & 4) != 0) {
                string3 = node.platform;
            }
            if ((n & 8) != 0) {
                string4 = node.type;
            }
            if ((n & 0x10) != 0) {
                string5 = node.version;
            }
            return node.copy(string, string2, string3, string4, string5);
        }

        public int hashCode() {
            int result = this.model.hashCode();
            result = result * 31 + this.arch.hashCode();
            result = result * 31 + this.platform.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.version.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (!Intrinsics.areEqual((Object)this.model, (Object)node.model)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.arch, (Object)node.arch)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.platform, (Object)node.platform)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)node.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)node.version);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment$Unknown;", "Lcom/github/adriantodt/unifiedplatform/js/JsEnvironment;", "()V", "toString", "", "kotlin-unified-platform"})
    public static final class Unknown
    extends JsEnvironment {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "unknown";
        }
    }
}

