(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'bowser'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('bowser'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-unified-platform-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-unified-platform-js-legacy'.");
    }if (typeof bowser === 'undefined') {
      throw new Error("Error loading module 'kotlin-unified-platform-js-legacy'. Its dependency 'bowser' was not found. Please, check whether 'bowser' is loaded prior to 'kotlin-unified-platform-js-legacy'.");
    }root['kotlin-unified-platform-js-legacy'] = factory(typeof this['kotlin-unified-platform-js-legacy'] === 'undefined' ? {} : this['kotlin-unified-platform-js-legacy'], kotlin, bowser);
  }
}(this, function (_, Kotlin, $module$bowser) {
  'use strict';
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var toString = Kotlin.toString;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var throwCCE = Kotlin.throwCCE;
  var parse = $module$bowser.parse;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var equals = Kotlin.kotlin.text.equals_igcy3c$;
  var Any = Object;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var Map = Kotlin.kotlin.collections.Map;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  CpuArchitecture.prototype = Object.create(Enum.prototype);
  CpuArchitecture.prototype.constructor = CpuArchitecture;
  JavaVersion.prototype = Object.create(Enum.prototype);
  JavaVersion.prototype.constructor = JavaVersion;
  OsFamily.prototype = Object.create(Enum.prototype);
  OsFamily.prototype.constructor = OsFamily;
  UnifiedPlatform$Native.prototype = Object.create(UnifiedPlatform.prototype);
  UnifiedPlatform$Native.prototype.constructor = UnifiedPlatform$Native;
  UnifiedPlatform$Java.prototype = Object.create(UnifiedPlatform.prototype);
  UnifiedPlatform$Java.prototype.constructor = UnifiedPlatform$Java;
  UnifiedPlatform$JavaScript.prototype = Object.create(UnifiedPlatform.prototype);
  UnifiedPlatform$JavaScript.prototype.constructor = UnifiedPlatform$JavaScript;
  JsEnvironment$Browser.prototype = Object.create(JsEnvironment.prototype);
  JsEnvironment$Browser.prototype.constructor = JsEnvironment$Browser;
  JsEnvironment$Node.prototype = Object.create(JsEnvironment.prototype);
  JsEnvironment$Node.prototype.constructor = JsEnvironment$Node;
  JsEnvironment$Unknown.prototype = Object.create(JsEnvironment.prototype);
  JsEnvironment$Unknown.prototype.constructor = JsEnvironment$Unknown;
  function CpuArchitecture(name, ordinal, bitness) {
    Enum.call(this);
    this.bitness = bitness;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function CpuArchitecture_initFields() {
    CpuArchitecture_initFields = function () {
    };
    CpuArchitecture$UNKNOWN_instance = new CpuArchitecture('UNKNOWN', 0, -1);
    CpuArchitecture$ARM32_instance = new CpuArchitecture('ARM32', 1, 32);
    CpuArchitecture$ARM64_instance = new CpuArchitecture('ARM64', 2, 64);
    CpuArchitecture$X86_instance = new CpuArchitecture('X86', 3, 32);
    CpuArchitecture$X64_instance = new CpuArchitecture('X64', 4, 64);
    CpuArchitecture$MIPS32_instance = new CpuArchitecture('MIPS32', 5, 32);
    CpuArchitecture$MIPSEL32_instance = new CpuArchitecture('MIPSEL32', 6, 32);
    CpuArchitecture$WASM32_instance = new CpuArchitecture('WASM32', 7, 32);
  }
  var CpuArchitecture$UNKNOWN_instance;
  function CpuArchitecture$UNKNOWN_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$UNKNOWN_instance;
  }
  var CpuArchitecture$ARM32_instance;
  function CpuArchitecture$ARM32_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$ARM32_instance;
  }
  var CpuArchitecture$ARM64_instance;
  function CpuArchitecture$ARM64_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$ARM64_instance;
  }
  var CpuArchitecture$X86_instance;
  function CpuArchitecture$X86_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$X86_instance;
  }
  var CpuArchitecture$X64_instance;
  function CpuArchitecture$X64_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$X64_instance;
  }
  var CpuArchitecture$MIPS32_instance;
  function CpuArchitecture$MIPS32_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$MIPS32_instance;
  }
  var CpuArchitecture$MIPSEL32_instance;
  function CpuArchitecture$MIPSEL32_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$MIPSEL32_instance;
  }
  var CpuArchitecture$WASM32_instance;
  function CpuArchitecture$WASM32_getInstance() {
    CpuArchitecture_initFields();
    return CpuArchitecture$WASM32_instance;
  }
  CpuArchitecture.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CpuArchitecture',
    interfaces: [Enum]
  };
  function CpuArchitecture$values() {
    return [CpuArchitecture$UNKNOWN_getInstance(), CpuArchitecture$ARM32_getInstance(), CpuArchitecture$ARM64_getInstance(), CpuArchitecture$X86_getInstance(), CpuArchitecture$X64_getInstance(), CpuArchitecture$MIPS32_getInstance(), CpuArchitecture$MIPSEL32_getInstance(), CpuArchitecture$WASM32_getInstance()];
  }
  CpuArchitecture.values = CpuArchitecture$values;
  function CpuArchitecture$valueOf(name) {
    switch (name) {
      case 'UNKNOWN':
        return CpuArchitecture$UNKNOWN_getInstance();
      case 'ARM32':
        return CpuArchitecture$ARM32_getInstance();
      case 'ARM64':
        return CpuArchitecture$ARM64_getInstance();
      case 'X86':
        return CpuArchitecture$X86_getInstance();
      case 'X64':
        return CpuArchitecture$X64_getInstance();
      case 'MIPS32':
        return CpuArchitecture$MIPS32_getInstance();
      case 'MIPSEL32':
        return CpuArchitecture$MIPSEL32_getInstance();
      case 'WASM32':
        return CpuArchitecture$WASM32_getInstance();
      default:throwISE('No enum constant com.github.adriantodt.unifiedplatform.CpuArchitecture.' + name);
    }
  }
  CpuArchitecture.valueOf_61zpoe$ = CpuArchitecture$valueOf;
  function JavaVersion(name, ordinal, versionName) {
    Enum.call(this);
    this.versionName = versionName;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function JavaVersion_initFields() {
    JavaVersion_initFields = function () {
    };
    JavaVersion$JAVA_1_6_instance = new JavaVersion('JAVA_1_6', 0, '1.6');
    JavaVersion$JAVA_1_7_instance = new JavaVersion('JAVA_1_7', 1, '1.7');
    JavaVersion$JAVA_1_8_instance = new JavaVersion('JAVA_1_8', 2, '1.8');
    JavaVersion$JAVA_9_instance = new JavaVersion('JAVA_9', 3, '9');
    JavaVersion$JAVA_10_instance = new JavaVersion('JAVA_10', 4, '10');
    JavaVersion$JAVA_11_instance = new JavaVersion('JAVA_11', 5, '11');
    JavaVersion$JAVA_12_instance = new JavaVersion('JAVA_12', 6, '12');
    JavaVersion$JAVA_13_instance = new JavaVersion('JAVA_13', 7, '13');
    JavaVersion$JAVA_14_instance = new JavaVersion('JAVA_14', 8, '14');
    JavaVersion$JAVA_15_instance = new JavaVersion('JAVA_15', 9, '15');
    JavaVersion$JAVA_16_instance = new JavaVersion('JAVA_16', 10, '16');
    JavaVersion$JAVA_17_instance = new JavaVersion('JAVA_17', 11, '17');
    JavaVersion$UNKNOWN_instance = new JavaVersion('UNKNOWN', 12, 'unknown');
  }
  var JavaVersion$JAVA_1_6_instance;
  function JavaVersion$JAVA_1_6_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_1_6_instance;
  }
  var JavaVersion$JAVA_1_7_instance;
  function JavaVersion$JAVA_1_7_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_1_7_instance;
  }
  var JavaVersion$JAVA_1_8_instance;
  function JavaVersion$JAVA_1_8_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_1_8_instance;
  }
  var JavaVersion$JAVA_9_instance;
  function JavaVersion$JAVA_9_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_9_instance;
  }
  var JavaVersion$JAVA_10_instance;
  function JavaVersion$JAVA_10_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_10_instance;
  }
  var JavaVersion$JAVA_11_instance;
  function JavaVersion$JAVA_11_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_11_instance;
  }
  var JavaVersion$JAVA_12_instance;
  function JavaVersion$JAVA_12_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_12_instance;
  }
  var JavaVersion$JAVA_13_instance;
  function JavaVersion$JAVA_13_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_13_instance;
  }
  var JavaVersion$JAVA_14_instance;
  function JavaVersion$JAVA_14_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_14_instance;
  }
  var JavaVersion$JAVA_15_instance;
  function JavaVersion$JAVA_15_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_15_instance;
  }
  var JavaVersion$JAVA_16_instance;
  function JavaVersion$JAVA_16_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_16_instance;
  }
  var JavaVersion$JAVA_17_instance;
  function JavaVersion$JAVA_17_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$JAVA_17_instance;
  }
  var JavaVersion$UNKNOWN_instance;
  function JavaVersion$UNKNOWN_getInstance() {
    JavaVersion_initFields();
    return JavaVersion$UNKNOWN_instance;
  }
  JavaVersion.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JavaVersion',
    interfaces: [Enum]
  };
  function JavaVersion$values() {
    return [JavaVersion$JAVA_1_6_getInstance(), JavaVersion$JAVA_1_7_getInstance(), JavaVersion$JAVA_1_8_getInstance(), JavaVersion$JAVA_9_getInstance(), JavaVersion$JAVA_10_getInstance(), JavaVersion$JAVA_11_getInstance(), JavaVersion$JAVA_12_getInstance(), JavaVersion$JAVA_13_getInstance(), JavaVersion$JAVA_14_getInstance(), JavaVersion$JAVA_15_getInstance(), JavaVersion$JAVA_16_getInstance(), JavaVersion$JAVA_17_getInstance(), JavaVersion$UNKNOWN_getInstance()];
  }
  JavaVersion.values = JavaVersion$values;
  function JavaVersion$valueOf(name) {
    switch (name) {
      case 'JAVA_1_6':
        return JavaVersion$JAVA_1_6_getInstance();
      case 'JAVA_1_7':
        return JavaVersion$JAVA_1_7_getInstance();
      case 'JAVA_1_8':
        return JavaVersion$JAVA_1_8_getInstance();
      case 'JAVA_9':
        return JavaVersion$JAVA_9_getInstance();
      case 'JAVA_10':
        return JavaVersion$JAVA_10_getInstance();
      case 'JAVA_11':
        return JavaVersion$JAVA_11_getInstance();
      case 'JAVA_12':
        return JavaVersion$JAVA_12_getInstance();
      case 'JAVA_13':
        return JavaVersion$JAVA_13_getInstance();
      case 'JAVA_14':
        return JavaVersion$JAVA_14_getInstance();
      case 'JAVA_15':
        return JavaVersion$JAVA_15_getInstance();
      case 'JAVA_16':
        return JavaVersion$JAVA_16_getInstance();
      case 'JAVA_17':
        return JavaVersion$JAVA_17_getInstance();
      case 'UNKNOWN':
        return JavaVersion$UNKNOWN_getInstance();
      default:throwISE('No enum constant com.github.adriantodt.unifiedplatform.JavaVersion.' + name);
    }
  }
  JavaVersion.valueOf_61zpoe$ = JavaVersion$valueOf;
  function OsFamily(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OsFamily_initFields() {
    OsFamily_initFields = function () {
    };
    OsFamily$UNKNOWN_instance = new OsFamily('UNKNOWN', 0);
    OsFamily$MACOSX_instance = new OsFamily('MACOSX', 1);
    OsFamily$IOS_instance = new OsFamily('IOS', 2);
    OsFamily$LINUX_instance = new OsFamily('LINUX', 3);
    OsFamily$WINDOWS_instance = new OsFamily('WINDOWS', 4);
    OsFamily$ANDROID_instance = new OsFamily('ANDROID', 5);
    OsFamily$WASM_instance = new OsFamily('WASM', 6);
    OsFamily$TVOS_instance = new OsFamily('TVOS', 7);
    OsFamily$WATCHOS_instance = new OsFamily('WATCHOS', 8);
  }
  var OsFamily$UNKNOWN_instance;
  function OsFamily$UNKNOWN_getInstance() {
    OsFamily_initFields();
    return OsFamily$UNKNOWN_instance;
  }
  var OsFamily$MACOSX_instance;
  function OsFamily$MACOSX_getInstance() {
    OsFamily_initFields();
    return OsFamily$MACOSX_instance;
  }
  var OsFamily$IOS_instance;
  function OsFamily$IOS_getInstance() {
    OsFamily_initFields();
    return OsFamily$IOS_instance;
  }
  var OsFamily$LINUX_instance;
  function OsFamily$LINUX_getInstance() {
    OsFamily_initFields();
    return OsFamily$LINUX_instance;
  }
  var OsFamily$WINDOWS_instance;
  function OsFamily$WINDOWS_getInstance() {
    OsFamily_initFields();
    return OsFamily$WINDOWS_instance;
  }
  var OsFamily$ANDROID_instance;
  function OsFamily$ANDROID_getInstance() {
    OsFamily_initFields();
    return OsFamily$ANDROID_instance;
  }
  var OsFamily$WASM_instance;
  function OsFamily$WASM_getInstance() {
    OsFamily_initFields();
    return OsFamily$WASM_instance;
  }
  var OsFamily$TVOS_instance;
  function OsFamily$TVOS_getInstance() {
    OsFamily_initFields();
    return OsFamily$TVOS_instance;
  }
  var OsFamily$WATCHOS_instance;
  function OsFamily$WATCHOS_getInstance() {
    OsFamily_initFields();
    return OsFamily$WATCHOS_instance;
  }
  OsFamily.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OsFamily',
    interfaces: [Enum]
  };
  function OsFamily$values() {
    return [OsFamily$UNKNOWN_getInstance(), OsFamily$MACOSX_getInstance(), OsFamily$IOS_getInstance(), OsFamily$LINUX_getInstance(), OsFamily$WINDOWS_getInstance(), OsFamily$ANDROID_getInstance(), OsFamily$WASM_getInstance(), OsFamily$TVOS_getInstance(), OsFamily$WATCHOS_getInstance()];
  }
  OsFamily.values = OsFamily$values;
  function OsFamily$valueOf(name) {
    switch (name) {
      case 'UNKNOWN':
        return OsFamily$UNKNOWN_getInstance();
      case 'MACOSX':
        return OsFamily$MACOSX_getInstance();
      case 'IOS':
        return OsFamily$IOS_getInstance();
      case 'LINUX':
        return OsFamily$LINUX_getInstance();
      case 'WINDOWS':
        return OsFamily$WINDOWS_getInstance();
      case 'ANDROID':
        return OsFamily$ANDROID_getInstance();
      case 'WASM':
        return OsFamily$WASM_getInstance();
      case 'TVOS':
        return OsFamily$TVOS_getInstance();
      case 'WATCHOS':
        return OsFamily$WATCHOS_getInstance();
      default:throwISE('No enum constant com.github.adriantodt.unifiedplatform.OsFamily.' + name);
    }
  }
  OsFamily.valueOf_61zpoe$ = OsFamily$valueOf;
  function UnifiedPlatform() {
  }
  function UnifiedPlatform$Native(osFamily, cpuArchitecture) {
    UnifiedPlatform.call(this);
    this.osFamily = osFamily;
    this.cpuArchitecture = cpuArchitecture;
  }
  UnifiedPlatform$Native.prototype.toString = function () {
    return '[native, ' + this.osFamily.name.toLowerCase() + this.cpuArchitecture.name + ']';
  };
  UnifiedPlatform$Native.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Native',
    interfaces: [UnifiedPlatform]
  };
  UnifiedPlatform$Native.prototype.component1 = function () {
    return this.osFamily;
  };
  UnifiedPlatform$Native.prototype.component2 = function () {
    return this.cpuArchitecture;
  };
  UnifiedPlatform$Native.prototype.copy_acro09$ = function (osFamily, cpuArchitecture) {
    return new UnifiedPlatform$Native(osFamily === void 0 ? this.osFamily : osFamily, cpuArchitecture === void 0 ? this.cpuArchitecture : cpuArchitecture);
  };
  UnifiedPlatform$Native.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.osFamily) | 0;
    result = result * 31 + Kotlin.hashCode(this.cpuArchitecture) | 0;
    return result;
  };
  UnifiedPlatform$Native.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.osFamily, other.osFamily) && Kotlin.equals(this.cpuArchitecture, other.cpuArchitecture)))));
  };
  function UnifiedPlatform$Java(osFamily, version) {
    UnifiedPlatform.call(this);
    this.osFamily = osFamily;
    this.version = version;
  }
  UnifiedPlatform$Java.prototype.toString = function () {
    return '[jvm-v' + this.version.versionName + ', ' + this.osFamily.name.toLowerCase() + ']';
  };
  UnifiedPlatform$Java.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Java',
    interfaces: [UnifiedPlatform]
  };
  UnifiedPlatform$Java.prototype.component1 = function () {
    return this.osFamily;
  };
  UnifiedPlatform$Java.prototype.component2 = function () {
    return this.version;
  };
  UnifiedPlatform$Java.prototype.copy_u5ln1u$ = function (osFamily, version) {
    return new UnifiedPlatform$Java(osFamily === void 0 ? this.osFamily : osFamily, version === void 0 ? this.version : version);
  };
  UnifiedPlatform$Java.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.osFamily) | 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    return result;
  };
  UnifiedPlatform$Java.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.osFamily, other.osFamily) && Kotlin.equals(this.version, other.version)))));
  };
  function UnifiedPlatform$JavaScript(osFamily, environment) {
    UnifiedPlatform.call(this);
    this.osFamily = osFamily;
    this.environment = environment;
  }
  UnifiedPlatform$JavaScript.prototype.toString = function () {
    return '[js, ' + this.environment + ']';
  };
  UnifiedPlatform$JavaScript.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JavaScript',
    interfaces: [UnifiedPlatform]
  };
  UnifiedPlatform$JavaScript.prototype.component1 = function () {
    return this.osFamily;
  };
  UnifiedPlatform$JavaScript.prototype.component2 = function () {
    return this.environment;
  };
  UnifiedPlatform$JavaScript.prototype.copy_fqz2nr$ = function (osFamily, environment) {
    return new UnifiedPlatform$JavaScript(osFamily === void 0 ? this.osFamily : osFamily, environment === void 0 ? this.environment : environment);
  };
  UnifiedPlatform$JavaScript.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.osFamily) | 0;
    result = result * 31 + Kotlin.hashCode(this.environment) | 0;
    return result;
  };
  UnifiedPlatform$JavaScript.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.osFamily, other.osFamily) && Kotlin.equals(this.environment, other.environment)))));
  };
  UnifiedPlatform.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnifiedPlatform',
    interfaces: []
  };
  function BrowserInfo(name, version) {
    this.name = name;
    this.version = version;
  }
  BrowserInfo.prototype.toString = function () {
    var tmp$;
    if (this.name != null && this.version != null)
      tmp$ = toString(this.name) + ' v' + toString(this.version);
    else if (this.name != null && this.version == null)
      tmp$ = this.name;
    else
      tmp$ = '<unknown browser>';
    return tmp$;
  };
  BrowserInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BrowserInfo',
    interfaces: []
  };
  BrowserInfo.prototype.component1 = function () {
    return this.name;
  };
  BrowserInfo.prototype.component2 = function () {
    return this.version;
  };
  BrowserInfo.prototype.copy_rkkr90$ = function (name, version) {
    return new BrowserInfo(name === void 0 ? this.name : name, version === void 0 ? this.version : version);
  };
  BrowserInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    return result;
  };
  BrowserInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.name, other.name) && Kotlin.equals(this.version, other.version)))));
  };
  function EngineInfo(name, version) {
    this.name = name;
    this.version = version;
  }
  EngineInfo.prototype.toString = function () {
    var tmp$;
    if (this.name != null && this.version != null)
      tmp$ = toString(this.name) + ' v' + toString(this.version);
    else if (this.name != null && this.version == null)
      tmp$ = this.name;
    else
      tmp$ = '<unknown engine>';
    return tmp$;
  };
  EngineInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EngineInfo',
    interfaces: []
  };
  EngineInfo.prototype.component1 = function () {
    return this.name;
  };
  EngineInfo.prototype.component2 = function () {
    return this.version;
  };
  EngineInfo.prototype.copy_rkkr90$ = function (name, version) {
    return new EngineInfo(name === void 0 ? this.name : name, version === void 0 ? this.version : version);
  };
  EngineInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    return result;
  };
  EngineInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.name, other.name) && Kotlin.equals(this.version, other.version)))));
  };
  function JsEnvironment() {
  }
  function JsEnvironment$Browser(isWebWorker, browser, engine, platform, osInfo) {
    JsEnvironment.call(this);
    this.isWebWorker = isWebWorker;
    this.browser = browser;
    this.engine = engine;
    this.platform = platform;
    this.osInfo = osInfo;
  }
  JsEnvironment$Browser.prototype.toString = function () {
    return (this.isWebWorker ? 'browser-webworker' : 'browser') + ', ' + this.browser + ', ' + this.engine + ', ' + this.platform + ', ' + this.osInfo;
  };
  JsEnvironment$Browser.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Browser',
    interfaces: [JsEnvironment]
  };
  JsEnvironment$Browser.prototype.component1 = function () {
    return this.isWebWorker;
  };
  JsEnvironment$Browser.prototype.component2 = function () {
    return this.browser;
  };
  JsEnvironment$Browser.prototype.component3 = function () {
    return this.engine;
  };
  JsEnvironment$Browser.prototype.component4 = function () {
    return this.platform;
  };
  JsEnvironment$Browser.prototype.component5 = function () {
    return this.osInfo;
  };
  JsEnvironment$Browser.prototype.copy_iaqoda$ = function (isWebWorker, browser, engine, platform, osInfo) {
    return new JsEnvironment$Browser(isWebWorker === void 0 ? this.isWebWorker : isWebWorker, browser === void 0 ? this.browser : browser, engine === void 0 ? this.engine : engine, platform === void 0 ? this.platform : platform, osInfo === void 0 ? this.osInfo : osInfo);
  };
  JsEnvironment$Browser.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.isWebWorker) | 0;
    result = result * 31 + Kotlin.hashCode(this.browser) | 0;
    result = result * 31 + Kotlin.hashCode(this.engine) | 0;
    result = result * 31 + Kotlin.hashCode(this.platform) | 0;
    result = result * 31 + Kotlin.hashCode(this.osInfo) | 0;
    return result;
  };
  JsEnvironment$Browser.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.isWebWorker, other.isWebWorker) && Kotlin.equals(this.browser, other.browser) && Kotlin.equals(this.engine, other.engine) && Kotlin.equals(this.platform, other.platform) && Kotlin.equals(this.osInfo, other.osInfo)))));
  };
  function JsEnvironment$Node(model, arch, platform, type, version) {
    JsEnvironment.call(this);
    this.model = model;
    this.arch = arch;
    this.platform = platform;
    this.type = type;
    this.version = version;
  }
  JsEnvironment$Node.prototype.toString = function () {
    return 'node-' + this.version + ', ' + this.platform + this.arch.toUpperCase();
  };
  JsEnvironment$Node.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Node',
    interfaces: [JsEnvironment]
  };
  JsEnvironment$Node.prototype.component1 = function () {
    return this.model;
  };
  JsEnvironment$Node.prototype.component2 = function () {
    return this.arch;
  };
  JsEnvironment$Node.prototype.component3 = function () {
    return this.platform;
  };
  JsEnvironment$Node.prototype.component4 = function () {
    return this.type;
  };
  JsEnvironment$Node.prototype.component5 = function () {
    return this.version;
  };
  JsEnvironment$Node.prototype.copy_x0a6t6$ = function (model, arch, platform, type, version) {
    return new JsEnvironment$Node(model === void 0 ? this.model : model, arch === void 0 ? this.arch : arch, platform === void 0 ? this.platform : platform, type === void 0 ? this.type : type, version === void 0 ? this.version : version);
  };
  JsEnvironment$Node.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.model) | 0;
    result = result * 31 + Kotlin.hashCode(this.arch) | 0;
    result = result * 31 + Kotlin.hashCode(this.platform) | 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    return result;
  };
  JsEnvironment$Node.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.model, other.model) && Kotlin.equals(this.arch, other.arch) && Kotlin.equals(this.platform, other.platform) && Kotlin.equals(this.type, other.type) && Kotlin.equals(this.version, other.version)))));
  };
  function JsEnvironment$Unknown() {
    JsEnvironment$Unknown_instance = this;
    JsEnvironment.call(this);
  }
  JsEnvironment$Unknown.prototype.toString = function () {
    return 'unknown';
  };
  JsEnvironment$Unknown.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Unknown',
    interfaces: [JsEnvironment]
  };
  var JsEnvironment$Unknown_instance = null;
  function JsEnvironment$Unknown_getInstance() {
    if (JsEnvironment$Unknown_instance === null) {
      new JsEnvironment$Unknown();
    }return JsEnvironment$Unknown_instance;
  }
  JsEnvironment.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsEnvironment',
    interfaces: []
  };
  function OsInfo(name, version, versionName) {
    this.name = name;
    this.version = version;
    this.versionName = versionName;
  }
  OsInfo.prototype.toString = function () {
    if (this.name != null) {
      return this.name.toLowerCase();
    }return '<unknown operating system>';
  };
  OsInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OsInfo',
    interfaces: []
  };
  OsInfo.prototype.component1 = function () {
    return this.name;
  };
  OsInfo.prototype.component2 = function () {
    return this.version;
  };
  OsInfo.prototype.component3 = function () {
    return this.versionName;
  };
  OsInfo.prototype.copy_eaqb6n$ = function (name, version, versionName) {
    return new OsInfo(name === void 0 ? this.name : name, version === void 0 ? this.version : version, versionName === void 0 ? this.versionName : versionName);
  };
  OsInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    result = result * 31 + Kotlin.hashCode(this.versionName) | 0;
    return result;
  };
  OsInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.name, other.name) && Kotlin.equals(this.version, other.version) && Kotlin.equals(this.versionName, other.versionName)))));
  };
  function PlatformInfo(type, vendor, model) {
    this.type = type;
    this.vendor = vendor;
    this.model = model;
  }
  PlatformInfo.prototype.toString = function () {
    var tmp$;
    if (this.type != null)
      tmp$ = this.type;
    else
      tmp$ = '<unknown platform>';
    return tmp$;
  };
  PlatformInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PlatformInfo',
    interfaces: []
  };
  PlatformInfo.prototype.component1 = function () {
    return this.type;
  };
  PlatformInfo.prototype.component2 = function () {
    return this.vendor;
  };
  PlatformInfo.prototype.component3 = function () {
    return this.model;
  };
  PlatformInfo.prototype.copy_eaqb6n$ = function (type, vendor, model) {
    return new PlatformInfo(type === void 0 ? this.type : type, vendor === void 0 ? this.vendor : vendor, model === void 0 ? this.model : model);
  };
  PlatformInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.vendor) | 0;
    result = result * 31 + Kotlin.hashCode(this.model) | 0;
    return result;
  };
  PlatformInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.vendor, other.vendor) && Kotlin.equals(this.model, other.model)))));
  };
  var currentPlatform;
  function detectPlatform() {
    var tmp$;
    if (get_isBrowser() || get_isWebWorker())
      tmp$ = detectBrowserEnvironment();
    else if (get_isNode())
      tmp$ = detectNodeEnviroment();
    else
      tmp$ = new UnifiedPlatform$JavaScript(OsFamily$UNKNOWN_getInstance(), JsEnvironment$Unknown_getInstance());
    return tmp$;
  }
  function get_isBrowser() {
    var tmp$;
    return typeof (tmp$ = (typeof window !== 'undefined' && typeof window.document !== 'undefined')) === 'boolean' ? tmp$ : throwCCE();
  }
  function get_isWebWorker() {
    var tmp$;
    return typeof (tmp$ = (typeof self === 'object' && self.constructor && self.constructor.name === 'DedicatedWorkerGlobalScope')) === 'boolean' ? tmp$ : throwCCE();
  }
  function get_isNode() {
    var tmp$;
    return typeof (tmp$ = (typeof process !== 'undefined' && process.versions != null && process.versions.node != null)) === 'boolean' ? tmp$ : throwCCE();
  }
  function detectNodeEnviroment() {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var os = eval('require')('os');
    var process = eval('require')('process');
    var platform = typeof (tmp$ = os.platform()) === 'string' ? tmp$ : throwCCE();
    return new UnifiedPlatform$JavaScript(tryDetectOsFamily(platform), new JsEnvironment$Node(typeof (tmp$_0 = os.cpus()[0].model) === 'string' ? tmp$_0 : throwCCE(), typeof (tmp$_1 = os.arch()) === 'string' ? tmp$_1 : throwCCE(), platform, typeof (tmp$_2 = os.type()) === 'string' ? tmp$_2 : throwCCE(), typeof (tmp$_3 = process.version) === 'string' ? tmp$_3 : throwCCE()));
  }
  function detectBrowserEnvironment() {
    var tmp$, tmp$_0;
    if (get_isBrowser())
      tmp$_0 = window.navigator.userAgent;
    else if (get_isWebWorker())
      tmp$_0 = typeof (tmp$ = self.navigator.userAgent) === 'string' ? tmp$ : throwCCE();
    else {
      throw IllegalStateException_init('Not on a browser environment'.toString());
    }
    var userAgent = tmp$_0;
    var result = parse(userAgent);
    return new UnifiedPlatform$JavaScript(tryDetectOsFamily(result.os.name), new JsEnvironment$Browser(get_isWebWorker(), new BrowserInfo(result.browser.name, result.browser.version), new EngineInfo(result.engine.name, result.engine.version), new PlatformInfo(result.platform.type, result.platform.vendor, result.platform.model), new OsInfo(result.os.name, result.os.version, result.os.versionName)));
  }
  function tryDetectOsFamily(name) {
    var tmp$, tmp$_0;
    var $receiver = entriesOf($module$bowser.OS_MAP);
    var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16);
    var destination = LinkedHashMap_init(capacity);
    var tmp$_1;
    tmp$_1 = $receiver.iterator();
    while (tmp$_1.hasNext()) {
      var element = tmp$_1.next();
      var pair = to(element.second, element.first);
      destination.put_xwzc9p$(pair.first, pair.second);
    }
    var map = destination;
    var tmp$_2;
    tmp$ = (Kotlin.isType(tmp$_2 = map, Map) ? tmp$_2 : throwCCE()).get_11rb$(name);
    if (tmp$ == null) {
      return OsFamily$UNKNOWN_getInstance();
    }var shortName = tmp$;
    var $receiver_0 = OsFamily$values();
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$_3;
      for (tmp$_3 = 0; tmp$_3 !== $receiver_0.length; ++tmp$_3) {
        var element_0 = $receiver_0[tmp$_3];
        if (equals(element_0.name, shortName, true)) {
          firstOrNull$result = element_0;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return (tmp$_0 = firstOrNull$result) != null ? tmp$_0 : OsFamily$UNKNOWN_getInstance();
  }
  function entriesOf(jsObject) {
    var tmp$;
    var $receiver = (typeof (tmp$ = Object.entries) === 'function' ? tmp$ : throwCCE())(jsObject);
    var destination = ArrayList_init($receiver.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== $receiver.length; ++tmp$_0) {
      var item = $receiver[tmp$_0];
      var tmp$_1, tmp$_2;
      destination.add_11rb$(to((tmp$_1 = item[0]) == null || Kotlin.isType(tmp$_1, Any) ? tmp$_1 : throwCCE(), (tmp$_2 = item[1]) == null || Kotlin.isType(tmp$_2, Any) ? tmp$_2 : throwCCE()));
    }
    return destination;
  }
  Object.defineProperty(CpuArchitecture, 'UNKNOWN', {
    get: CpuArchitecture$UNKNOWN_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'ARM32', {
    get: CpuArchitecture$ARM32_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'ARM64', {
    get: CpuArchitecture$ARM64_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'X86', {
    get: CpuArchitecture$X86_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'X64', {
    get: CpuArchitecture$X64_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'MIPS32', {
    get: CpuArchitecture$MIPS32_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'MIPSEL32', {
    get: CpuArchitecture$MIPSEL32_getInstance
  });
  Object.defineProperty(CpuArchitecture, 'WASM32', {
    get: CpuArchitecture$WASM32_getInstance
  });
  var package$com = _.com || (_.com = {});
  var package$github = package$com.github || (package$com.github = {});
  var package$adriantodt = package$github.adriantodt || (package$github.adriantodt = {});
  var package$unifiedplatform = package$adriantodt.unifiedplatform || (package$adriantodt.unifiedplatform = {});
  package$unifiedplatform.CpuArchitecture = CpuArchitecture;
  Object.defineProperty(JavaVersion, 'JAVA_1_6', {
    get: JavaVersion$JAVA_1_6_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_1_7', {
    get: JavaVersion$JAVA_1_7_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_1_8', {
    get: JavaVersion$JAVA_1_8_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_9', {
    get: JavaVersion$JAVA_9_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_10', {
    get: JavaVersion$JAVA_10_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_11', {
    get: JavaVersion$JAVA_11_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_12', {
    get: JavaVersion$JAVA_12_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_13', {
    get: JavaVersion$JAVA_13_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_14', {
    get: JavaVersion$JAVA_14_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_15', {
    get: JavaVersion$JAVA_15_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_16', {
    get: JavaVersion$JAVA_16_getInstance
  });
  Object.defineProperty(JavaVersion, 'JAVA_17', {
    get: JavaVersion$JAVA_17_getInstance
  });
  Object.defineProperty(JavaVersion, 'UNKNOWN', {
    get: JavaVersion$UNKNOWN_getInstance
  });
  package$unifiedplatform.JavaVersion = JavaVersion;
  Object.defineProperty(OsFamily, 'UNKNOWN', {
    get: OsFamily$UNKNOWN_getInstance
  });
  Object.defineProperty(OsFamily, 'MACOSX', {
    get: OsFamily$MACOSX_getInstance
  });
  Object.defineProperty(OsFamily, 'IOS', {
    get: OsFamily$IOS_getInstance
  });
  Object.defineProperty(OsFamily, 'LINUX', {
    get: OsFamily$LINUX_getInstance
  });
  Object.defineProperty(OsFamily, 'WINDOWS', {
    get: OsFamily$WINDOWS_getInstance
  });
  Object.defineProperty(OsFamily, 'ANDROID', {
    get: OsFamily$ANDROID_getInstance
  });
  Object.defineProperty(OsFamily, 'WASM', {
    get: OsFamily$WASM_getInstance
  });
  Object.defineProperty(OsFamily, 'TVOS', {
    get: OsFamily$TVOS_getInstance
  });
  Object.defineProperty(OsFamily, 'WATCHOS', {
    get: OsFamily$WATCHOS_getInstance
  });
  package$unifiedplatform.OsFamily = OsFamily;
  UnifiedPlatform.Native = UnifiedPlatform$Native;
  UnifiedPlatform.Java = UnifiedPlatform$Java;
  UnifiedPlatform.JavaScript = UnifiedPlatform$JavaScript;
  package$unifiedplatform.UnifiedPlatform = UnifiedPlatform;
  var package$js = package$unifiedplatform.js || (package$unifiedplatform.js = {});
  package$js.BrowserInfo = BrowserInfo;
  package$js.EngineInfo = EngineInfo;
  JsEnvironment.Browser = JsEnvironment$Browser;
  JsEnvironment.Node = JsEnvironment$Node;
  Object.defineProperty(JsEnvironment, 'Unknown', {
    get: JsEnvironment$Unknown_getInstance
  });
  package$js.JsEnvironment = JsEnvironment;
  package$js.OsInfo = OsInfo;
  package$js.PlatformInfo = PlatformInfo;
  Object.defineProperty(package$unifiedplatform, 'currentPlatform', {
    get: function () {
      return currentPlatform;
    }
  });
  package$unifiedplatform.entriesOf_hl3vr8$ = entriesOf;
  currentPlatform = detectPlatform();
  Kotlin.defineModule('kotlin-unified-platform-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kotlin-unified-platform-js-legacy.js.map
