@file:Suppress("INTERFACE_WITH_SUPERCLASS", "OVERRIDING_FINAL_MEMBER", "RETURN_TYPE_MISMATCH_ON_OVERRIDE", "CONFLICTING_OVERLOADS")
package Bowser.Parser

import kotlin.js.*
import org.khronos.webgl.*
import org.w3c.dom.*
import org.w3c.dom.events.*
import org.w3c.dom.parsing.*
import org.w3c.dom.svg.*
import org.w3c.dom.url.*
import org.w3c.fetch.*
import org.w3c.files.*
import org.w3c.notifications.*
import org.w3c.performance.*
import org.w3c.workers.*
import org.w3c.xhr.*

external interface Parser {
    fun constructor(UA: String, skipParsing: Boolean = definedExternally): Parser
    fun getBrowser(): BrowserDetails
    fun getBrowserName(toLowerCase: Boolean = definedExternally): String
    fun getBrowserVersion(): String
    fun getOS(): OSDetails
    fun getOSName(toLowerCase: Boolean = definedExternally): String
    fun getOSVersion(): String
    fun getPlatform(): PlatformDetails
    fun getPlatformType(toLowerCase: Boolean = definedExternally): String
    fun getEngine(): EngineDetails
    fun getEngineName(): String
    fun getResult(): ParsedResult
    fun getUA(): String
    fun `is`(anything: Any): Boolean
    fun parse(): Parser
    fun parseBrowser(): BrowserDetails
    fun parseEngine(): EngineDetails
    fun parseOS(): OSDetails
    fun parsePlatform(): PlatformDetails
    fun satisfies(checkTree: checkTree): Boolean?
    fun isBrowser(browserName: String, includingAlias: Boolean = definedExternally): Boolean
    fun some(anythings: Array<String>): Boolean?
    fun test(regex: RegExp): Boolean
}

external interface ParsedResult {
    var browser: BrowserDetails
    var os: OSDetails
    var platform: PlatformDetails
    var engine: EngineDetails
}

external interface Details {
    var name: String?
        get() = definedExternally
        set(value) = definedExternally
    var version: String?
        get() = definedExternally
        set(value) = definedExternally
}

external interface OSDetails : Details {
    var versionName: String?
        get() = definedExternally
        set(value) = definedExternally
}

external interface PlatformDetails {
    var type: String?
        get() = definedExternally
        set(value) = definedExternally
    var vendor: String?
        get() = definedExternally
        set(value) = definedExternally
    var model: String?
        get() = definedExternally
        set(value) = definedExternally
}

typealias BrowserDetails = Details

typealias EngineDetails = Details

external interface checkTree {
    @nativeGetter
    operator fun get(key: String): Any?
    @nativeSetter
    operator fun set(key: String, value: Any)
}